#version 330 core

out vec4 FragColor;

in vec2 TexCoord;
in vec2 BTexCoord;
in vec4 Color;
in vec4 Viewport;
in mat4 ProjInv;
in vec4 FogColor;
in vec2 FogStartEnd;
in float FogFactor;

// Новые данные, передаем из вершинного шейдера
in vec3 EntityData;
in vec3 Normal;
in vec4 Tangent;
in vec2 MidTexCoord;

uniform sampler2D atlas;
uniform sampler2D lightTex;

void main()
{
	// Текстура из основного атласа
	vec4 texColor = texture(atlas, TexCoord
	#ifdef SHORT_UV
	/ 32768.0
	#endif
	);

	// Цвет с учетом передачи цвета
	vec4 colorMult = Color / 256.0;

	// Текстура с учетом яркости
	vec4 lightyColor = texture(lightTex, (BTexCoord + 8.0) / 256.0);

	// Смешивание цвета из текстуры и освещения
	vec4 rasterColor =
	#ifdef PASS_0
	vec4((texColor.xyz * colorMult.xyz) * lightyColor.xyz, texColor.w);
	#else
	(texColor * colorMult) * lightyColor;
	#endif

	// Использование нормалей и тангента для освещения
	vec3 lightDir = normalize(vec3(1.0, 1.0, 1.0)); // Пример источника света
	float diff = max(dot(Normal, lightDir), 0.0);    // Диффузное освещение
	vec3 diffuse = diff * lightyColor.xyz;           // Применяем освещение

	// Применяем освещение с учетом нормалей и тангента
	vec3 reflection = normalize(reflect(-lightDir, Normal));
	float spec = pow(max(dot(reflection, normalize(EntityData)), 0.0), 32.0); // Спекулярное освещение

	vec3 finalColor = (diffuse + spec) * rasterColor.xyz;

	FragColor = vec4(mix(FogColor.xyz, finalColor, FogFactor), rasterColor.w);
	#endif
}