/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.XRandR$Screen;

public class XRandR {
    private static XRandR$Screen[] current;
    private static Map<String, XRandR$Screen[]> screens;
    private static final Pattern SCREEN_PATTERN1;
    private static final Pattern SCREEN_PATTERN2;

    private static void populate() {
        if (screens == null) {
            screens = new HashMap<String, XRandR$Screen[]>();
            try {
                String string;
                Process process = Runtime.getRuntime().exec(new String[]{"xrandr", "-q"});
                ArrayList<XRandR$Screen> arrayList = new ArrayList<XRandR$Screen>();
                ArrayList<XRandR$Screen> arrayList2 = new ArrayList<XRandR$Screen>();
                String string2 = null;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((string = bufferedReader.readLine()) != null) {
                    String[] stringArray = (string = string.trim()).split("\\s+");
                    if ("connected".equals(stringArray[1])) {
                        if (string2 != null) {
                            screens.put(string2, arrayList2.toArray(new XRandR$Screen[arrayList2.size()]));
                            arrayList2.clear();
                        }
                        string2 = stringArray[0];
                        XRandR.parseScreen(arrayList, string2, "primary".equals(stringArray[2]) ? stringArray[3] : stringArray[2]);
                        continue;
                    }
                    if (!Pattern.matches("\\d*x\\d*", stringArray[0])) continue;
                    XRandR.parseScreen(arrayList2, string2, stringArray[0]);
                }
                screens.put(string2, arrayList2.toArray(new XRandR$Screen[arrayList2.size()]));
                current = arrayList.toArray(new XRandR$Screen[arrayList.size()]);
            }
            catch (Throwable throwable) {
                LWJGLUtil.log("Exception in XRandR.populate(): " + throwable.getMessage());
                screens.clear();
                current = new XRandR$Screen[0];
            }
        }
    }

    public static XRandR$Screen[] getConfiguration() {
        XRandR.populate();
        return (XRandR$Screen[])current.clone();
    }

    public static void setConfiguration(XRandR$Screen ... screens) {
        if (screens.length == 0) {
            throw new IllegalArgumentException("Must specify at least one screen");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("xrandr");
        for (XRandR$Screen xRandR$Screen : current) {
            boolean bl = false;
            for (XRandR$Screen xRandR$Screen2 : screens) {
                if (!xRandR$Screen2.name.equals(xRandR$Screen.name)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add("--output");
            arrayList.add(xRandR$Screen.name);
            arrayList.add("--off");
        }
        for (XRandR$Screen xRandR$Screen : screens) {
            XRandR$Screen.access$000(xRandR$Screen, arrayList);
        }
        try {
            String string;
            Process process = Runtime.getRuntime().exec(arrayList.toArray(new String[arrayList.size()]));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                LWJGLUtil.log("Unexpected output from xrandr process: " + string);
            }
            current = screens;
        }
        catch (IOException iOException) {
            LWJGLUtil.log("XRandR exception in setConfiguration(): " + iOException.getMessage());
        }
    }

    public static String[] getScreenNames() {
        XRandR.populate();
        return screens.keySet().toArray(new String[screens.size()]);
    }

    public static XRandR$Screen[] getResolutions(String name) {
        XRandR.populate();
        return (XRandR$Screen[])screens.get(name).clone();
    }

    private static void parseScreen(List<XRandR$Screen> list, String name, String what) {
        int n;
        int n2;
        Matcher matcher = SCREEN_PATTERN1.matcher(what);
        if (!matcher.matches() && !(matcher = SCREEN_PATTERN2.matcher(what)).matches()) {
            LWJGLUtil.log("Did not match: " + what);
            return;
        }
        int n3 = Integer.parseInt(matcher.group(1));
        int n4 = Integer.parseInt(matcher.group(2));
        if (matcher.groupCount() > 3) {
            n2 = Integer.parseInt(matcher.group(3));
            n = Integer.parseInt(matcher.group(4));
        } else {
            n2 = 0;
            n = 0;
        }
        list.add(new XRandR$Screen(name, n3, n4, n2, n, null));
    }

    static {
        SCREEN_PATTERN1 = Pattern.compile("^(\\d+)x(\\d+)\\+(\\d+)\\+(\\d+)$");
        SCREEN_PATTERN2 = Pattern.compile("^(\\d+)x(\\d+)$");
    }
}

