/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

public final class NVFence {
    public static final int GL_ALL_COMPLETED_NV = 34034;
    public static final int GL_FENCE_STATUS_NV = 34035;
    public static final int GL_FENCE_CONDITION_NV = 34036;

    private NVFence() {
    }

    public static void glGenFencesNV(IntBuffer piFences) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGenFencesNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(piFences);
        NVFence.nglGenFencesNV(piFences.remaining(), MemoryUtil.getAddress(piFences), l);
    }

    static native void nglGenFencesNV(int var0, long var1, long var3);

    public static int glGenFencesNV() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGenFencesNV;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        NVFence.nglGenFencesNV(1, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glDeleteFencesNV(IntBuffer piFences) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDeleteFencesNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(piFences);
        NVFence.nglDeleteFencesNV(piFences.remaining(), MemoryUtil.getAddress(piFences), l);
    }

    static native void nglDeleteFencesNV(int var0, long var1, long var3);

    public static void glDeleteFencesNV(int fence) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDeleteFencesNV;
        BufferChecks.checkFunctionAddress(l);
        NVFence.nglDeleteFencesNV(1, APIUtil.getInt(contextCapabilities, fence), l);
    }

    public static void glSetFenceNV(int fence, int condition) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glSetFenceNV;
        BufferChecks.checkFunctionAddress(l);
        NVFence.nglSetFenceNV(fence, condition, l);
    }

    static native void nglSetFenceNV(int var0, int var1, long var2);

    public static boolean glTestFenceNV(int fence) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTestFenceNV;
        BufferChecks.checkFunctionAddress(l);
        boolean bl = NVFence.nglTestFenceNV(fence, l);
        return bl;
    }

    static native boolean nglTestFenceNV(int var0, long var1);

    public static void glFinishFenceNV(int fence) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glFinishFenceNV;
        BufferChecks.checkFunctionAddress(l);
        NVFence.nglFinishFenceNV(fence, l);
    }

    static native void nglFinishFenceNV(int var0, long var1);

    public static boolean glIsFenceNV(int fence) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glIsFenceNV;
        BufferChecks.checkFunctionAddress(l);
        boolean bl = NVFence.nglIsFenceNV(fence, l);
        return bl;
    }

    static native boolean nglIsFenceNV(int var0, long var1);

    public static void glGetFenceivNV(int fence, int pname, IntBuffer piParams) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetFenceivNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(piParams, 4);
        NVFence.nglGetFenceivNV(fence, pname, MemoryUtil.getAddress(piParams), l);
    }

    static native void nglGetFenceivNV(int var0, int var1, long var2, long var4);
}

