/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.EXTDrawBuffers2;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.opengl.GLContext;

public final class EXTDirectStateAccess {
    public static final int GL_PROGRAM_MATRIX_EXT = 36397;
    public static final int GL_TRANSPOSE_PROGRAM_MATRIX_EXT = 36398;
    public static final int GL_PROGRAM_MATRIX_STACK_DEPTH_EXT = 36399;

    private EXTDirectStateAccess() {
    }

    public static void glClientAttribDefaultEXT(int mask) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glClientAttribDefaultEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglClientAttribDefaultEXT(mask, l);
    }

    static native void nglClientAttribDefaultEXT(int var0, long var1);

    public static void glPushClientAttribDefaultEXT(int mask) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPushClientAttribDefaultEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglPushClientAttribDefaultEXT(mask, l);
    }

    static native void nglPushClientAttribDefaultEXT(int var0, long var1);

    public static void glMatrixLoadEXT(int matrixMode, FloatBuffer m) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMatrixLoadfEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(m, 16);
        EXTDirectStateAccess.nglMatrixLoadfEXT(matrixMode, MemoryUtil.getAddress(m), l);
    }

    static native void nglMatrixLoadfEXT(int var0, long var1, long var3);

    public static void glMatrixLoadEXT(int matrixMode, DoubleBuffer m) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMatrixLoaddEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(m, 16);
        EXTDirectStateAccess.nglMatrixLoaddEXT(matrixMode, MemoryUtil.getAddress(m), l);
    }

    static native void nglMatrixLoaddEXT(int var0, long var1, long var3);

    public static void glMatrixMultEXT(int matrixMode, FloatBuffer m) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMatrixMultfEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(m, 16);
        EXTDirectStateAccess.nglMatrixMultfEXT(matrixMode, MemoryUtil.getAddress(m), l);
    }

    static native void nglMatrixMultfEXT(int var0, long var1, long var3);

    public static void glMatrixMultEXT(int matrixMode, DoubleBuffer m) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMatrixMultdEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(m, 16);
        EXTDirectStateAccess.nglMatrixMultdEXT(matrixMode, MemoryUtil.getAddress(m), l);
    }

    static native void nglMatrixMultdEXT(int var0, long var1, long var3);

    public static void glMatrixLoadIdentityEXT(int matrixMode) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMatrixLoadIdentityEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglMatrixLoadIdentityEXT(matrixMode, l);
    }

    static native void nglMatrixLoadIdentityEXT(int var0, long var1);

    public static void glMatrixRotatefEXT(int matrixMode, float angle, float x, float y, float z) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMatrixRotatefEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglMatrixRotatefEXT(matrixMode, angle, x, y, z, l);
    }

    static native void nglMatrixRotatefEXT(int var0, float var1, float var2, float var3, float var4, long var5);

    public static void glMatrixRotatedEXT(int matrixMode, double angle, double x, double y, double z) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMatrixRotatedEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglMatrixRotatedEXT(matrixMode, angle, x, y, z, l);
    }

    static native void nglMatrixRotatedEXT(int var0, double var1, double var3, double var5, double var7, long var9);

    public static void glMatrixScalefEXT(int matrixMode, float x, float y, float z) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMatrixScalefEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglMatrixScalefEXT(matrixMode, x, y, z, l);
    }

    static native void nglMatrixScalefEXT(int var0, float var1, float var2, float var3, long var4);

    public static void glMatrixScaledEXT(int matrixMode, double x, double y, double z) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMatrixScaledEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglMatrixScaledEXT(matrixMode, x, y, z, l);
    }

    static native void nglMatrixScaledEXT(int var0, double var1, double var3, double var5, long var7);

    public static void glMatrixTranslatefEXT(int matrixMode, float x, float y, float z) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMatrixTranslatefEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglMatrixTranslatefEXT(matrixMode, x, y, z, l);
    }

    static native void nglMatrixTranslatefEXT(int var0, float var1, float var2, float var3, long var4);

    public static void glMatrixTranslatedEXT(int matrixMode, double x, double y, double z) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMatrixTranslatedEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglMatrixTranslatedEXT(matrixMode, x, y, z, l);
    }

    static native void nglMatrixTranslatedEXT(int var0, double var1, double var3, double var5, long var7);

    public static void glMatrixOrthoEXT(int matrixMode, double l, double r, double b, double t, double n, double f) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMatrixOrthoEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglMatrixOrthoEXT(matrixMode, l, r, b, t, n, f, l2);
    }

    static native void nglMatrixOrthoEXT(int var0, double var1, double var3, double var5, double var7, double var9, double var11, long var13);

    public static void glMatrixFrustumEXT(int matrixMode, double l, double r, double b, double t, double n, double f) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMatrixFrustumEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglMatrixFrustumEXT(matrixMode, l, r, b, t, n, f, l2);
    }

    static native void nglMatrixFrustumEXT(int var0, double var1, double var3, double var5, double var7, double var9, double var11, long var13);

    public static void glMatrixPushEXT(int matrixMode) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMatrixPushEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglMatrixPushEXT(matrixMode, l);
    }

    static native void nglMatrixPushEXT(int var0, long var1);

    public static void glMatrixPopEXT(int matrixMode) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMatrixPopEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglMatrixPopEXT(matrixMode, l);
    }

    static native void nglMatrixPopEXT(int var0, long var1);

    public static void glTextureParameteriEXT(int texture, int target, int pname, int param) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureParameteriEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglTextureParameteriEXT(texture, target, pname, param, l);
    }

    static native void nglTextureParameteriEXT(int var0, int var1, int var2, int var3, long var4);

    public static void glTextureParameterEXT(int texture, int target, int pname, IntBuffer param) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureParameterivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(param, 4);
        EXTDirectStateAccess.nglTextureParameterivEXT(texture, target, pname, MemoryUtil.getAddress(param), l);
    }

    static native void nglTextureParameterivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glTextureParameterfEXT(int texture, int target, int pname, float param) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureParameterfEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglTextureParameterfEXT(texture, target, pname, param, l);
    }

    static native void nglTextureParameterfEXT(int var0, int var1, int var2, float var3, long var4);

    public static void glTextureParameterEXT(int texture, int target, int pname, FloatBuffer param) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureParameterfvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(param, 4);
        EXTDirectStateAccess.nglTextureParameterfvEXT(texture, target, pname, MemoryUtil.getAddress(param), l);
    }

    static native void nglTextureParameterfvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glTextureImage1DEXT(int texture, int target, int level, int internalformat, int width, int border, int format, int type, ByteBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage1DStorage(pixels, format, type, width));
        }
        EXTDirectStateAccess.nglTextureImage1DEXT(texture, target, level, internalformat, width, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    public static void glTextureImage1DEXT(int texture, int target, int level, int internalformat, int width, int border, int format, int type, DoubleBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage1DStorage(pixels, format, type, width));
        }
        EXTDirectStateAccess.nglTextureImage1DEXT(texture, target, level, internalformat, width, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    public static void glTextureImage1DEXT(int texture, int target, int level, int internalformat, int width, int border, int format, int type, FloatBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage1DStorage(pixels, format, type, width));
        }
        EXTDirectStateAccess.nglTextureImage1DEXT(texture, target, level, internalformat, width, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    public static void glTextureImage1DEXT(int texture, int target, int level, int internalformat, int width, int border, int format, int type, IntBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage1DStorage(pixels, format, type, width));
        }
        EXTDirectStateAccess.nglTextureImage1DEXT(texture, target, level, internalformat, width, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    public static void glTextureImage1DEXT(int texture, int target, int level, int internalformat, int width, int border, int format, int type, ShortBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage1DStorage(pixels, format, type, width));
        }
        EXTDirectStateAccess.nglTextureImage1DEXT(texture, target, level, internalformat, width, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    static native void nglTextureImage1DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void glTextureImage1DEXT(int texture, int target, int level, int internalformat, int width, int border, int format, int type, long pixels_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglTextureImage1DEXTBO(texture, target, level, internalformat, width, border, format, type, pixels_buffer_offset, l);
    }

    static native void nglTextureImage1DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void glTextureImage2DEXT(int texture, int target, int level, int internalformat, int width, int height, int border, int format, int type, ByteBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage2DStorage(pixels, format, type, width, height));
        }
        EXTDirectStateAccess.nglTextureImage2DEXT(texture, target, level, internalformat, width, height, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    public static void glTextureImage2DEXT(int texture, int target, int level, int internalformat, int width, int height, int border, int format, int type, DoubleBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage2DStorage(pixels, format, type, width, height));
        }
        EXTDirectStateAccess.nglTextureImage2DEXT(texture, target, level, internalformat, width, height, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    public static void glTextureImage2DEXT(int texture, int target, int level, int internalformat, int width, int height, int border, int format, int type, FloatBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage2DStorage(pixels, format, type, width, height));
        }
        EXTDirectStateAccess.nglTextureImage2DEXT(texture, target, level, internalformat, width, height, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    public static void glTextureImage2DEXT(int texture, int target, int level, int internalformat, int width, int height, int border, int format, int type, IntBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage2DStorage(pixels, format, type, width, height));
        }
        EXTDirectStateAccess.nglTextureImage2DEXT(texture, target, level, internalformat, width, height, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    public static void glTextureImage2DEXT(int texture, int target, int level, int internalformat, int width, int height, int border, int format, int type, ShortBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage2DStorage(pixels, format, type, width, height));
        }
        EXTDirectStateAccess.nglTextureImage2DEXT(texture, target, level, internalformat, width, height, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    static native void nglTextureImage2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glTextureImage2DEXT(int texture, int target, int level, int internalformat, int width, int height, int border, int format, int type, long pixels_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglTextureImage2DEXTBO(texture, target, level, internalformat, width, height, border, format, type, pixels_buffer_offset, l);
    }

    static native void nglTextureImage2DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glTextureSubImage1DEXT(int texture, int target, int level, int xoffset, int width, int format, int type, ByteBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, 1, 1));
        EXTDirectStateAccess.nglTextureSubImage1DEXT(texture, target, level, xoffset, width, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glTextureSubImage1DEXT(int texture, int target, int level, int xoffset, int width, int format, int type, DoubleBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, 1, 1));
        EXTDirectStateAccess.nglTextureSubImage1DEXT(texture, target, level, xoffset, width, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glTextureSubImage1DEXT(int texture, int target, int level, int xoffset, int width, int format, int type, FloatBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, 1, 1));
        EXTDirectStateAccess.nglTextureSubImage1DEXT(texture, target, level, xoffset, width, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glTextureSubImage1DEXT(int texture, int target, int level, int xoffset, int width, int format, int type, IntBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, 1, 1));
        EXTDirectStateAccess.nglTextureSubImage1DEXT(texture, target, level, xoffset, width, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glTextureSubImage1DEXT(int texture, int target, int level, int xoffset, int width, int format, int type, ShortBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, 1, 1));
        EXTDirectStateAccess.nglTextureSubImage1DEXT(texture, target, level, xoffset, width, format, type, MemoryUtil.getAddress(pixels), l);
    }

    static native void nglTextureSubImage1DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void glTextureSubImage1DEXT(int texture, int target, int level, int xoffset, int width, int format, int type, long pixels_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglTextureSubImage1DEXTBO(texture, target, level, xoffset, width, format, type, pixels_buffer_offset, l);
    }

    static native void nglTextureSubImage1DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void glTextureSubImage2DEXT(int texture, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, ByteBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, 1));
        EXTDirectStateAccess.nglTextureSubImage2DEXT(texture, target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glTextureSubImage2DEXT(int texture, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, DoubleBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, 1));
        EXTDirectStateAccess.nglTextureSubImage2DEXT(texture, target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glTextureSubImage2DEXT(int texture, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, FloatBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, 1));
        EXTDirectStateAccess.nglTextureSubImage2DEXT(texture, target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glTextureSubImage2DEXT(int texture, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, IntBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, 1));
        EXTDirectStateAccess.nglTextureSubImage2DEXT(texture, target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glTextureSubImage2DEXT(int texture, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, ShortBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, 1));
        EXTDirectStateAccess.nglTextureSubImage2DEXT(texture, target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.getAddress(pixels), l);
    }

    static native void nglTextureSubImage2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glTextureSubImage2DEXT(int texture, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixels_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglTextureSubImage2DEXTBO(texture, target, level, xoffset, yoffset, width, height, format, type, pixels_buffer_offset, l);
    }

    static native void nglTextureSubImage2DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glCopyTextureImage1DEXT(int texture, int target, int level, int internalformat, int x, int y, int width, int border) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCopyTextureImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglCopyTextureImage1DEXT(texture, target, level, internalformat, x, y, width, border, l);
    }

    static native void nglCopyTextureImage1DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public static void glCopyTextureImage2DEXT(int texture, int target, int level, int internalformat, int x, int y, int width, int height, int border) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCopyTextureImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglCopyTextureImage2DEXT(texture, target, level, internalformat, x, y, width, height, border, l);
    }

    static native void nglCopyTextureImage2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9);

    public static void glCopyTextureSubImage1DEXT(int texture, int target, int level, int xoffset, int x, int y, int width) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCopyTextureSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglCopyTextureSubImage1DEXT(texture, target, level, xoffset, x, y, width, l);
    }

    static native void nglCopyTextureSubImage1DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7);

    public static void glCopyTextureSubImage2DEXT(int texture, int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCopyTextureSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglCopyTextureSubImage2DEXT(texture, target, level, xoffset, yoffset, x, y, width, height, l);
    }

    static native void nglCopyTextureSubImage2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9);

    public static void glGetTextureImageEXT(int texture, int target, int level, int format, int type, ByteBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetTextureImageEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, 1, 1, 1));
        EXTDirectStateAccess.nglGetTextureImageEXT(texture, target, level, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glGetTextureImageEXT(int texture, int target, int level, int format, int type, DoubleBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetTextureImageEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, 1, 1, 1));
        EXTDirectStateAccess.nglGetTextureImageEXT(texture, target, level, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glGetTextureImageEXT(int texture, int target, int level, int format, int type, FloatBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetTextureImageEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, 1, 1, 1));
        EXTDirectStateAccess.nglGetTextureImageEXT(texture, target, level, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glGetTextureImageEXT(int texture, int target, int level, int format, int type, IntBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetTextureImageEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, 1, 1, 1));
        EXTDirectStateAccess.nglGetTextureImageEXT(texture, target, level, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glGetTextureImageEXT(int texture, int target, int level, int format, int type, ShortBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetTextureImageEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, 1, 1, 1));
        EXTDirectStateAccess.nglGetTextureImageEXT(texture, target, level, format, type, MemoryUtil.getAddress(pixels), l);
    }

    static native void nglGetTextureImageEXT(int var0, int var1, int var2, int var3, int var4, long var5, long var7);

    public static void glGetTextureImageEXT(int texture, int target, int level, int format, int type, long pixels_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetTextureImageEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensurePackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglGetTextureImageEXTBO(texture, target, level, format, type, pixels_buffer_offset, l);
    }

    static native void nglGetTextureImageEXTBO(int var0, int var1, int var2, int var3, int var4, long var5, long var7);

    public static void glGetTextureParameterEXT(int texture, int target, int pname, FloatBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetTextureParameterfvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglGetTextureParameterfvEXT(texture, target, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetTextureParameterfvEXT(int var0, int var1, int var2, long var3, long var5);

    public static float glGetTextureParameterfEXT(int texture, int target, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetTextureParameterfvEXT;
        BufferChecks.checkFunctionAddress(l);
        FloatBuffer floatBuffer = APIUtil.getBufferFloat(contextCapabilities);
        EXTDirectStateAccess.nglGetTextureParameterfvEXT(texture, target, pname, MemoryUtil.getAddress(floatBuffer), l);
        return floatBuffer.get(0);
    }

    public static void glGetTextureParameterEXT(int texture, int target, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetTextureParameterivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglGetTextureParameterivEXT(texture, target, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetTextureParameterivEXT(int var0, int var1, int var2, long var3, long var5);

    public static int glGetTextureParameteriEXT(int texture, int target, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetTextureParameterivEXT;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetTextureParameterivEXT(texture, target, pname, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glGetTextureLevelParameterEXT(int texture, int target, int level, int pname, FloatBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetTextureLevelParameterfvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglGetTextureLevelParameterfvEXT(texture, target, level, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetTextureLevelParameterfvEXT(int var0, int var1, int var2, int var3, long var4, long var6);

    public static float glGetTextureLevelParameterfEXT(int texture, int target, int level, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetTextureLevelParameterfvEXT;
        BufferChecks.checkFunctionAddress(l);
        FloatBuffer floatBuffer = APIUtil.getBufferFloat(contextCapabilities);
        EXTDirectStateAccess.nglGetTextureLevelParameterfvEXT(texture, target, level, pname, MemoryUtil.getAddress(floatBuffer), l);
        return floatBuffer.get(0);
    }

    public static void glGetTextureLevelParameterEXT(int texture, int target, int level, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetTextureLevelParameterivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglGetTextureLevelParameterivEXT(texture, target, level, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetTextureLevelParameterivEXT(int var0, int var1, int var2, int var3, long var4, long var6);

    public static int glGetTextureLevelParameteriEXT(int texture, int target, int level, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetTextureLevelParameterivEXT;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetTextureLevelParameterivEXT(texture, target, level, pname, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glTextureImage3DEXT(int texture, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, ByteBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage3DStorage(pixels, format, type, width, height, depth));
        }
        EXTDirectStateAccess.nglTextureImage3DEXT(texture, target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    public static void glTextureImage3DEXT(int texture, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, DoubleBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage3DStorage(pixels, format, type, width, height, depth));
        }
        EXTDirectStateAccess.nglTextureImage3DEXT(texture, target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    public static void glTextureImage3DEXT(int texture, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, FloatBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage3DStorage(pixels, format, type, width, height, depth));
        }
        EXTDirectStateAccess.nglTextureImage3DEXT(texture, target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    public static void glTextureImage3DEXT(int texture, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, IntBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage3DStorage(pixels, format, type, width, height, depth));
        }
        EXTDirectStateAccess.nglTextureImage3DEXT(texture, target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    public static void glTextureImage3DEXT(int texture, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, ShortBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage3DStorage(pixels, format, type, width, height, depth));
        }
        EXTDirectStateAccess.nglTextureImage3DEXT(texture, target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    static native void nglTextureImage3DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10, long var12);

    public static void glTextureImage3DEXT(int texture, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, long pixels_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglTextureImage3DEXTBO(texture, target, level, internalformat, width, height, depth, border, format, type, pixels_buffer_offset, l);
    }

    static native void nglTextureImage3DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10, long var12);

    public static void glTextureSubImage3DEXT(int texture, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ByteBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, depth));
        EXTDirectStateAccess.nglTextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glTextureSubImage3DEXT(int texture, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, DoubleBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, depth));
        EXTDirectStateAccess.nglTextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glTextureSubImage3DEXT(int texture, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, FloatBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, depth));
        EXTDirectStateAccess.nglTextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glTextureSubImage3DEXT(int texture, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, IntBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, depth));
        EXTDirectStateAccess.nglTextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glTextureSubImage3DEXT(int texture, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ShortBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, depth));
        EXTDirectStateAccess.nglTextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.getAddress(pixels), l);
    }

    static native void nglTextureSubImage3DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, long var13);

    public static void glTextureSubImage3DEXT(int texture, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long pixels_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglTextureSubImage3DEXTBO(texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels_buffer_offset, l);
    }

    static native void nglTextureSubImage3DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, long var13);

    public static void glCopyTextureSubImage3DEXT(int texture, int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCopyTextureSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglCopyTextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, x, y, width, height, l);
    }

    static native void nglCopyTextureSubImage3DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10);

    public static void glBindMultiTextureEXT(int texunit, int target, int texture) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBindMultiTextureEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglBindMultiTextureEXT(texunit, target, texture, l);
    }

    static native void nglBindMultiTextureEXT(int var0, int var1, int var2, long var3);

    public static void glMultiTexCoordPointerEXT(int texunit, int size, int stride, DoubleBuffer pointer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexCoordPointerEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(pointer);
        EXTDirectStateAccess.nglMultiTexCoordPointerEXT(texunit, size, 5130, stride, MemoryUtil.getAddress(pointer), l);
    }

    public static void glMultiTexCoordPointerEXT(int texunit, int size, int stride, FloatBuffer pointer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexCoordPointerEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(pointer);
        EXTDirectStateAccess.nglMultiTexCoordPointerEXT(texunit, size, 5126, stride, MemoryUtil.getAddress(pointer), l);
    }

    static native void nglMultiTexCoordPointerEXT(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glMultiTexCoordPointerEXT(int texunit, int size, int type, int stride, long pointer_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexCoordPointerEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureArrayVBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglMultiTexCoordPointerEXTBO(texunit, size, type, stride, pointer_buffer_offset, l);
    }

    static native void nglMultiTexCoordPointerEXTBO(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glMultiTexEnvfEXT(int texunit, int target, int pname, float param) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexEnvfEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglMultiTexEnvfEXT(texunit, target, pname, param, l);
    }

    static native void nglMultiTexEnvfEXT(int var0, int var1, int var2, float var3, long var4);

    public static void glMultiTexEnvEXT(int texunit, int target, int pname, FloatBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexEnvfvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglMultiTexEnvfvEXT(texunit, target, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglMultiTexEnvfvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glMultiTexEnviEXT(int texunit, int target, int pname, int param) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexEnviEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglMultiTexEnviEXT(texunit, target, pname, param, l);
    }

    static native void nglMultiTexEnviEXT(int var0, int var1, int var2, int var3, long var4);

    public static void glMultiTexEnvEXT(int texunit, int target, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexEnvivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglMultiTexEnvivEXT(texunit, target, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglMultiTexEnvivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glMultiTexGendEXT(int texunit, int coord, int pname, double param) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexGendEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglMultiTexGendEXT(texunit, coord, pname, param, l);
    }

    static native void nglMultiTexGendEXT(int var0, int var1, int var2, double var3, long var5);

    public static void glMultiTexGenEXT(int texunit, int coord, int pname, DoubleBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexGendvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglMultiTexGendvEXT(texunit, coord, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglMultiTexGendvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glMultiTexGenfEXT(int texunit, int coord, int pname, float param) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexGenfEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglMultiTexGenfEXT(texunit, coord, pname, param, l);
    }

    static native void nglMultiTexGenfEXT(int var0, int var1, int var2, float var3, long var4);

    public static void glMultiTexGenEXT(int texunit, int coord, int pname, FloatBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexGenfvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglMultiTexGenfvEXT(texunit, coord, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglMultiTexGenfvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glMultiTexGeniEXT(int texunit, int coord, int pname, int param) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexGeniEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglMultiTexGeniEXT(texunit, coord, pname, param, l);
    }

    static native void nglMultiTexGeniEXT(int var0, int var1, int var2, int var3, long var4);

    public static void glMultiTexGenEXT(int texunit, int coord, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexGenivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglMultiTexGenivEXT(texunit, coord, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglMultiTexGenivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glGetMultiTexEnvEXT(int texunit, int target, int pname, FloatBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetMultiTexEnvfvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglGetMultiTexEnvfvEXT(texunit, target, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetMultiTexEnvfvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glGetMultiTexEnvEXT(int texunit, int target, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetMultiTexEnvivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglGetMultiTexEnvivEXT(texunit, target, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetMultiTexEnvivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glGetMultiTexGenEXT(int texunit, int coord, int pname, DoubleBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetMultiTexGendvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglGetMultiTexGendvEXT(texunit, coord, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetMultiTexGendvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glGetMultiTexGenEXT(int texunit, int coord, int pname, FloatBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetMultiTexGenfvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglGetMultiTexGenfvEXT(texunit, coord, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetMultiTexGenfvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glGetMultiTexGenEXT(int texunit, int coord, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetMultiTexGenivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglGetMultiTexGenivEXT(texunit, coord, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetMultiTexGenivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glMultiTexParameteriEXT(int texunit, int target, int pname, int param) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexParameteriEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglMultiTexParameteriEXT(texunit, target, pname, param, l);
    }

    static native void nglMultiTexParameteriEXT(int var0, int var1, int var2, int var3, long var4);

    public static void glMultiTexParameterEXT(int texunit, int target, int pname, IntBuffer param) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexParameterivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(param, 4);
        EXTDirectStateAccess.nglMultiTexParameterivEXT(texunit, target, pname, MemoryUtil.getAddress(param), l);
    }

    static native void nglMultiTexParameterivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glMultiTexParameterfEXT(int texunit, int target, int pname, float param) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexParameterfEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglMultiTexParameterfEXT(texunit, target, pname, param, l);
    }

    static native void nglMultiTexParameterfEXT(int var0, int var1, int var2, float var3, long var4);

    public static void glMultiTexParameterEXT(int texunit, int target, int pname, FloatBuffer param) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexParameterfvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(param, 4);
        EXTDirectStateAccess.nglMultiTexParameterfvEXT(texunit, target, pname, MemoryUtil.getAddress(param), l);
    }

    static native void nglMultiTexParameterfvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glMultiTexImage1DEXT(int texunit, int target, int level, int internalformat, int width, int border, int format, int type, ByteBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage1DStorage(pixels, format, type, width));
        }
        EXTDirectStateAccess.nglMultiTexImage1DEXT(texunit, target, level, internalformat, width, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    public static void glMultiTexImage1DEXT(int texunit, int target, int level, int internalformat, int width, int border, int format, int type, DoubleBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage1DStorage(pixels, format, type, width));
        }
        EXTDirectStateAccess.nglMultiTexImage1DEXT(texunit, target, level, internalformat, width, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    public static void glMultiTexImage1DEXT(int texunit, int target, int level, int internalformat, int width, int border, int format, int type, FloatBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage1DStorage(pixels, format, type, width));
        }
        EXTDirectStateAccess.nglMultiTexImage1DEXT(texunit, target, level, internalformat, width, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    public static void glMultiTexImage1DEXT(int texunit, int target, int level, int internalformat, int width, int border, int format, int type, IntBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage1DStorage(pixels, format, type, width));
        }
        EXTDirectStateAccess.nglMultiTexImage1DEXT(texunit, target, level, internalformat, width, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    public static void glMultiTexImage1DEXT(int texunit, int target, int level, int internalformat, int width, int border, int format, int type, ShortBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage1DStorage(pixels, format, type, width));
        }
        EXTDirectStateAccess.nglMultiTexImage1DEXT(texunit, target, level, internalformat, width, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    static native void nglMultiTexImage1DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void glMultiTexImage1DEXT(int texunit, int target, int level, int internalformat, int width, int border, int format, int type, long pixels_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglMultiTexImage1DEXTBO(texunit, target, level, internalformat, width, border, format, type, pixels_buffer_offset, l);
    }

    static native void nglMultiTexImage1DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void glMultiTexImage2DEXT(int texunit, int target, int level, int internalformat, int width, int height, int border, int format, int type, ByteBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage2DStorage(pixels, format, type, width, height));
        }
        EXTDirectStateAccess.nglMultiTexImage2DEXT(texunit, target, level, internalformat, width, height, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    public static void glMultiTexImage2DEXT(int texunit, int target, int level, int internalformat, int width, int height, int border, int format, int type, DoubleBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage2DStorage(pixels, format, type, width, height));
        }
        EXTDirectStateAccess.nglMultiTexImage2DEXT(texunit, target, level, internalformat, width, height, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    public static void glMultiTexImage2DEXT(int texunit, int target, int level, int internalformat, int width, int height, int border, int format, int type, FloatBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage2DStorage(pixels, format, type, width, height));
        }
        EXTDirectStateAccess.nglMultiTexImage2DEXT(texunit, target, level, internalformat, width, height, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    public static void glMultiTexImage2DEXT(int texunit, int target, int level, int internalformat, int width, int height, int border, int format, int type, IntBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage2DStorage(pixels, format, type, width, height));
        }
        EXTDirectStateAccess.nglMultiTexImage2DEXT(texunit, target, level, internalformat, width, height, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    public static void glMultiTexImage2DEXT(int texunit, int target, int level, int internalformat, int width, int height, int border, int format, int type, ShortBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage2DStorage(pixels, format, type, width, height));
        }
        EXTDirectStateAccess.nglMultiTexImage2DEXT(texunit, target, level, internalformat, width, height, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    static native void nglMultiTexImage2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glMultiTexImage2DEXT(int texunit, int target, int level, int internalformat, int width, int height, int border, int format, int type, long pixels_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglMultiTexImage2DEXTBO(texunit, target, level, internalformat, width, height, border, format, type, pixels_buffer_offset, l);
    }

    static native void nglMultiTexImage2DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glMultiTexSubImage1DEXT(int texunit, int target, int level, int xoffset, int width, int format, int type, ByteBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, 1, 1));
        EXTDirectStateAccess.nglMultiTexSubImage1DEXT(texunit, target, level, xoffset, width, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glMultiTexSubImage1DEXT(int texunit, int target, int level, int xoffset, int width, int format, int type, DoubleBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, 1, 1));
        EXTDirectStateAccess.nglMultiTexSubImage1DEXT(texunit, target, level, xoffset, width, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glMultiTexSubImage1DEXT(int texunit, int target, int level, int xoffset, int width, int format, int type, FloatBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, 1, 1));
        EXTDirectStateAccess.nglMultiTexSubImage1DEXT(texunit, target, level, xoffset, width, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glMultiTexSubImage1DEXT(int texunit, int target, int level, int xoffset, int width, int format, int type, IntBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, 1, 1));
        EXTDirectStateAccess.nglMultiTexSubImage1DEXT(texunit, target, level, xoffset, width, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glMultiTexSubImage1DEXT(int texunit, int target, int level, int xoffset, int width, int format, int type, ShortBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, 1, 1));
        EXTDirectStateAccess.nglMultiTexSubImage1DEXT(texunit, target, level, xoffset, width, format, type, MemoryUtil.getAddress(pixels), l);
    }

    static native void nglMultiTexSubImage1DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void glMultiTexSubImage1DEXT(int texunit, int target, int level, int xoffset, int width, int format, int type, long pixels_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglMultiTexSubImage1DEXTBO(texunit, target, level, xoffset, width, format, type, pixels_buffer_offset, l);
    }

    static native void nglMultiTexSubImage1DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void glMultiTexSubImage2DEXT(int texunit, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, ByteBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, 1));
        EXTDirectStateAccess.nglMultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glMultiTexSubImage2DEXT(int texunit, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, DoubleBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, 1));
        EXTDirectStateAccess.nglMultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glMultiTexSubImage2DEXT(int texunit, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, FloatBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, 1));
        EXTDirectStateAccess.nglMultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glMultiTexSubImage2DEXT(int texunit, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, IntBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, 1));
        EXTDirectStateAccess.nglMultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glMultiTexSubImage2DEXT(int texunit, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, ShortBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, 1));
        EXTDirectStateAccess.nglMultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.getAddress(pixels), l);
    }

    static native void nglMultiTexSubImage2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glMultiTexSubImage2DEXT(int texunit, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixels_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglMultiTexSubImage2DEXTBO(texunit, target, level, xoffset, yoffset, width, height, format, type, pixels_buffer_offset, l);
    }

    static native void nglMultiTexSubImage2DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glCopyMultiTexImage1DEXT(int texunit, int target, int level, int internalformat, int x, int y, int width, int border) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCopyMultiTexImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglCopyMultiTexImage1DEXT(texunit, target, level, internalformat, x, y, width, border, l);
    }

    static native void nglCopyMultiTexImage1DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public static void glCopyMultiTexImage2DEXT(int texunit, int target, int level, int internalformat, int x, int y, int width, int height, int border) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCopyMultiTexImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglCopyMultiTexImage2DEXT(texunit, target, level, internalformat, x, y, width, height, border, l);
    }

    static native void nglCopyMultiTexImage2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9);

    public static void glCopyMultiTexSubImage1DEXT(int texunit, int target, int level, int xoffset, int x, int y, int width) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCopyMultiTexSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglCopyMultiTexSubImage1DEXT(texunit, target, level, xoffset, x, y, width, l);
    }

    static native void nglCopyMultiTexSubImage1DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7);

    public static void glCopyMultiTexSubImage2DEXT(int texunit, int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCopyMultiTexSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglCopyMultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, x, y, width, height, l);
    }

    static native void nglCopyMultiTexSubImage2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9);

    public static void glGetMultiTexImageEXT(int texunit, int target, int level, int format, int type, ByteBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetMultiTexImageEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, 1, 1, 1));
        EXTDirectStateAccess.nglGetMultiTexImageEXT(texunit, target, level, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glGetMultiTexImageEXT(int texunit, int target, int level, int format, int type, DoubleBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetMultiTexImageEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, 1, 1, 1));
        EXTDirectStateAccess.nglGetMultiTexImageEXT(texunit, target, level, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glGetMultiTexImageEXT(int texunit, int target, int level, int format, int type, FloatBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetMultiTexImageEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, 1, 1, 1));
        EXTDirectStateAccess.nglGetMultiTexImageEXT(texunit, target, level, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glGetMultiTexImageEXT(int texunit, int target, int level, int format, int type, IntBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetMultiTexImageEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, 1, 1, 1));
        EXTDirectStateAccess.nglGetMultiTexImageEXT(texunit, target, level, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glGetMultiTexImageEXT(int texunit, int target, int level, int format, int type, ShortBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetMultiTexImageEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, 1, 1, 1));
        EXTDirectStateAccess.nglGetMultiTexImageEXT(texunit, target, level, format, type, MemoryUtil.getAddress(pixels), l);
    }

    static native void nglGetMultiTexImageEXT(int var0, int var1, int var2, int var3, int var4, long var5, long var7);

    public static void glGetMultiTexImageEXT(int texunit, int target, int level, int format, int type, long pixels_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetMultiTexImageEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensurePackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglGetMultiTexImageEXTBO(texunit, target, level, format, type, pixels_buffer_offset, l);
    }

    static native void nglGetMultiTexImageEXTBO(int var0, int var1, int var2, int var3, int var4, long var5, long var7);

    public static void glGetMultiTexParameterEXT(int texunit, int target, int pname, FloatBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetMultiTexParameterfvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglGetMultiTexParameterfvEXT(texunit, target, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetMultiTexParameterfvEXT(int var0, int var1, int var2, long var3, long var5);

    public static float glGetMultiTexParameterfEXT(int texunit, int target, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetMultiTexParameterfvEXT;
        BufferChecks.checkFunctionAddress(l);
        FloatBuffer floatBuffer = APIUtil.getBufferFloat(contextCapabilities);
        EXTDirectStateAccess.nglGetMultiTexParameterfvEXT(texunit, target, pname, MemoryUtil.getAddress(floatBuffer), l);
        return floatBuffer.get(0);
    }

    public static void glGetMultiTexParameterEXT(int texunit, int target, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetMultiTexParameterivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglGetMultiTexParameterivEXT(texunit, target, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetMultiTexParameterivEXT(int var0, int var1, int var2, long var3, long var5);

    public static int glGetMultiTexParameteriEXT(int texunit, int target, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetMultiTexParameterivEXT;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetMultiTexParameterivEXT(texunit, target, pname, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glGetMultiTexLevelParameterEXT(int texunit, int target, int level, int pname, FloatBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetMultiTexLevelParameterfvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglGetMultiTexLevelParameterfvEXT(texunit, target, level, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetMultiTexLevelParameterfvEXT(int var0, int var1, int var2, int var3, long var4, long var6);

    public static float glGetMultiTexLevelParameterfEXT(int texunit, int target, int level, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetMultiTexLevelParameterfvEXT;
        BufferChecks.checkFunctionAddress(l);
        FloatBuffer floatBuffer = APIUtil.getBufferFloat(contextCapabilities);
        EXTDirectStateAccess.nglGetMultiTexLevelParameterfvEXT(texunit, target, level, pname, MemoryUtil.getAddress(floatBuffer), l);
        return floatBuffer.get(0);
    }

    public static void glGetMultiTexLevelParameterEXT(int texunit, int target, int level, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetMultiTexLevelParameterivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglGetMultiTexLevelParameterivEXT(texunit, target, level, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetMultiTexLevelParameterivEXT(int var0, int var1, int var2, int var3, long var4, long var6);

    public static int glGetMultiTexLevelParameteriEXT(int texunit, int target, int level, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetMultiTexLevelParameterivEXT;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetMultiTexLevelParameterivEXT(texunit, target, level, pname, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glMultiTexImage3DEXT(int texunit, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, ByteBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage3DStorage(pixels, format, type, width, height, depth));
        }
        EXTDirectStateAccess.nglMultiTexImage3DEXT(texunit, target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    public static void glMultiTexImage3DEXT(int texunit, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, DoubleBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage3DStorage(pixels, format, type, width, height, depth));
        }
        EXTDirectStateAccess.nglMultiTexImage3DEXT(texunit, target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    public static void glMultiTexImage3DEXT(int texunit, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, FloatBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage3DStorage(pixels, format, type, width, height, depth));
        }
        EXTDirectStateAccess.nglMultiTexImage3DEXT(texunit, target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    public static void glMultiTexImage3DEXT(int texunit, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, IntBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage3DStorage(pixels, format, type, width, height, depth));
        }
        EXTDirectStateAccess.nglMultiTexImage3DEXT(texunit, target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    public static void glMultiTexImage3DEXT(int texunit, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, ShortBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage3DStorage(pixels, format, type, width, height, depth));
        }
        EXTDirectStateAccess.nglMultiTexImage3DEXT(texunit, target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.getAddressSafe(pixels), l);
    }

    static native void nglMultiTexImage3DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10, long var12);

    public static void glMultiTexImage3DEXT(int texunit, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, long pixels_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglMultiTexImage3DEXTBO(texunit, target, level, internalformat, width, height, depth, border, format, type, pixels_buffer_offset, l);
    }

    static native void nglMultiTexImage3DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10, long var12);

    public static void glMultiTexSubImage3DEXT(int texunit, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ByteBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, depth));
        EXTDirectStateAccess.nglMultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glMultiTexSubImage3DEXT(int texunit, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, DoubleBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, depth));
        EXTDirectStateAccess.nglMultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glMultiTexSubImage3DEXT(int texunit, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, FloatBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, depth));
        EXTDirectStateAccess.nglMultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glMultiTexSubImage3DEXT(int texunit, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, IntBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, depth));
        EXTDirectStateAccess.nglMultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.getAddress(pixels), l);
    }

    public static void glMultiTexSubImage3DEXT(int texunit, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ShortBuffer pixels) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, depth));
        EXTDirectStateAccess.nglMultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.getAddress(pixels), l);
    }

    static native void nglMultiTexSubImage3DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, long var13);

    public static void glMultiTexSubImage3DEXT(int texunit, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long pixels_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglMultiTexSubImage3DEXTBO(texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels_buffer_offset, l);
    }

    static native void nglMultiTexSubImage3DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, long var13);

    public static void glCopyMultiTexSubImage3DEXT(int texunit, int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCopyMultiTexSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglCopyMultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, x, y, width, height, l);
    }

    static native void nglCopyMultiTexSubImage3DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10);

    public static void glEnableClientStateIndexedEXT(int array, int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glEnableClientStateIndexedEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglEnableClientStateIndexedEXT(array, index, l);
    }

    static native void nglEnableClientStateIndexedEXT(int var0, int var1, long var2);

    public static void glDisableClientStateIndexedEXT(int array, int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDisableClientStateIndexedEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglDisableClientStateIndexedEXT(array, index, l);
    }

    static native void nglDisableClientStateIndexedEXT(int var0, int var1, long var2);

    public static void glEnableClientStateiEXT(int array, int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glEnableClientStateiEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglEnableClientStateiEXT(array, index, l);
    }

    static native void nglEnableClientStateiEXT(int var0, int var1, long var2);

    public static void glDisableClientStateiEXT(int array, int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDisableClientStateiEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglDisableClientStateiEXT(array, index, l);
    }

    static native void nglDisableClientStateiEXT(int var0, int var1, long var2);

    public static void glGetFloatIndexedEXT(int pname, int index, FloatBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetFloatIndexedvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 16);
        EXTDirectStateAccess.nglGetFloatIndexedvEXT(pname, index, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetFloatIndexedvEXT(int var0, int var1, long var2, long var4);

    public static float glGetFloatIndexedEXT(int pname, int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetFloatIndexedvEXT;
        BufferChecks.checkFunctionAddress(l);
        FloatBuffer floatBuffer = APIUtil.getBufferFloat(contextCapabilities);
        EXTDirectStateAccess.nglGetFloatIndexedvEXT(pname, index, MemoryUtil.getAddress(floatBuffer), l);
        return floatBuffer.get(0);
    }

    public static void glGetDoubleIndexedEXT(int pname, int index, DoubleBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetDoubleIndexedvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 16);
        EXTDirectStateAccess.nglGetDoubleIndexedvEXT(pname, index, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetDoubleIndexedvEXT(int var0, int var1, long var2, long var4);

    public static double glGetDoubleIndexedEXT(int pname, int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetDoubleIndexedvEXT;
        BufferChecks.checkFunctionAddress(l);
        DoubleBuffer doubleBuffer = APIUtil.getBufferDouble(contextCapabilities);
        EXTDirectStateAccess.nglGetDoubleIndexedvEXT(pname, index, MemoryUtil.getAddress(doubleBuffer), l);
        return doubleBuffer.get(0);
    }

    public static ByteBuffer glGetPointerIndexedEXT(int pname, int index, long result_size) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPointerIndexedvEXT;
        BufferChecks.checkFunctionAddress(l);
        ByteBuffer byteBuffer = EXTDirectStateAccess.nglGetPointerIndexedvEXT(pname, index, result_size, l);
        return LWJGLUtil.CHECKS && byteBuffer == null ? null : byteBuffer.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglGetPointerIndexedvEXT(int var0, int var1, long var2, long var4);

    public static void glGetFloatEXT(int pname, int index, FloatBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetFloati_vEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 16);
        EXTDirectStateAccess.nglGetFloati_vEXT(pname, index, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetFloati_vEXT(int var0, int var1, long var2, long var4);

    public static float glGetFloatEXT(int pname, int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetFloati_vEXT;
        BufferChecks.checkFunctionAddress(l);
        FloatBuffer floatBuffer = APIUtil.getBufferFloat(contextCapabilities);
        EXTDirectStateAccess.nglGetFloati_vEXT(pname, index, MemoryUtil.getAddress(floatBuffer), l);
        return floatBuffer.get(0);
    }

    public static void glGetDoubleEXT(int pname, int index, DoubleBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetDoublei_vEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 16);
        EXTDirectStateAccess.nglGetDoublei_vEXT(pname, index, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetDoublei_vEXT(int var0, int var1, long var2, long var4);

    public static double glGetDoubleEXT(int pname, int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetDoublei_vEXT;
        BufferChecks.checkFunctionAddress(l);
        DoubleBuffer doubleBuffer = APIUtil.getBufferDouble(contextCapabilities);
        EXTDirectStateAccess.nglGetDoublei_vEXT(pname, index, MemoryUtil.getAddress(doubleBuffer), l);
        return doubleBuffer.get(0);
    }

    public static ByteBuffer glGetPointerEXT(int pname, int index, long result_size) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPointeri_vEXT;
        BufferChecks.checkFunctionAddress(l);
        ByteBuffer byteBuffer = EXTDirectStateAccess.nglGetPointeri_vEXT(pname, index, result_size, l);
        return LWJGLUtil.CHECKS && byteBuffer == null ? null : byteBuffer.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglGetPointeri_vEXT(int var0, int var1, long var2, long var4);

    public static void glEnableIndexedEXT(int cap, int index) {
        EXTDrawBuffers2.glEnableIndexedEXT(cap, index);
    }

    public static void glDisableIndexedEXT(int cap, int index) {
        EXTDrawBuffers2.glDisableIndexedEXT(cap, index);
    }

    public static boolean glIsEnabledIndexedEXT(int cap, int index) {
        return EXTDrawBuffers2.glIsEnabledIndexedEXT(cap, index);
    }

    public static void glGetIntegerIndexedEXT(int pname, int index, IntBuffer params) {
        EXTDrawBuffers2.glGetIntegerIndexedEXT(pname, index, params);
    }

    public static int glGetIntegerIndexedEXT(int pname, int index) {
        return EXTDrawBuffers2.glGetIntegerIndexedEXT(pname, index);
    }

    public static void glGetBooleanIndexedEXT(int pname, int index, ByteBuffer params) {
        EXTDrawBuffers2.glGetBooleanIndexedEXT(pname, index, params);
    }

    public static boolean glGetBooleanIndexedEXT(int pname, int index) {
        return EXTDrawBuffers2.glGetBooleanIndexedEXT(pname, index);
    }

    public static void glNamedProgramStringEXT(int program, int target, int format, ByteBuffer string) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedProgramStringEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(string);
        EXTDirectStateAccess.nglNamedProgramStringEXT(program, target, format, string.remaining(), MemoryUtil.getAddress(string), l);
    }

    static native void nglNamedProgramStringEXT(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glNamedProgramStringEXT(int program, int target, int format, CharSequence string) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedProgramStringEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglNamedProgramStringEXT(program, target, format, string.length(), APIUtil.getBuffer(contextCapabilities, string), l);
    }

    public static void glNamedProgramLocalParameter4dEXT(int program, int target, int index, double x, double y, double z, double w) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedProgramLocalParameter4dEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglNamedProgramLocalParameter4dEXT(program, target, index, x, y, z, w, l);
    }

    static native void nglNamedProgramLocalParameter4dEXT(int var0, int var1, int var2, double var3, double var5, double var7, double var9, long var11);

    public static void glNamedProgramLocalParameter4EXT(int program, int target, int index, DoubleBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedProgramLocalParameter4dvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglNamedProgramLocalParameter4dvEXT(program, target, index, MemoryUtil.getAddress(params), l);
    }

    static native void nglNamedProgramLocalParameter4dvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glNamedProgramLocalParameter4fEXT(int program, int target, int index, float x, float y, float z, float w) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedProgramLocalParameter4fEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglNamedProgramLocalParameter4fEXT(program, target, index, x, y, z, w, l);
    }

    static native void nglNamedProgramLocalParameter4fEXT(int var0, int var1, int var2, float var3, float var4, float var5, float var6, long var7);

    public static void glNamedProgramLocalParameter4EXT(int program, int target, int index, FloatBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedProgramLocalParameter4fvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglNamedProgramLocalParameter4fvEXT(program, target, index, MemoryUtil.getAddress(params), l);
    }

    static native void nglNamedProgramLocalParameter4fvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glGetNamedProgramLocalParameterEXT(int program, int target, int index, DoubleBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedProgramLocalParameterdvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglGetNamedProgramLocalParameterdvEXT(program, target, index, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetNamedProgramLocalParameterdvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glGetNamedProgramLocalParameterEXT(int program, int target, int index, FloatBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedProgramLocalParameterfvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglGetNamedProgramLocalParameterfvEXT(program, target, index, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetNamedProgramLocalParameterfvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glGetNamedProgramEXT(int program, int target, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedProgramivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglGetNamedProgramivEXT(program, target, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetNamedProgramivEXT(int var0, int var1, int var2, long var3, long var5);

    public static int glGetNamedProgramEXT(int program, int target, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedProgramivEXT;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetNamedProgramivEXT(program, target, pname, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glGetNamedProgramStringEXT(int program, int target, int pname, ByteBuffer string) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedProgramStringEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(string);
        EXTDirectStateAccess.nglGetNamedProgramStringEXT(program, target, pname, MemoryUtil.getAddress(string), l);
    }

    static native void nglGetNamedProgramStringEXT(int var0, int var1, int var2, long var3, long var5);

    public static String glGetNamedProgramStringEXT(int program, int target, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedProgramStringEXT;
        BufferChecks.checkFunctionAddress(l);
        int n = EXTDirectStateAccess.glGetNamedProgramEXT(program, target, 34343);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, n);
        EXTDirectStateAccess.nglGetNamedProgramStringEXT(program, target, pname, MemoryUtil.getAddress(byteBuffer), l);
        byteBuffer.limit(n);
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static void glCompressedTextureImage3DEXT(int texture, int target, int level, int internalformat, int width, int height, int depth, int border, ByteBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompressedTextureImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglCompressedTextureImage3DEXT(texture, target, level, internalformat, width, height, depth, border, data.remaining(), MemoryUtil.getAddress(data), l);
    }

    static native void nglCompressedTextureImage3DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glCompressedTextureImage3DEXT(int texture, int target, int level, int internalformat, int width, int height, int depth, int border, int data_imageSize, long data_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompressedTextureImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglCompressedTextureImage3DEXTBO(texture, target, level, internalformat, width, height, depth, border, data_imageSize, data_buffer_offset, l);
    }

    static native void nglCompressedTextureImage3DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glCompressedTextureImage2DEXT(int texture, int target, int level, int internalformat, int width, int height, int border, ByteBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompressedTextureImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglCompressedTextureImage2DEXT(texture, target, level, internalformat, width, height, border, data.remaining(), MemoryUtil.getAddress(data), l);
    }

    static native void nglCompressedTextureImage2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void glCompressedTextureImage2DEXT(int texture, int target, int level, int internalformat, int width, int height, int border, int data_imageSize, long data_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompressedTextureImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglCompressedTextureImage2DEXTBO(texture, target, level, internalformat, width, height, border, data_imageSize, data_buffer_offset, l);
    }

    static native void nglCompressedTextureImage2DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void glCompressedTextureImage1DEXT(int texture, int target, int level, int internalformat, int width, int border, ByteBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompressedTextureImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglCompressedTextureImage1DEXT(texture, target, level, internalformat, width, border, data.remaining(), MemoryUtil.getAddress(data), l);
    }

    static native void nglCompressedTextureImage1DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void glCompressedTextureImage1DEXT(int texture, int target, int level, int internalformat, int width, int border, int data_imageSize, long data_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompressedTextureImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglCompressedTextureImage1DEXTBO(texture, target, level, internalformat, width, border, data_imageSize, data_buffer_offset, l);
    }

    static native void nglCompressedTextureImage1DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void glCompressedTextureSubImage3DEXT(int texture, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, ByteBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompressedTextureSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglCompressedTextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, data.remaining(), MemoryUtil.getAddress(data), l);
    }

    static native void nglCompressedTextureSubImage3DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, long var13);

    public static void glCompressedTextureSubImage3DEXT(int texture, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int data_imageSize, long data_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompressedTextureSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglCompressedTextureSubImage3DEXTBO(texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, data_imageSize, data_buffer_offset, l);
    }

    static native void nglCompressedTextureSubImage3DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, long var13);

    public static void glCompressedTextureSubImage2DEXT(int texture, int target, int level, int xoffset, int yoffset, int width, int height, int format, ByteBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompressedTextureSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglCompressedTextureSubImage2DEXT(texture, target, level, xoffset, yoffset, width, height, format, data.remaining(), MemoryUtil.getAddress(data), l);
    }

    static native void nglCompressedTextureSubImage2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glCompressedTextureSubImage2DEXT(int texture, int target, int level, int xoffset, int yoffset, int width, int height, int format, int data_imageSize, long data_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompressedTextureSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglCompressedTextureSubImage2DEXTBO(texture, target, level, xoffset, yoffset, width, height, format, data_imageSize, data_buffer_offset, l);
    }

    static native void nglCompressedTextureSubImage2DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glCompressedTextureSubImage1DEXT(int texture, int target, int level, int xoffset, int width, int format, ByteBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompressedTextureSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglCompressedTextureSubImage1DEXT(texture, target, level, xoffset, width, format, data.remaining(), MemoryUtil.getAddress(data), l);
    }

    static native void nglCompressedTextureSubImage1DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void glCompressedTextureSubImage1DEXT(int texture, int target, int level, int xoffset, int width, int format, int data_imageSize, long data_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompressedTextureSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglCompressedTextureSubImage1DEXTBO(texture, target, level, xoffset, width, format, data_imageSize, data_buffer_offset, l);
    }

    static native void nglCompressedTextureSubImage1DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void glGetCompressedTextureImageEXT(int texture, int target, int level, ByteBuffer img) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetCompressedTextureImageEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(img);
        EXTDirectStateAccess.nglGetCompressedTextureImageEXT(texture, target, level, MemoryUtil.getAddress(img), l);
    }

    public static void glGetCompressedTextureImageEXT(int texture, int target, int level, IntBuffer img) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetCompressedTextureImageEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(img);
        EXTDirectStateAccess.nglGetCompressedTextureImageEXT(texture, target, level, MemoryUtil.getAddress(img), l);
    }

    public static void glGetCompressedTextureImageEXT(int texture, int target, int level, ShortBuffer img) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetCompressedTextureImageEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(img);
        EXTDirectStateAccess.nglGetCompressedTextureImageEXT(texture, target, level, MemoryUtil.getAddress(img), l);
    }

    static native void nglGetCompressedTextureImageEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glGetCompressedTextureImageEXT(int texture, int target, int level, long img_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetCompressedTextureImageEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensurePackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglGetCompressedTextureImageEXTBO(texture, target, level, img_buffer_offset, l);
    }

    static native void nglGetCompressedTextureImageEXTBO(int var0, int var1, int var2, long var3, long var5);

    public static void glCompressedMultiTexImage3DEXT(int texunit, int target, int level, int internalformat, int width, int height, int depth, int border, ByteBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompressedMultiTexImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglCompressedMultiTexImage3DEXT(texunit, target, level, internalformat, width, height, depth, border, data.remaining(), MemoryUtil.getAddress(data), l);
    }

    static native void nglCompressedMultiTexImage3DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glCompressedMultiTexImage3DEXT(int texunit, int target, int level, int internalformat, int width, int height, int depth, int border, int data_imageSize, long data_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompressedMultiTexImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglCompressedMultiTexImage3DEXTBO(texunit, target, level, internalformat, width, height, depth, border, data_imageSize, data_buffer_offset, l);
    }

    static native void nglCompressedMultiTexImage3DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glCompressedMultiTexImage2DEXT(int texunit, int target, int level, int internalformat, int width, int height, int border, ByteBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompressedMultiTexImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglCompressedMultiTexImage2DEXT(texunit, target, level, internalformat, width, height, border, data.remaining(), MemoryUtil.getAddress(data), l);
    }

    static native void nglCompressedMultiTexImage2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void glCompressedMultiTexImage2DEXT(int texunit, int target, int level, int internalformat, int width, int height, int border, int data_imageSize, long data_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompressedMultiTexImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglCompressedMultiTexImage2DEXTBO(texunit, target, level, internalformat, width, height, border, data_imageSize, data_buffer_offset, l);
    }

    static native void nglCompressedMultiTexImage2DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void glCompressedMultiTexImage1DEXT(int texunit, int target, int level, int internalformat, int width, int border, ByteBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompressedMultiTexImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglCompressedMultiTexImage1DEXT(texunit, target, level, internalformat, width, border, data.remaining(), MemoryUtil.getAddress(data), l);
    }

    static native void nglCompressedMultiTexImage1DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void glCompressedMultiTexImage1DEXT(int texunit, int target, int level, int internalformat, int width, int border, int data_imageSize, long data_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompressedMultiTexImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglCompressedMultiTexImage1DEXTBO(texunit, target, level, internalformat, width, border, data_imageSize, data_buffer_offset, l);
    }

    static native void nglCompressedMultiTexImage1DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void glCompressedMultiTexSubImage3DEXT(int texunit, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, ByteBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompressedMultiTexSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglCompressedMultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, data.remaining(), MemoryUtil.getAddress(data), l);
    }

    static native void nglCompressedMultiTexSubImage3DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, long var13);

    public static void glCompressedMultiTexSubImage3DEXT(int texunit, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int data_imageSize, long data_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompressedMultiTexSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglCompressedMultiTexSubImage3DEXTBO(texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, data_imageSize, data_buffer_offset, l);
    }

    static native void nglCompressedMultiTexSubImage3DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, long var13);

    public static void glCompressedMultiTexSubImage2DEXT(int texunit, int target, int level, int xoffset, int yoffset, int width, int height, int format, ByteBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompressedMultiTexSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglCompressedMultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, width, height, format, data.remaining(), MemoryUtil.getAddress(data), l);
    }

    static native void nglCompressedMultiTexSubImage2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glCompressedMultiTexSubImage2DEXT(int texunit, int target, int level, int xoffset, int yoffset, int width, int height, int format, int data_imageSize, long data_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompressedMultiTexSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglCompressedMultiTexSubImage2DEXTBO(texunit, target, level, xoffset, yoffset, width, height, format, data_imageSize, data_buffer_offset, l);
    }

    static native void nglCompressedMultiTexSubImage2DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glCompressedMultiTexSubImage1DEXT(int texunit, int target, int level, int xoffset, int width, int format, ByteBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompressedMultiTexSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglCompressedMultiTexSubImage1DEXT(texunit, target, level, xoffset, width, format, data.remaining(), MemoryUtil.getAddress(data), l);
    }

    static native void nglCompressedMultiTexSubImage1DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void glCompressedMultiTexSubImage1DEXT(int texunit, int target, int level, int xoffset, int width, int format, int data_imageSize, long data_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompressedMultiTexSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglCompressedMultiTexSubImage1DEXTBO(texunit, target, level, xoffset, width, format, data_imageSize, data_buffer_offset, l);
    }

    static native void nglCompressedMultiTexSubImage1DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void glGetCompressedMultiTexImageEXT(int texunit, int target, int level, ByteBuffer img) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetCompressedMultiTexImageEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(img);
        EXTDirectStateAccess.nglGetCompressedMultiTexImageEXT(texunit, target, level, MemoryUtil.getAddress(img), l);
    }

    public static void glGetCompressedMultiTexImageEXT(int texunit, int target, int level, IntBuffer img) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetCompressedMultiTexImageEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(img);
        EXTDirectStateAccess.nglGetCompressedMultiTexImageEXT(texunit, target, level, MemoryUtil.getAddress(img), l);
    }

    public static void glGetCompressedMultiTexImageEXT(int texunit, int target, int level, ShortBuffer img) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetCompressedMultiTexImageEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(img);
        EXTDirectStateAccess.nglGetCompressedMultiTexImageEXT(texunit, target, level, MemoryUtil.getAddress(img), l);
    }

    static native void nglGetCompressedMultiTexImageEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glGetCompressedMultiTexImageEXT(int texunit, int target, int level, long img_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetCompressedMultiTexImageEXT;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensurePackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglGetCompressedMultiTexImageEXTBO(texunit, target, level, img_buffer_offset, l);
    }

    static native void nglGetCompressedMultiTexImageEXTBO(int var0, int var1, int var2, long var3, long var5);

    public static void glMatrixLoadTransposeEXT(int matrixMode, FloatBuffer m) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMatrixLoadTransposefEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(m, 16);
        EXTDirectStateAccess.nglMatrixLoadTransposefEXT(matrixMode, MemoryUtil.getAddress(m), l);
    }

    static native void nglMatrixLoadTransposefEXT(int var0, long var1, long var3);

    public static void glMatrixLoadTransposeEXT(int matrixMode, DoubleBuffer m) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMatrixLoadTransposedEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(m, 16);
        EXTDirectStateAccess.nglMatrixLoadTransposedEXT(matrixMode, MemoryUtil.getAddress(m), l);
    }

    static native void nglMatrixLoadTransposedEXT(int var0, long var1, long var3);

    public static void glMatrixMultTransposeEXT(int matrixMode, FloatBuffer m) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMatrixMultTransposefEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(m, 16);
        EXTDirectStateAccess.nglMatrixMultTransposefEXT(matrixMode, MemoryUtil.getAddress(m), l);
    }

    static native void nglMatrixMultTransposefEXT(int var0, long var1, long var3);

    public static void glMatrixMultTransposeEXT(int matrixMode, DoubleBuffer m) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMatrixMultTransposedEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(m, 16);
        EXTDirectStateAccess.nglMatrixMultTransposedEXT(matrixMode, MemoryUtil.getAddress(m), l);
    }

    static native void nglMatrixMultTransposedEXT(int var0, long var1, long var3);

    public static void glNamedBufferDataEXT(int buffer, long data_size, int usage) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedBufferDataEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglNamedBufferDataEXT(buffer, data_size, 0L, usage, l);
    }

    public static void glNamedBufferDataEXT(int buffer, ByteBuffer data, int usage) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedBufferDataEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglNamedBufferDataEXT(buffer, data.remaining(), MemoryUtil.getAddress(data), usage, l);
    }

    public static void glNamedBufferDataEXT(int buffer, DoubleBuffer data, int usage) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedBufferDataEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglNamedBufferDataEXT(buffer, data.remaining() << 3, MemoryUtil.getAddress(data), usage, l);
    }

    public static void glNamedBufferDataEXT(int buffer, FloatBuffer data, int usage) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedBufferDataEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglNamedBufferDataEXT(buffer, data.remaining() << 2, MemoryUtil.getAddress(data), usage, l);
    }

    public static void glNamedBufferDataEXT(int buffer, IntBuffer data, int usage) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedBufferDataEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglNamedBufferDataEXT(buffer, data.remaining() << 2, MemoryUtil.getAddress(data), usage, l);
    }

    public static void glNamedBufferDataEXT(int buffer, ShortBuffer data, int usage) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedBufferDataEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglNamedBufferDataEXT(buffer, data.remaining() << 1, MemoryUtil.getAddress(data), usage, l);
    }

    static native void nglNamedBufferDataEXT(int var0, long var1, long var3, int var5, long var6);

    public static void glNamedBufferSubDataEXT(int buffer, long offset, ByteBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedBufferSubDataEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglNamedBufferSubDataEXT(buffer, offset, data.remaining(), MemoryUtil.getAddress(data), l);
    }

    public static void glNamedBufferSubDataEXT(int buffer, long offset, DoubleBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedBufferSubDataEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglNamedBufferSubDataEXT(buffer, offset, data.remaining() << 3, MemoryUtil.getAddress(data), l);
    }

    public static void glNamedBufferSubDataEXT(int buffer, long offset, FloatBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedBufferSubDataEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglNamedBufferSubDataEXT(buffer, offset, data.remaining() << 2, MemoryUtil.getAddress(data), l);
    }

    public static void glNamedBufferSubDataEXT(int buffer, long offset, IntBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedBufferSubDataEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglNamedBufferSubDataEXT(buffer, offset, data.remaining() << 2, MemoryUtil.getAddress(data), l);
    }

    public static void glNamedBufferSubDataEXT(int buffer, long offset, ShortBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedBufferSubDataEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglNamedBufferSubDataEXT(buffer, offset, data.remaining() << 1, MemoryUtil.getAddress(data), l);
    }

    static native void nglNamedBufferSubDataEXT(int var0, long var1, long var3, long var5, long var7);

    public static ByteBuffer glMapNamedBufferEXT(int buffer, int access, ByteBuffer old_buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMapNamedBufferEXT;
        BufferChecks.checkFunctionAddress(l);
        if (old_buffer != null) {
            BufferChecks.checkDirect(old_buffer);
        }
        ByteBuffer byteBuffer = EXTDirectStateAccess.nglMapNamedBufferEXT(buffer, access, GLChecks.getNamedBufferObjectSize(contextCapabilities, buffer), old_buffer, l);
        return LWJGLUtil.CHECKS && byteBuffer == null ? null : byteBuffer.order(ByteOrder.nativeOrder());
    }

    public static ByteBuffer glMapNamedBufferEXT(int buffer, int access, long length, ByteBuffer old_buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMapNamedBufferEXT;
        BufferChecks.checkFunctionAddress(l);
        if (old_buffer != null) {
            BufferChecks.checkDirect(old_buffer);
        }
        ByteBuffer byteBuffer = EXTDirectStateAccess.nglMapNamedBufferEXT(buffer, access, length, old_buffer, l);
        return LWJGLUtil.CHECKS && byteBuffer == null ? null : byteBuffer.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglMapNamedBufferEXT(int var0, int var1, long var2, ByteBuffer var4, long var5);

    public static boolean glUnmapNamedBufferEXT(int buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUnmapNamedBufferEXT;
        BufferChecks.checkFunctionAddress(l);
        boolean bl = EXTDirectStateAccess.nglUnmapNamedBufferEXT(buffer, l);
        return bl;
    }

    static native boolean nglUnmapNamedBufferEXT(int var0, long var1);

    public static void glGetNamedBufferParameterEXT(int buffer, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedBufferParameterivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglGetNamedBufferParameterivEXT(buffer, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetNamedBufferParameterivEXT(int var0, int var1, long var2, long var4);

    public static int glGetNamedBufferParameterEXT(int buffer, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedBufferParameterivEXT;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetNamedBufferParameterivEXT(buffer, pname, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static ByteBuffer glGetNamedBufferPointerEXT(int buffer, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedBufferPointervEXT;
        BufferChecks.checkFunctionAddress(l);
        ByteBuffer byteBuffer = EXTDirectStateAccess.nglGetNamedBufferPointervEXT(buffer, pname, GLChecks.getNamedBufferObjectSize(contextCapabilities, buffer), l);
        return LWJGLUtil.CHECKS && byteBuffer == null ? null : byteBuffer.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglGetNamedBufferPointervEXT(int var0, int var1, long var2, long var4);

    public static void glGetNamedBufferSubDataEXT(int buffer, long offset, ByteBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedBufferSubDataEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglGetNamedBufferSubDataEXT(buffer, offset, data.remaining(), MemoryUtil.getAddress(data), l);
    }

    public static void glGetNamedBufferSubDataEXT(int buffer, long offset, DoubleBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedBufferSubDataEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglGetNamedBufferSubDataEXT(buffer, offset, data.remaining() << 3, MemoryUtil.getAddress(data), l);
    }

    public static void glGetNamedBufferSubDataEXT(int buffer, long offset, FloatBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedBufferSubDataEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglGetNamedBufferSubDataEXT(buffer, offset, data.remaining() << 2, MemoryUtil.getAddress(data), l);
    }

    public static void glGetNamedBufferSubDataEXT(int buffer, long offset, IntBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedBufferSubDataEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglGetNamedBufferSubDataEXT(buffer, offset, data.remaining() << 2, MemoryUtil.getAddress(data), l);
    }

    public static void glGetNamedBufferSubDataEXT(int buffer, long offset, ShortBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedBufferSubDataEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        EXTDirectStateAccess.nglGetNamedBufferSubDataEXT(buffer, offset, data.remaining() << 1, MemoryUtil.getAddress(data), l);
    }

    static native void nglGetNamedBufferSubDataEXT(int var0, long var1, long var3, long var5, long var7);

    public static void glProgramUniform1fEXT(int program, int location, float v0) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniform1fEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglProgramUniform1fEXT(program, location, v0, l);
    }

    static native void nglProgramUniform1fEXT(int var0, int var1, float var2, long var3);

    public static void glProgramUniform2fEXT(int program, int location, float v0, float v1) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniform2fEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglProgramUniform2fEXT(program, location, v0, v1, l);
    }

    static native void nglProgramUniform2fEXT(int var0, int var1, float var2, float var3, long var4);

    public static void glProgramUniform3fEXT(int program, int location, float v0, float v1, float v2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniform3fEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglProgramUniform3fEXT(program, location, v0, v1, v2, l);
    }

    static native void nglProgramUniform3fEXT(int var0, int var1, float var2, float var3, float var4, long var5);

    public static void glProgramUniform4fEXT(int program, int location, float v0, float v1, float v2, float v3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniform4fEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglProgramUniform4fEXT(program, location, v0, v1, v2, v3, l);
    }

    static native void nglProgramUniform4fEXT(int var0, int var1, float var2, float var3, float var4, float var5, long var6);

    public static void glProgramUniform1iEXT(int program, int location, int v0) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniform1iEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglProgramUniform1iEXT(program, location, v0, l);
    }

    static native void nglProgramUniform1iEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform2iEXT(int program, int location, int v0, int v1) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniform2iEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglProgramUniform2iEXT(program, location, v0, v1, l);
    }

    static native void nglProgramUniform2iEXT(int var0, int var1, int var2, int var3, long var4);

    public static void glProgramUniform3iEXT(int program, int location, int v0, int v1, int v2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniform3iEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglProgramUniform3iEXT(program, location, v0, v1, v2, l);
    }

    static native void nglProgramUniform3iEXT(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glProgramUniform4iEXT(int program, int location, int v0, int v1, int v2, int v3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniform4iEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglProgramUniform4iEXT(program, location, v0, v1, v2, v3, l);
    }

    static native void nglProgramUniform4iEXT(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static void glProgramUniform1EXT(int program, int location, FloatBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniform1fvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        EXTDirectStateAccess.nglProgramUniform1fvEXT(program, location, value.remaining(), MemoryUtil.getAddress(value), l);
    }

    static native void nglProgramUniform1fvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform2EXT(int program, int location, FloatBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniform2fvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        EXTDirectStateAccess.nglProgramUniform2fvEXT(program, location, value.remaining() >> 1, MemoryUtil.getAddress(value), l);
    }

    static native void nglProgramUniform2fvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform3EXT(int program, int location, FloatBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniform3fvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        EXTDirectStateAccess.nglProgramUniform3fvEXT(program, location, value.remaining() / 3, MemoryUtil.getAddress(value), l);
    }

    static native void nglProgramUniform3fvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform4EXT(int program, int location, FloatBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniform4fvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        EXTDirectStateAccess.nglProgramUniform4fvEXT(program, location, value.remaining() >> 2, MemoryUtil.getAddress(value), l);
    }

    static native void nglProgramUniform4fvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform1EXT(int program, int location, IntBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniform1ivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        EXTDirectStateAccess.nglProgramUniform1ivEXT(program, location, value.remaining(), MemoryUtil.getAddress(value), l);
    }

    static native void nglProgramUniform1ivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform2EXT(int program, int location, IntBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniform2ivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        EXTDirectStateAccess.nglProgramUniform2ivEXT(program, location, value.remaining() >> 1, MemoryUtil.getAddress(value), l);
    }

    static native void nglProgramUniform2ivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform3EXT(int program, int location, IntBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniform3ivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        EXTDirectStateAccess.nglProgramUniform3ivEXT(program, location, value.remaining() / 3, MemoryUtil.getAddress(value), l);
    }

    static native void nglProgramUniform3ivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform4EXT(int program, int location, IntBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniform4ivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        EXTDirectStateAccess.nglProgramUniform4ivEXT(program, location, value.remaining() >> 2, MemoryUtil.getAddress(value), l);
    }

    static native void nglProgramUniform4ivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniformMatrix2EXT(int program, int location, boolean transpose, FloatBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniformMatrix2fvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        EXTDirectStateAccess.nglProgramUniformMatrix2fvEXT(program, location, value.remaining() >> 2, transpose, MemoryUtil.getAddress(value), l);
    }

    static native void nglProgramUniformMatrix2fvEXT(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix3EXT(int program, int location, boolean transpose, FloatBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniformMatrix3fvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        EXTDirectStateAccess.nglProgramUniformMatrix3fvEXT(program, location, value.remaining() / 9, transpose, MemoryUtil.getAddress(value), l);
    }

    static native void nglProgramUniformMatrix3fvEXT(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix4EXT(int program, int location, boolean transpose, FloatBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniformMatrix4fvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        EXTDirectStateAccess.nglProgramUniformMatrix4fvEXT(program, location, value.remaining() >> 4, transpose, MemoryUtil.getAddress(value), l);
    }

    static native void nglProgramUniformMatrix4fvEXT(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix2x3EXT(int program, int location, boolean transpose, FloatBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniformMatrix2x3fvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        EXTDirectStateAccess.nglProgramUniformMatrix2x3fvEXT(program, location, value.remaining() / 6, transpose, MemoryUtil.getAddress(value), l);
    }

    static native void nglProgramUniformMatrix2x3fvEXT(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix3x2EXT(int program, int location, boolean transpose, FloatBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniformMatrix3x2fvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        EXTDirectStateAccess.nglProgramUniformMatrix3x2fvEXT(program, location, value.remaining() / 6, transpose, MemoryUtil.getAddress(value), l);
    }

    static native void nglProgramUniformMatrix3x2fvEXT(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix2x4EXT(int program, int location, boolean transpose, FloatBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniformMatrix2x4fvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        EXTDirectStateAccess.nglProgramUniformMatrix2x4fvEXT(program, location, value.remaining() >> 3, transpose, MemoryUtil.getAddress(value), l);
    }

    static native void nglProgramUniformMatrix2x4fvEXT(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix4x2EXT(int program, int location, boolean transpose, FloatBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniformMatrix4x2fvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        EXTDirectStateAccess.nglProgramUniformMatrix4x2fvEXT(program, location, value.remaining() >> 3, transpose, MemoryUtil.getAddress(value), l);
    }

    static native void nglProgramUniformMatrix4x2fvEXT(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix3x4EXT(int program, int location, boolean transpose, FloatBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniformMatrix3x4fvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        EXTDirectStateAccess.nglProgramUniformMatrix3x4fvEXT(program, location, value.remaining() / 12, transpose, MemoryUtil.getAddress(value), l);
    }

    static native void nglProgramUniformMatrix3x4fvEXT(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix4x3EXT(int program, int location, boolean transpose, FloatBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniformMatrix4x3fvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        EXTDirectStateAccess.nglProgramUniformMatrix4x3fvEXT(program, location, value.remaining() / 12, transpose, MemoryUtil.getAddress(value), l);
    }

    static native void nglProgramUniformMatrix4x3fvEXT(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glTextureBufferEXT(int texture, int target, int internalformat, int buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureBufferEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglTextureBufferEXT(texture, target, internalformat, buffer, l);
    }

    static native void nglTextureBufferEXT(int var0, int var1, int var2, int var3, long var4);

    public static void glMultiTexBufferEXT(int texunit, int target, int internalformat, int buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexBufferEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglMultiTexBufferEXT(texunit, target, internalformat, buffer, l);
    }

    static native void nglMultiTexBufferEXT(int var0, int var1, int var2, int var3, long var4);

    public static void glTextureParameterIEXT(int texture, int target, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureParameterIivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglTextureParameterIivEXT(texture, target, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglTextureParameterIivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glTextureParameterIEXT(int texture, int target, int pname, int param) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureParameterIivEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglTextureParameterIivEXT(texture, target, pname, APIUtil.getInt(contextCapabilities, param), l);
    }

    public static void glTextureParameterIuEXT(int texture, int target, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureParameterIuivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglTextureParameterIuivEXT(texture, target, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglTextureParameterIuivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glTextureParameterIuEXT(int texture, int target, int pname, int param) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureParameterIuivEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglTextureParameterIuivEXT(texture, target, pname, APIUtil.getInt(contextCapabilities, param), l);
    }

    public static void glGetTextureParameterIEXT(int texture, int target, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetTextureParameterIivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglGetTextureParameterIivEXT(texture, target, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetTextureParameterIivEXT(int var0, int var1, int var2, long var3, long var5);

    public static int glGetTextureParameterIiEXT(int texture, int target, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetTextureParameterIivEXT;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetTextureParameterIivEXT(texture, target, pname, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glGetTextureParameterIuEXT(int texture, int target, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetTextureParameterIuivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglGetTextureParameterIuivEXT(texture, target, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetTextureParameterIuivEXT(int var0, int var1, int var2, long var3, long var5);

    public static int glGetTextureParameterIuiEXT(int texture, int target, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetTextureParameterIuivEXT;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetTextureParameterIuivEXT(texture, target, pname, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glMultiTexParameterIEXT(int texunit, int target, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexParameterIivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglMultiTexParameterIivEXT(texunit, target, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglMultiTexParameterIivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glMultiTexParameterIEXT(int texunit, int target, int pname, int param) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexParameterIivEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglMultiTexParameterIivEXT(texunit, target, pname, APIUtil.getInt(contextCapabilities, param), l);
    }

    public static void glMultiTexParameterIuEXT(int texunit, int target, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexParameterIuivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglMultiTexParameterIuivEXT(texunit, target, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglMultiTexParameterIuivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glMultiTexParameterIuEXT(int texunit, int target, int pname, int param) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexParameterIuivEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglMultiTexParameterIuivEXT(texunit, target, pname, APIUtil.getInt(contextCapabilities, param), l);
    }

    public static void glGetMultiTexParameterIEXT(int texunit, int target, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetMultiTexParameterIivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglGetMultiTexParameterIivEXT(texunit, target, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetMultiTexParameterIivEXT(int var0, int var1, int var2, long var3, long var5);

    public static int glGetMultiTexParameterIiEXT(int texunit, int target, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetMultiTexParameterIivEXT;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetMultiTexParameterIivEXT(texunit, target, pname, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glGetMultiTexParameterIuEXT(int texunit, int target, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetMultiTexParameterIuivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglGetMultiTexParameterIuivEXT(texunit, target, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetMultiTexParameterIuivEXT(int var0, int var1, int var2, long var3, long var5);

    public static int glGetMultiTexParameterIuiEXT(int texunit, int target, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetMultiTexParameterIuivEXT;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetMultiTexParameterIuivEXT(texunit, target, pname, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glProgramUniform1uiEXT(int program, int location, int v0) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniform1uiEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglProgramUniform1uiEXT(program, location, v0, l);
    }

    static native void nglProgramUniform1uiEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform2uiEXT(int program, int location, int v0, int v1) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniform2uiEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglProgramUniform2uiEXT(program, location, v0, v1, l);
    }

    static native void nglProgramUniform2uiEXT(int var0, int var1, int var2, int var3, long var4);

    public static void glProgramUniform3uiEXT(int program, int location, int v0, int v1, int v2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniform3uiEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglProgramUniform3uiEXT(program, location, v0, v1, v2, l);
    }

    static native void nglProgramUniform3uiEXT(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glProgramUniform4uiEXT(int program, int location, int v0, int v1, int v2, int v3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniform4uiEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglProgramUniform4uiEXT(program, location, v0, v1, v2, v3, l);
    }

    static native void nglProgramUniform4uiEXT(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static void glProgramUniform1uEXT(int program, int location, IntBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniform1uivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        EXTDirectStateAccess.nglProgramUniform1uivEXT(program, location, value.remaining(), MemoryUtil.getAddress(value), l);
    }

    static native void nglProgramUniform1uivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform2uEXT(int program, int location, IntBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniform2uivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        EXTDirectStateAccess.nglProgramUniform2uivEXT(program, location, value.remaining() >> 1, MemoryUtil.getAddress(value), l);
    }

    static native void nglProgramUniform2uivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform3uEXT(int program, int location, IntBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniform3uivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        EXTDirectStateAccess.nglProgramUniform3uivEXT(program, location, value.remaining() / 3, MemoryUtil.getAddress(value), l);
    }

    static native void nglProgramUniform3uivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform4uEXT(int program, int location, IntBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniform4uivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        EXTDirectStateAccess.nglProgramUniform4uivEXT(program, location, value.remaining() >> 2, MemoryUtil.getAddress(value), l);
    }

    static native void nglProgramUniform4uivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glNamedProgramLocalParameters4EXT(int program, int target, int index, FloatBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedProgramLocalParameters4fvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(params);
        EXTDirectStateAccess.nglNamedProgramLocalParameters4fvEXT(program, target, index, params.remaining() >> 2, MemoryUtil.getAddress(params), l);
    }

    static native void nglNamedProgramLocalParameters4fvEXT(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glNamedProgramLocalParameterI4iEXT(int program, int target, int index, int x, int y, int z, int w) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedProgramLocalParameterI4iEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglNamedProgramLocalParameterI4iEXT(program, target, index, x, y, z, w, l);
    }

    static native void nglNamedProgramLocalParameterI4iEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7);

    public static void glNamedProgramLocalParameterI4EXT(int program, int target, int index, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedProgramLocalParameterI4ivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglNamedProgramLocalParameterI4ivEXT(program, target, index, MemoryUtil.getAddress(params), l);
    }

    static native void nglNamedProgramLocalParameterI4ivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glNamedProgramLocalParametersI4EXT(int program, int target, int index, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedProgramLocalParametersI4ivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(params);
        EXTDirectStateAccess.nglNamedProgramLocalParametersI4ivEXT(program, target, index, params.remaining() >> 2, MemoryUtil.getAddress(params), l);
    }

    static native void nglNamedProgramLocalParametersI4ivEXT(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glNamedProgramLocalParameterI4uiEXT(int program, int target, int index, int x, int y, int z, int w) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedProgramLocalParameterI4uiEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglNamedProgramLocalParameterI4uiEXT(program, target, index, x, y, z, w, l);
    }

    static native void nglNamedProgramLocalParameterI4uiEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7);

    public static void glNamedProgramLocalParameterI4uEXT(int program, int target, int index, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedProgramLocalParameterI4uivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglNamedProgramLocalParameterI4uivEXT(program, target, index, MemoryUtil.getAddress(params), l);
    }

    static native void nglNamedProgramLocalParameterI4uivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glNamedProgramLocalParametersI4uEXT(int program, int target, int index, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedProgramLocalParametersI4uivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(params);
        EXTDirectStateAccess.nglNamedProgramLocalParametersI4uivEXT(program, target, index, params.remaining() >> 2, MemoryUtil.getAddress(params), l);
    }

    static native void nglNamedProgramLocalParametersI4uivEXT(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glGetNamedProgramLocalParameterIEXT(int program, int target, int index, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedProgramLocalParameterIivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglGetNamedProgramLocalParameterIivEXT(program, target, index, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetNamedProgramLocalParameterIivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glGetNamedProgramLocalParameterIuEXT(int program, int target, int index, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedProgramLocalParameterIuivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglGetNamedProgramLocalParameterIuivEXT(program, target, index, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetNamedProgramLocalParameterIuivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glNamedRenderbufferStorageEXT(int renderbuffer, int internalformat, int width, int height) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedRenderbufferStorageEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglNamedRenderbufferStorageEXT(renderbuffer, internalformat, width, height, l);
    }

    static native void nglNamedRenderbufferStorageEXT(int var0, int var1, int var2, int var3, long var4);

    public static void glGetNamedRenderbufferParameterEXT(int renderbuffer, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedRenderbufferParameterivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglGetNamedRenderbufferParameterivEXT(renderbuffer, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetNamedRenderbufferParameterivEXT(int var0, int var1, long var2, long var4);

    public static int glGetNamedRenderbufferParameterEXT(int renderbuffer, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedRenderbufferParameterivEXT;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetNamedRenderbufferParameterivEXT(renderbuffer, pname, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glNamedRenderbufferStorageMultisampleEXT(int renderbuffer, int samples, int internalformat, int width, int height) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedRenderbufferStorageMultisampleEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglNamedRenderbufferStorageMultisampleEXT(renderbuffer, samples, internalformat, width, height, l);
    }

    static native void nglNamedRenderbufferStorageMultisampleEXT(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glNamedRenderbufferStorageMultisampleCoverageEXT(int renderbuffer, int coverageSamples, int colorSamples, int internalformat, int width, int height) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedRenderbufferStorageMultisampleCoverageEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglNamedRenderbufferStorageMultisampleCoverageEXT(renderbuffer, coverageSamples, colorSamples, internalformat, width, height, l);
    }

    static native void nglNamedRenderbufferStorageMultisampleCoverageEXT(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static int glCheckNamedFramebufferStatusEXT(int framebuffer, int target) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCheckNamedFramebufferStatusEXT;
        BufferChecks.checkFunctionAddress(l);
        int n = EXTDirectStateAccess.nglCheckNamedFramebufferStatusEXT(framebuffer, target, l);
        return n;
    }

    static native int nglCheckNamedFramebufferStatusEXT(int var0, int var1, long var2);

    public static void glNamedFramebufferTexture1DEXT(int framebuffer, int attachment, int textarget, int texture, int level) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedFramebufferTexture1DEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglNamedFramebufferTexture1DEXT(framebuffer, attachment, textarget, texture, level, l);
    }

    static native void nglNamedFramebufferTexture1DEXT(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glNamedFramebufferTexture2DEXT(int framebuffer, int attachment, int textarget, int texture, int level) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedFramebufferTexture2DEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglNamedFramebufferTexture2DEXT(framebuffer, attachment, textarget, texture, level, l);
    }

    static native void nglNamedFramebufferTexture2DEXT(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glNamedFramebufferTexture3DEXT(int framebuffer, int attachment, int textarget, int texture, int level, int zoffset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedFramebufferTexture3DEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglNamedFramebufferTexture3DEXT(framebuffer, attachment, textarget, texture, level, zoffset, l);
    }

    static native void nglNamedFramebufferTexture3DEXT(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static void glNamedFramebufferRenderbufferEXT(int framebuffer, int attachment, int renderbuffertarget, int renderbuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedFramebufferRenderbufferEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglNamedFramebufferRenderbufferEXT(framebuffer, attachment, renderbuffertarget, renderbuffer, l);
    }

    static native void nglNamedFramebufferRenderbufferEXT(int var0, int var1, int var2, int var3, long var4);

    public static void glGetNamedFramebufferAttachmentParameterEXT(int framebuffer, int attachment, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedFramebufferAttachmentParameterivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        EXTDirectStateAccess.nglGetNamedFramebufferAttachmentParameterivEXT(framebuffer, attachment, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetNamedFramebufferAttachmentParameterivEXT(int var0, int var1, int var2, long var3, long var5);

    public static int glGetNamedFramebufferAttachmentParameterEXT(int framebuffer, int attachment, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedFramebufferAttachmentParameterivEXT;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetNamedFramebufferAttachmentParameterivEXT(framebuffer, attachment, pname, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glGenerateTextureMipmapEXT(int texture, int target) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGenerateTextureMipmapEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglGenerateTextureMipmapEXT(texture, target, l);
    }

    static native void nglGenerateTextureMipmapEXT(int var0, int var1, long var2);

    public static void glGenerateMultiTexMipmapEXT(int texunit, int target) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGenerateMultiTexMipmapEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglGenerateMultiTexMipmapEXT(texunit, target, l);
    }

    static native void nglGenerateMultiTexMipmapEXT(int var0, int var1, long var2);

    public static void glFramebufferDrawBufferEXT(int framebuffer, int mode) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glFramebufferDrawBufferEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglFramebufferDrawBufferEXT(framebuffer, mode, l);
    }

    static native void nglFramebufferDrawBufferEXT(int var0, int var1, long var2);

    public static void glFramebufferDrawBuffersEXT(int framebuffer, IntBuffer bufs) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glFramebufferDrawBuffersEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(bufs);
        EXTDirectStateAccess.nglFramebufferDrawBuffersEXT(framebuffer, bufs.remaining(), MemoryUtil.getAddress(bufs), l);
    }

    static native void nglFramebufferDrawBuffersEXT(int var0, int var1, long var2, long var4);

    public static void glFramebufferReadBufferEXT(int framebuffer, int mode) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glFramebufferReadBufferEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglFramebufferReadBufferEXT(framebuffer, mode, l);
    }

    static native void nglFramebufferReadBufferEXT(int var0, int var1, long var2);

    public static void glGetFramebufferParameterEXT(int framebuffer, int pname, IntBuffer param) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetFramebufferParameterivEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(param, 4);
        EXTDirectStateAccess.nglGetFramebufferParameterivEXT(framebuffer, pname, MemoryUtil.getAddress(param), l);
    }

    static native void nglGetFramebufferParameterivEXT(int var0, int var1, long var2, long var4);

    public static int glGetFramebufferParameterEXT(int framebuffer, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetFramebufferParameterivEXT;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetFramebufferParameterivEXT(framebuffer, pname, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glNamedCopyBufferSubDataEXT(int readBuffer, int writeBuffer, long readoffset, long writeoffset, long size) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedCopyBufferSubDataEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglNamedCopyBufferSubDataEXT(readBuffer, writeBuffer, readoffset, writeoffset, size, l);
    }

    static native void nglNamedCopyBufferSubDataEXT(int var0, int var1, long var2, long var4, long var6, long var8);

    public static void glNamedFramebufferTextureEXT(int framebuffer, int attachment, int texture, int level) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedFramebufferTextureEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglNamedFramebufferTextureEXT(framebuffer, attachment, texture, level, l);
    }

    static native void nglNamedFramebufferTextureEXT(int var0, int var1, int var2, int var3, long var4);

    public static void glNamedFramebufferTextureLayerEXT(int framebuffer, int attachment, int texture, int level, int layer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedFramebufferTextureLayerEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglNamedFramebufferTextureLayerEXT(framebuffer, attachment, texture, level, layer, l);
    }

    static native void nglNamedFramebufferTextureLayerEXT(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glNamedFramebufferTextureFaceEXT(int framebuffer, int attachment, int texture, int level, int face) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedFramebufferTextureFaceEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglNamedFramebufferTextureFaceEXT(framebuffer, attachment, texture, level, face, l);
    }

    static native void nglNamedFramebufferTextureFaceEXT(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glTextureRenderbufferEXT(int texture, int target, int renderbuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTextureRenderbufferEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglTextureRenderbufferEXT(texture, target, renderbuffer, l);
    }

    static native void nglTextureRenderbufferEXT(int var0, int var1, int var2, long var3);

    public static void glMultiTexRenderbufferEXT(int texunit, int target, int renderbuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiTexRenderbufferEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglMultiTexRenderbufferEXT(texunit, target, renderbuffer, l);
    }

    static native void nglMultiTexRenderbufferEXT(int var0, int var1, int var2, long var3);

    public static void glVertexArrayVertexOffsetEXT(int vaobj, int buffer, int size, int type, int stride, long offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexArrayVertexOffsetEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglVertexArrayVertexOffsetEXT(vaobj, buffer, size, type, stride, offset, l);
    }

    static native void nglVertexArrayVertexOffsetEXT(int var0, int var1, int var2, int var3, int var4, long var5, long var7);

    public static void glVertexArrayColorOffsetEXT(int vaobj, int buffer, int size, int type, int stride, long offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexArrayColorOffsetEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglVertexArrayColorOffsetEXT(vaobj, buffer, size, type, stride, offset, l);
    }

    static native void nglVertexArrayColorOffsetEXT(int var0, int var1, int var2, int var3, int var4, long var5, long var7);

    public static void glVertexArrayEdgeFlagOffsetEXT(int vaobj, int buffer, int stride, long offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexArrayEdgeFlagOffsetEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglVertexArrayEdgeFlagOffsetEXT(vaobj, buffer, stride, offset, l);
    }

    static native void nglVertexArrayEdgeFlagOffsetEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glVertexArrayIndexOffsetEXT(int vaobj, int buffer, int type, int stride, long offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexArrayIndexOffsetEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglVertexArrayIndexOffsetEXT(vaobj, buffer, type, stride, offset, l);
    }

    static native void nglVertexArrayIndexOffsetEXT(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glVertexArrayNormalOffsetEXT(int vaobj, int buffer, int type, int stride, long offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexArrayNormalOffsetEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglVertexArrayNormalOffsetEXT(vaobj, buffer, type, stride, offset, l);
    }

    static native void nglVertexArrayNormalOffsetEXT(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glVertexArrayTexCoordOffsetEXT(int vaobj, int buffer, int size, int type, int stride, long offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexArrayTexCoordOffsetEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglVertexArrayTexCoordOffsetEXT(vaobj, buffer, size, type, stride, offset, l);
    }

    static native void nglVertexArrayTexCoordOffsetEXT(int var0, int var1, int var2, int var3, int var4, long var5, long var7);

    public static void glVertexArrayMultiTexCoordOffsetEXT(int vaobj, int buffer, int texunit, int size, int type, int stride, long offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexArrayMultiTexCoordOffsetEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglVertexArrayMultiTexCoordOffsetEXT(vaobj, buffer, texunit, size, type, stride, offset, l);
    }

    static native void nglVertexArrayMultiTexCoordOffsetEXT(int var0, int var1, int var2, int var3, int var4, int var5, long var6, long var8);

    public static void glVertexArrayFogCoordOffsetEXT(int vaobj, int buffer, int type, int stride, long offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexArrayFogCoordOffsetEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglVertexArrayFogCoordOffsetEXT(vaobj, buffer, type, stride, offset, l);
    }

    static native void nglVertexArrayFogCoordOffsetEXT(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glVertexArraySecondaryColorOffsetEXT(int vaobj, int buffer, int size, int type, int stride, long offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexArraySecondaryColorOffsetEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglVertexArraySecondaryColorOffsetEXT(vaobj, buffer, size, type, stride, offset, l);
    }

    static native void nglVertexArraySecondaryColorOffsetEXT(int var0, int var1, int var2, int var3, int var4, long var5, long var7);

    public static void glVertexArrayVertexAttribOffsetEXT(int vaobj, int buffer, int index, int size, int type, boolean normalized, int stride, long offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexArrayVertexAttribOffsetEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglVertexArrayVertexAttribOffsetEXT(vaobj, buffer, index, size, type, normalized, stride, offset, l);
    }

    static native void nglVertexArrayVertexAttribOffsetEXT(int var0, int var1, int var2, int var3, int var4, boolean var5, int var6, long var7, long var9);

    public static void glVertexArrayVertexAttribIOffsetEXT(int vaobj, int buffer, int index, int size, int type, int stride, long offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexArrayVertexAttribIOffsetEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglVertexArrayVertexAttribIOffsetEXT(vaobj, buffer, index, size, type, stride, offset, l);
    }

    static native void nglVertexArrayVertexAttribIOffsetEXT(int var0, int var1, int var2, int var3, int var4, int var5, long var6, long var8);

    public static void glEnableVertexArrayEXT(int vaobj, int array) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glEnableVertexArrayEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglEnableVertexArrayEXT(vaobj, array, l);
    }

    static native void nglEnableVertexArrayEXT(int var0, int var1, long var2);

    public static void glDisableVertexArrayEXT(int vaobj, int array) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDisableVertexArrayEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglDisableVertexArrayEXT(vaobj, array, l);
    }

    static native void nglDisableVertexArrayEXT(int var0, int var1, long var2);

    public static void glEnableVertexArrayAttribEXT(int vaobj, int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glEnableVertexArrayAttribEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglEnableVertexArrayAttribEXT(vaobj, index, l);
    }

    static native void nglEnableVertexArrayAttribEXT(int var0, int var1, long var2);

    public static void glDisableVertexArrayAttribEXT(int vaobj, int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDisableVertexArrayAttribEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglDisableVertexArrayAttribEXT(vaobj, index, l);
    }

    static native void nglDisableVertexArrayAttribEXT(int var0, int var1, long var2);

    public static void glGetVertexArrayIntegerEXT(int vaobj, int pname, IntBuffer param) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetVertexArrayIntegervEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(param, 16);
        EXTDirectStateAccess.nglGetVertexArrayIntegervEXT(vaobj, pname, MemoryUtil.getAddress(param), l);
    }

    static native void nglGetVertexArrayIntegervEXT(int var0, int var1, long var2, long var4);

    public static int glGetVertexArrayIntegerEXT(int vaobj, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetVertexArrayIntegervEXT;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetVertexArrayIntegervEXT(vaobj, pname, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static ByteBuffer glGetVertexArrayPointerEXT(int vaobj, int pname, long result_size) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetVertexArrayPointervEXT;
        BufferChecks.checkFunctionAddress(l);
        ByteBuffer byteBuffer = EXTDirectStateAccess.nglGetVertexArrayPointervEXT(vaobj, pname, result_size, l);
        return LWJGLUtil.CHECKS && byteBuffer == null ? null : byteBuffer.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglGetVertexArrayPointervEXT(int var0, int var1, long var2, long var4);

    public static void glGetVertexArrayIntegerEXT(int vaobj, int index, int pname, IntBuffer param) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetVertexArrayIntegeri_vEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(param, 16);
        EXTDirectStateAccess.nglGetVertexArrayIntegeri_vEXT(vaobj, index, pname, MemoryUtil.getAddress(param), l);
    }

    static native void nglGetVertexArrayIntegeri_vEXT(int var0, int var1, int var2, long var3, long var5);

    public static int glGetVertexArrayIntegeriEXT(int vaobj, int index, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetVertexArrayIntegeri_vEXT;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetVertexArrayIntegeri_vEXT(vaobj, index, pname, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static ByteBuffer glGetVertexArrayPointeri_EXT(int vaobj, int index, int pname, long result_size) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetVertexArrayPointeri_vEXT;
        BufferChecks.checkFunctionAddress(l);
        ByteBuffer byteBuffer = EXTDirectStateAccess.nglGetVertexArrayPointeri_vEXT(vaobj, index, pname, result_size, l);
        return LWJGLUtil.CHECKS && byteBuffer == null ? null : byteBuffer.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglGetVertexArrayPointeri_vEXT(int var0, int var1, int var2, long var3, long var5);

    public static ByteBuffer glMapNamedBufferRangeEXT(int buffer, long offset, long length, int access, ByteBuffer old_buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMapNamedBufferRangeEXT;
        BufferChecks.checkFunctionAddress(l);
        if (old_buffer != null) {
            BufferChecks.checkDirect(old_buffer);
        }
        ByteBuffer byteBuffer = EXTDirectStateAccess.nglMapNamedBufferRangeEXT(buffer, offset, length, access, old_buffer, l);
        return LWJGLUtil.CHECKS && byteBuffer == null ? null : byteBuffer.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglMapNamedBufferRangeEXT(int var0, long var1, long var3, int var5, ByteBuffer var6, long var7);

    public static void glFlushMappedNamedBufferRangeEXT(int buffer, long offset, long length) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glFlushMappedNamedBufferRangeEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDirectStateAccess.nglFlushMappedNamedBufferRangeEXT(buffer, offset, length, l);
    }

    static native void nglFlushMappedNamedBufferRangeEXT(int var0, long var1, long var3, long var5);
}

