/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.awt.Canvas;
import java.awt.event.ComponentListener;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.security.AccessController;
import java.util.Arrays;
import java.util.HashSet;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Context;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.ContextGL;
import org.lwjgl.opengl.Display$1;
import org.lwjgl.opengl.Display$2;
import org.lwjgl.opengl.Display$3;
import org.lwjgl.opengl.Display$4;
import org.lwjgl.opengl.Display$5;
import org.lwjgl.opengl.Display$6;
import org.lwjgl.opengl.Display$7;
import org.lwjgl.opengl.DisplayImplementation;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.DrawableGL;
import org.lwjgl.opengl.DrawableLWJGL;
import org.lwjgl.opengl.GlobalLock;
import org.lwjgl.opengl.LinuxDisplay;
import org.lwjgl.opengl.MacOSXDisplay;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.Sync;
import org.lwjgl.opengl.WindowsDisplay;

public final class Display {
    private static final Thread shutdown_hook = new Display$1();
    private static final DisplayImplementation display_impl;
    private static final DisplayMode initial_mode;
    private static Canvas parent;
    private static DisplayMode current_mode;
    private static int x;
    private static ByteBuffer[] cached_icons;
    private static int y;
    private static int width;
    private static int height;
    private static String title;
    private static boolean fullscreen;
    private static int swap_interval;
    private static DrawableLWJGL drawable;
    private static boolean window_created;
    private static boolean parent_resized;
    private static boolean window_resized;
    private static boolean window_resizable;
    private static float r;
    private static float g;
    private static float b;
    private static final ComponentListener component_listener;

    public static Drawable getDrawable() {
        return drawable;
    }

    private static DisplayImplementation createDisplayImplementation() {
        switch (LWJGLUtil.getPlatform()) {
            case 1: {
                return new LinuxDisplay();
            }
            case 3: {
                return new WindowsDisplay();
            }
            case 2: {
                return new MacOSXDisplay();
            }
        }
        throw new IllegalStateException("Unsupported platform");
    }

    private Display() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DisplayMode[] getAvailableDisplayModes() {
        Object object = GlobalLock.lock;
        synchronized (object) {
            DisplayMode[] displayModeArray = display_impl.getAvailableDisplayModes();
            if (displayModeArray == null) {
                return new DisplayMode[0];
            }
            HashSet<DisplayMode> hashSet = new HashSet<DisplayMode>(displayModeArray.length);
            hashSet.addAll(Arrays.asList(displayModeArray));
            DisplayMode[] displayModeArray2 = new DisplayMode[hashSet.size()];
            hashSet.toArray(displayModeArray2);
            LWJGLUtil.log("Removed " + (displayModeArray.length - displayModeArray2.length) + " duplicate displaymodes");
            return displayModeArray2;
        }
    }

    public static DisplayMode getDesktopDisplayMode() {
        return initial_mode;
    }

    public static DisplayMode getDisplayMode() {
        return current_mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDisplayMode(DisplayMode mode) {
        Object object = GlobalLock.lock;
        synchronized (object) {
            if (mode == null) {
                throw new NullPointerException("mode must be non-null");
            }
            boolean bl = Display.isFullscreen();
            current_mode = mode;
            if (Display.isCreated()) {
                Display.destroyWindow();
                try {
                    if (bl && !Display.isFullscreen()) {
                        display_impl.resetDisplayMode();
                    } else if (Display.isFullscreen()) {
                        Display.switchDisplayMode();
                    }
                    Display.createWindow();
                    Display.makeCurrentAndSetSwapInterval();
                }
                catch (LWJGLException lWJGLException) {
                    drawable.destroy();
                    display_impl.resetDisplayMode();
                    throw lWJGLException;
                }
            }
        }
    }

    private static DisplayMode getEffectiveMode() {
        return !Display.isFullscreen() && parent != null ? new DisplayMode(parent.getWidth(), parent.getHeight()) : current_mode;
    }

    private static int getWindowX() {
        if (!Display.isFullscreen() && parent == null) {
            if (x == -1) {
                return Math.max(0, (initial_mode.getWidth() - current_mode.getWidth()) / 2);
            }
            return x;
        }
        return 0;
    }

    private static int getWindowY() {
        if (!Display.isFullscreen() && parent == null) {
            if (y == -1) {
                return Math.max(0, (initial_mode.getHeight() - current_mode.getHeight()) / 2);
            }
            return y;
        }
        return 0;
    }

    private static void createWindow() {
        Canvas canvas;
        if (window_created) {
            return;
        }
        Canvas canvas2 = canvas = Display.isFullscreen() ? null : parent;
        if (canvas != null && !canvas.isDisplayable()) {
            throw new LWJGLException("Parent.isDisplayable() must be true");
        }
        if (canvas != null) {
            canvas.addComponentListener(component_listener);
        }
        DisplayMode displayMode = Display.getEffectiveMode();
        display_impl.createWindow(drawable, displayMode, canvas, Display.getWindowX(), Display.getWindowY());
        window_created = true;
        width = Display.getDisplayMode().getWidth();
        height = Display.getDisplayMode().getHeight();
        Display.setTitle(title);
        Display.initControls();
        if (cached_icons != null) {
            Display.setIcon(cached_icons);
        } else {
            Display.setIcon(new ByteBuffer[]{LWJGLUtil.LWJGLIcon32x32, LWJGLUtil.LWJGLIcon16x16});
        }
    }

    private static void releaseDrawable() {
        try {
            Context context = drawable.getContext();
            if (context != null && context.isCurrent()) {
                context.releaseCurrent();
                context.releaseDrawable();
            }
        }
        catch (LWJGLException lWJGLException) {
            LWJGLUtil.log("Exception occurred while trying to release context: " + lWJGLException);
        }
    }

    private static void destroyWindow() {
        if (!window_created) {
            return;
        }
        if (parent != null) {
            parent.removeComponentListener(component_listener);
        }
        Display.releaseDrawable();
        if (Mouse.isCreated()) {
            Mouse.destroy();
        }
        if (Keyboard.isCreated()) {
            Keyboard.destroy();
        }
        display_impl.destroyWindow();
        window_created = false;
    }

    private static void switchDisplayMode() {
        if (!current_mode.isFullscreenCapable()) {
            throw new IllegalStateException("Only modes acquired from getAvailableDisplayModes() can be used for fullscreen display");
        }
        display_impl.switchDisplayMode(current_mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDisplayConfiguration(float gamma, float brightness, float contrast) {
        Object object = GlobalLock.lock;
        synchronized (object) {
            if (!Display.isCreated()) {
                throw new LWJGLException("Display not yet created.");
            }
            if (brightness < -1.0f || brightness > 1.0f) {
                throw new IllegalArgumentException("Invalid brightness value");
            }
            if (contrast < 0.0f) {
                throw new IllegalArgumentException("Invalid contrast value");
            }
            int n = display_impl.getGammaRampLength();
            if (n == 0) {
                throw new LWJGLException("Display configuration not supported");
            }
            FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(n);
            for (int i = 0; i < n; ++i) {
                float f = (float)i / (float)(n - 1);
                float f2 = (float)Math.pow(f, gamma);
                f2 += brightness;
                if ((f2 = (f2 - 0.5f) * contrast + 0.5f) > 1.0f) {
                    f2 = 1.0f;
                } else if (f2 < 0.0f) {
                    f2 = 0.0f;
                }
                floatBuffer.put(i, f2);
            }
            display_impl.setGammaRamp(floatBuffer);
            LWJGLUtil.log("Gamma set, gamma = " + gamma + ", brightness = " + brightness + ", contrast = " + contrast);
        }
    }

    public static void sync(int fps) {
        Sync.sync(fps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTitle() {
        Object object = GlobalLock.lock;
        synchronized (object) {
            return title;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Canvas getParent() {
        Object object = GlobalLock.lock;
        synchronized (object) {
            return parent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setParent(Canvas parent) {
        Object object = GlobalLock.lock;
        synchronized (object) {
            if (Display.parent != parent) {
                Display.parent = parent;
                if (!Display.isCreated()) {
                    return;
                }
                Display.destroyWindow();
                try {
                    if (Display.isFullscreen()) {
                        Display.switchDisplayMode();
                    } else {
                        display_impl.resetDisplayMode();
                    }
                    Display.createWindow();
                    Display.makeCurrentAndSetSwapInterval();
                }
                catch (LWJGLException lWJGLException) {
                    drawable.destroy();
                    display_impl.resetDisplayMode();
                    throw lWJGLException;
                }
            }
        }
    }

    public static void setFullscreen(boolean fullscreen) {
        Display.setDisplayModeAndFullscreenInternal(fullscreen, current_mode);
    }

    public static void setDisplayModeAndFullscreen(DisplayMode mode) {
        Display.setDisplayModeAndFullscreenInternal(mode.isFullscreenCapable(), mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setDisplayModeAndFullscreenInternal(boolean fullscreen, DisplayMode mode) {
        Object object = GlobalLock.lock;
        synchronized (object) {
            if (mode == null) {
                throw new NullPointerException("mode must be non-null");
            }
            DisplayMode displayMode = current_mode;
            current_mode = mode;
            boolean bl = Display.isFullscreen();
            Display.fullscreen = fullscreen;
            if (bl != Display.isFullscreen() || !mode.equals(displayMode)) {
                if (!Display.isCreated()) {
                    return;
                }
                Display.destroyWindow();
                try {
                    if (Display.isFullscreen()) {
                        Display.switchDisplayMode();
                    } else {
                        display_impl.resetDisplayMode();
                    }
                    Display.createWindow();
                    Display.makeCurrentAndSetSwapInterval();
                }
                catch (LWJGLException lWJGLException) {
                    drawable.destroy();
                    display_impl.resetDisplayMode();
                    throw lWJGLException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFullscreen() {
        Object object = GlobalLock.lock;
        synchronized (object) {
            return fullscreen && current_mode.isFullscreenCapable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTitle(String newTitle) {
        Object object = GlobalLock.lock;
        synchronized (object) {
            if (newTitle == null) {
                newTitle = "";
            }
            title = newTitle;
            if (Display.isCreated()) {
                display_impl.setTitle(title);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCloseRequested() {
        Object object = GlobalLock.lock;
        synchronized (object) {
            if (!Display.isCreated()) {
                throw new IllegalStateException("Cannot determine close requested state of uncreated window");
            }
            return display_impl.isCloseRequested();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isVisible() {
        Object object = GlobalLock.lock;
        synchronized (object) {
            if (!Display.isCreated()) {
                throw new IllegalStateException("Cannot determine minimized state of uncreated window");
            }
            return display_impl.isVisible();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isActive() {
        Object object = GlobalLock.lock;
        synchronized (object) {
            if (!Display.isCreated()) {
                throw new IllegalStateException("Cannot determine focused state of uncreated window");
            }
            return display_impl.isActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDirty() {
        Object object = GlobalLock.lock;
        synchronized (object) {
            if (!Display.isCreated()) {
                throw new IllegalStateException("Cannot determine dirty state of uncreated window");
            }
            return display_impl.isDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processMessages() {
        Object object = GlobalLock.lock;
        synchronized (object) {
            if (!Display.isCreated()) {
                throw new IllegalStateException("Display not created");
            }
            display_impl.update();
        }
        Display.pollDevices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void swapBuffers() {
        Object object = GlobalLock.lock;
        synchronized (object) {
            if (!Display.isCreated()) {
                throw new IllegalStateException("Display not created");
            }
            if (LWJGLUtil.DEBUG) {
                drawable.checkGLError();
            }
            drawable.swapBuffers();
        }
    }

    public static void update() {
        Display.update(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(boolean processMessages) {
        Object object = GlobalLock.lock;
        synchronized (object) {
            if (!Display.isCreated()) {
                throw new IllegalStateException("Display not created");
            }
            if (display_impl.isVisible() || display_impl.isDirty()) {
                try {
                    Display.swapBuffers();
                }
                catch (LWJGLException lWJGLException) {
                    throw new RuntimeException(lWJGLException);
                }
            }
            boolean bl = window_resized = !Display.isFullscreen() && parent == null && display_impl.wasResized();
            if (window_resized) {
                width = display_impl.getWidth();
                height = display_impl.getHeight();
            }
            if (parent_resized) {
                Display.reshape();
                parent_resized = false;
                window_resized = true;
            }
            if (processMessages) {
                Display.processMessages();
            }
        }
    }

    static void pollDevices() {
        if (Mouse.isCreated()) {
            Mouse.poll();
            Mouse.updateCursor();
        }
        if (Keyboard.isCreated()) {
            Keyboard.poll();
        }
        if (Controllers.isCreated()) {
            Controllers.poll();
        }
    }

    public static void releaseContext() {
        drawable.releaseContext();
    }

    public static boolean isCurrent() {
        return drawable.isCurrent();
    }

    public static void makeCurrent() {
        drawable.makeCurrent();
    }

    private static void removeShutdownHook() {
        AccessController.doPrivileged(new Display$3());
    }

    private static void registerShutdownHook() {
        AccessController.doPrivileged(new Display$4());
    }

    public static void create() {
        Display.create(new PixelFormat());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create(PixelFormat pixel_format) {
        Object object = GlobalLock.lock;
        synchronized (object) {
            Display.create(pixel_format, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create(PixelFormat pixel_format, Drawable shared_drawable) {
        Object object = GlobalLock.lock;
        synchronized (object) {
            Display.create(pixel_format, shared_drawable, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create(PixelFormat pixel_format, ContextAttribs attribs) {
        Object object = GlobalLock.lock;
        synchronized (object) {
            Display.create(pixel_format, null, attribs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create(PixelFormat pixel_format, Drawable shared_drawable, ContextAttribs attribs) {
        Object object = GlobalLock.lock;
        synchronized (object) {
            if (Display.isCreated()) {
                throw new IllegalStateException("Only one LWJGL context may be instantiated at any one time.");
            }
            if (pixel_format == null) {
                throw new NullPointerException("pixel_format cannot be null");
            }
            Display.removeShutdownHook();
            Display.registerShutdownHook();
            if (Display.isFullscreen()) {
                Display.switchDisplayMode();
            }
            Display$5 display$5 = new Display$5();
            drawable = display$5;
            try {
                display$5.setPixelFormat(pixel_format, attribs);
                try {
                    Display.createWindow();
                    try {
                        display$5.context = new ContextGL(display$5.peer_info, attribs, shared_drawable != null ? ((DrawableGL)shared_drawable).getContext() : null);
                        try {
                            Display.makeCurrentAndSetSwapInterval();
                            Display.initContext();
                        }
                        catch (LWJGLException lWJGLException) {
                            ((DrawableGL)display$5).destroy();
                            throw lWJGLException;
                        }
                    }
                    catch (LWJGLException lWJGLException) {
                        Display.destroyWindow();
                        throw lWJGLException;
                    }
                }
                catch (LWJGLException lWJGLException) {
                    ((DrawableGL)display$5).destroy();
                    throw lWJGLException;
                }
            }
            catch (LWJGLException lWJGLException) {
                display_impl.resetDisplayMode();
                throw lWJGLException;
            }
        }
    }

    public static void setInitialBackground(float red, float green, float blue) {
        r = red;
        g = green;
        b = blue;
    }

    private static void makeCurrentAndSetSwapInterval() {
        Display.makeCurrent();
        try {
            drawable.checkGLError();
        }
        catch (OpenGLException openGLException) {
            LWJGLUtil.log("OpenGL error during context creation: " + openGLException.getMessage());
        }
        Display.setSwapInterval(swap_interval);
    }

    private static void initContext() {
        drawable.initContext(r, g, b);
        Display.update();
    }

    static DisplayImplementation getImplementation() {
        return display_impl;
    }

    static boolean getPrivilegedBoolean(String property_name) {
        return AccessController.doPrivileged(new Display$6(property_name));
    }

    static String getPrivilegedString(String property_name) {
        return AccessController.doPrivileged(new Display$7(property_name));
    }

    private static void initControls() {
        if (!Display.getPrivilegedBoolean("org.lwjgl.opengl.Display.noinput")) {
            if (!Mouse.isCreated() && !Display.getPrivilegedBoolean("org.lwjgl.opengl.Display.nomouse")) {
                try {
                    Mouse.create();
                }
                catch (LWJGLException lWJGLException) {
                    if (LWJGLUtil.DEBUG) {
                        lWJGLException.printStackTrace(System.err);
                    }
                    LWJGLUtil.log("Failed to create Mouse: " + lWJGLException);
                }
            }
            if (!Keyboard.isCreated() && !Display.getPrivilegedBoolean("org.lwjgl.opengl.Display.nokeyboard")) {
                try {
                    Keyboard.create();
                }
                catch (LWJGLException lWJGLException) {
                    if (LWJGLUtil.DEBUG) {
                        lWJGLException.printStackTrace(System.err);
                    }
                    LWJGLUtil.log("Failed to create Keyboard: " + lWJGLException);
                }
            }
        }
    }

    public static void destroy() {
        if (Display.isCreated()) {
            drawable.destroy();
        }
    }

    private static void reset() {
        display_impl.resetDisplayMode();
        current_mode = initial_mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCreated() {
        Object object = GlobalLock.lock;
        synchronized (object) {
            return window_created;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSwapInterval(int value) {
        Object object = GlobalLock.lock;
        synchronized (object) {
            swap_interval = value;
            if (Display.isCreated()) {
                drawable.setSwapInterval(swap_interval);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setVSyncEnabled(boolean sync) {
        Object object = GlobalLock.lock;
        synchronized (object) {
            Display.setSwapInterval(sync ? 1 : 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLocation(int new_x, int new_y) {
        Object object = GlobalLock.lock;
        synchronized (object) {
            x = new_x;
            y = new_y;
            if (Display.isCreated() && !Display.isFullscreen()) {
                Display.reshape();
            }
        }
    }

    private static void reshape() {
        DisplayMode displayMode = Display.getEffectiveMode();
        display_impl.reshape(Display.getWindowX(), Display.getWindowY(), displayMode.getWidth(), displayMode.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAdapter() {
        Object object = GlobalLock.lock;
        synchronized (object) {
            return display_impl.getAdapter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersion() {
        Object object = GlobalLock.lock;
        synchronized (object) {
            return display_impl.getVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int setIcon(ByteBuffer[] icons) {
        Object object = GlobalLock.lock;
        synchronized (object) {
            if (cached_icons != icons) {
                cached_icons = new ByteBuffer[icons.length];
                for (int i = 0; i < icons.length; ++i) {
                    Display.cached_icons[i] = BufferUtils.createByteBuffer(icons[i].capacity());
                    int n = icons[i].position();
                    cached_icons[i].put(icons[i]);
                    icons[i].position(n);
                    cached_icons[i].flip();
                }
            }
            if (Display.isCreated() && parent == null) {
                return display_impl.setIcon(cached_icons);
            }
            return 0;
        }
    }

    public static void setResizable(boolean resizable) {
        window_resizable = resizable;
        if (Display.isCreated()) {
            display_impl.setResizable(resizable);
        }
    }

    public static boolean isResizable() {
        return window_resizable;
    }

    public static boolean wasResized() {
        return window_resized;
    }

    public static int getX() {
        if (Display.isFullscreen()) {
            return 0;
        }
        if (parent != null) {
            return parent.getX();
        }
        return display_impl.getX();
    }

    public static int getY() {
        if (Display.isFullscreen()) {
            return 0;
        }
        if (parent != null) {
            return parent.getY();
        }
        return display_impl.getY();
    }

    public static int getWidth() {
        if (Display.isFullscreen()) {
            return Display.getDisplayMode().getWidth();
        }
        if (parent != null) {
            return parent.getWidth();
        }
        return width;
    }

    public static int getHeight() {
        if (Display.isFullscreen()) {
            return Display.getDisplayMode().getHeight();
        }
        if (parent != null) {
            return parent.getHeight();
        }
        return height;
    }

    public static float getPixelScaleFactor() {
        return display_impl.getPixelScaleFactor();
    }

    static /* synthetic */ void access$000() {
        Display.reset();
    }

    static /* synthetic */ boolean access$102(boolean x0) {
        parent_resized = x0;
        return parent_resized;
    }

    static /* synthetic */ Thread access$200() {
        return shutdown_hook;
    }

    static /* synthetic */ void access$300() {
        Display.releaseDrawable();
    }

    static /* synthetic */ void access$400() {
        Display.destroyWindow();
    }

    static /* synthetic */ int access$502(int x0) {
        x = x0;
        return x;
    }

    static /* synthetic */ int access$602(int x0) {
        y = x0;
        return y;
    }

    static /* synthetic */ ByteBuffer[] access$702(ByteBuffer[] x0) {
        cached_icons = x0;
        return x0;
    }

    static /* synthetic */ void access$800() {
        Display.removeShutdownHook();
    }

    static {
        x = -1;
        y = -1;
        width = 0;
        height = 0;
        title = "Game";
        component_listener = new Display$2();
        Sys.initialize();
        display_impl = Display.createDisplayImplementation();
        try {
            current_mode = initial_mode = display_impl.init();
            LWJGLUtil.log("Initial mode: " + initial_mode);
        }
        catch (LWJGLException lWJGLException) {
            throw new RuntimeException(lWJGLException);
        }
    }
}

