/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.awt.Canvas;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.AWTSurfaceLock$1;

final class AWTSurfaceLock {
    private static final int WAIT_DELAY_MILLIS = 100;
    private final ByteBuffer lock_buffer = AWTSurfaceLock.createHandle();
    private boolean firstLockSucceeded;

    AWTSurfaceLock() {
    }

    private static native ByteBuffer createHandle();

    public ByteBuffer lockAndGetHandle(Canvas component) {
        while (!this.privilegedLockAndInitHandle(component)) {
            LWJGLUtil.log("Could not get drawing surface info, retrying...");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                LWJGLUtil.log("Interrupted while retrying: " + interruptedException);
            }
        }
        return this.lock_buffer;
    }

    private boolean privilegedLockAndInitHandle(Canvas component) {
        if (this.firstLockSucceeded) {
            return AWTSurfaceLock.lockAndInitHandle(this.lock_buffer, component);
        }
        try {
            this.firstLockSucceeded = AccessController.doPrivileged(new AWTSurfaceLock$1(this, component));
            return this.firstLockSucceeded;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (LWJGLException)privilegedActionException.getException();
        }
    }

    private static native boolean lockAndInitHandle(ByteBuffer var0, Canvas var1);

    void unlock() {
        AWTSurfaceLock.nUnlock(this.lock_buffer);
    }

    private static native void nUnlock(ByteBuffer var0);

    static /* synthetic */ ByteBuffer access$000(AWTSurfaceLock x0) {
        return x0.lock_buffer;
    }

    static /* synthetic */ boolean access$100(ByteBuffer x0, Canvas x1) {
        return AWTSurfaceLock.lockAndInitHandle(x0, x1);
    }
}

