/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.opengl.GLContext;

public final class ATIMapObjectBuffer {
    private ATIMapObjectBuffer() {
    }

    public static ByteBuffer glMapObjectBufferATI(int buffer, ByteBuffer old_buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMapObjectBufferATI;
        BufferChecks.checkFunctionAddress(l);
        if (old_buffer != null) {
            BufferChecks.checkDirect(old_buffer);
        }
        ByteBuffer byteBuffer = ATIMapObjectBuffer.nglMapObjectBufferATI(buffer, GLChecks.getBufferObjectSizeATI(contextCapabilities, buffer), old_buffer, l);
        return LWJGLUtil.CHECKS && byteBuffer == null ? null : byteBuffer.order(ByteOrder.nativeOrder());
    }

    public static ByteBuffer glMapObjectBufferATI(int buffer, long length, ByteBuffer old_buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMapObjectBufferATI;
        BufferChecks.checkFunctionAddress(l);
        if (old_buffer != null) {
            BufferChecks.checkDirect(old_buffer);
        }
        ByteBuffer byteBuffer = ATIMapObjectBuffer.nglMapObjectBufferATI(buffer, length, old_buffer, l);
        return LWJGLUtil.CHECKS && byteBuffer == null ? null : byteBuffer.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglMapObjectBufferATI(int var0, long var1, ByteBuffer var3, long var4);

    public static void glUnmapObjectBufferATI(int buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUnmapObjectBufferATI;
        BufferChecks.checkFunctionAddress(l);
        ATIMapObjectBuffer.nglUnmapObjectBufferATI(buffer, l);
    }

    static native void nglUnmapObjectBufferATI(int var0, long var1);
}

