/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

public final class ARBShadingLanguageInclude {
    public static final int GL_SHADER_INCLUDE_ARB = 36270;
    public static final int GL_NAMED_STRING_LENGTH_ARB = 36329;
    public static final int GL_NAMED_STRING_TYPE_ARB = 36330;

    private ARBShadingLanguageInclude() {
    }

    public static void glNamedStringARB(int type, ByteBuffer name, ByteBuffer string) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedStringARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(name);
        BufferChecks.checkDirect(string);
        ARBShadingLanguageInclude.nglNamedStringARB(type, name.remaining(), MemoryUtil.getAddress(name), string.remaining(), MemoryUtil.getAddress(string), l);
    }

    static native void nglNamedStringARB(int var0, int var1, long var2, int var4, long var5, long var7);

    public static void glNamedStringARB(int type, CharSequence name, CharSequence string) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNamedStringARB;
        BufferChecks.checkFunctionAddress(l);
        ARBShadingLanguageInclude.nglNamedStringARB(type, name.length(), APIUtil.getBuffer(contextCapabilities, name), string.length(), APIUtil.getBuffer(contextCapabilities, string, name.length()), l);
    }

    public static void glDeleteNamedStringARB(ByteBuffer name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDeleteNamedStringARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(name);
        ARBShadingLanguageInclude.nglDeleteNamedStringARB(name.remaining(), MemoryUtil.getAddress(name), l);
    }

    static native void nglDeleteNamedStringARB(int var0, long var1, long var3);

    public static void glDeleteNamedStringARB(CharSequence name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDeleteNamedStringARB;
        BufferChecks.checkFunctionAddress(l);
        ARBShadingLanguageInclude.nglDeleteNamedStringARB(name.length(), APIUtil.getBuffer(contextCapabilities, name), l);
    }

    public static void glCompileShaderIncludeARB(int shader, int count, ByteBuffer path) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompileShaderIncludeARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(path);
        BufferChecks.checkNullTerminated(path, count);
        ARBShadingLanguageInclude.nglCompileShaderIncludeARB(shader, count, MemoryUtil.getAddress(path), 0L, l);
    }

    static native void nglCompileShaderIncludeARB(int var0, int var1, long var2, long var4, long var6);

    public static void glCompileShaderIncludeARB(int shader, CharSequence[] path) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompileShaderIncludeARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkArray(path);
        ARBShadingLanguageInclude.nglCompileShaderIncludeARB2(shader, path.length, APIUtil.getBuffer(contextCapabilities, path), APIUtil.getLengths(contextCapabilities, path), l);
    }

    static native void nglCompileShaderIncludeARB2(int var0, int var1, long var2, long var4, long var6);

    public static boolean glIsNamedStringARB(ByteBuffer name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glIsNamedStringARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(name);
        boolean bl = ARBShadingLanguageInclude.nglIsNamedStringARB(name.remaining(), MemoryUtil.getAddress(name), l);
        return bl;
    }

    static native boolean nglIsNamedStringARB(int var0, long var1, long var3);

    public static boolean glIsNamedStringARB(CharSequence name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glIsNamedStringARB;
        BufferChecks.checkFunctionAddress(l);
        boolean bl = ARBShadingLanguageInclude.nglIsNamedStringARB(name.length(), APIUtil.getBuffer(contextCapabilities, name), l);
        return bl;
    }

    public static void glGetNamedStringARB(ByteBuffer name, IntBuffer stringlen, ByteBuffer string) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedStringARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(name);
        if (stringlen != null) {
            BufferChecks.checkBuffer(stringlen, 1);
        }
        BufferChecks.checkDirect(string);
        ARBShadingLanguageInclude.nglGetNamedStringARB(name.remaining(), MemoryUtil.getAddress(name), string.remaining(), MemoryUtil.getAddressSafe(stringlen), MemoryUtil.getAddress(string), l);
    }

    static native void nglGetNamedStringARB(int var0, long var1, int var3, long var4, long var6, long var8);

    public static void glGetNamedStringARB(CharSequence name, IntBuffer stringlen, ByteBuffer string) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedStringARB;
        BufferChecks.checkFunctionAddress(l);
        if (stringlen != null) {
            BufferChecks.checkBuffer(stringlen, 1);
        }
        BufferChecks.checkDirect(string);
        ARBShadingLanguageInclude.nglGetNamedStringARB(name.length(), APIUtil.getBuffer(contextCapabilities, name), string.remaining(), MemoryUtil.getAddressSafe(stringlen), MemoryUtil.getAddress(string), l);
    }

    public static String glGetNamedStringARB(CharSequence name, int bufSize) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedStringARB;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, bufSize + name.length());
        ARBShadingLanguageInclude.nglGetNamedStringARB(name.length(), APIUtil.getBuffer(contextCapabilities, name), bufSize, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress(byteBuffer), l);
        byteBuffer.limit(name.length() + intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static void glGetNamedStringARB(ByteBuffer name, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedStringivARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(name);
        BufferChecks.checkBuffer(params, 1);
        ARBShadingLanguageInclude.nglGetNamedStringivARB(name.remaining(), MemoryUtil.getAddress(name), pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetNamedStringivARB(int var0, long var1, int var3, long var4, long var6);

    public static void glGetNamedStringiARB(CharSequence name, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedStringivARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 1);
        ARBShadingLanguageInclude.nglGetNamedStringivARB(name.length(), APIUtil.getBuffer(contextCapabilities, name), pname, MemoryUtil.getAddress(params), l);
    }

    public static int glGetNamedStringiARB(CharSequence name, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedStringivARB;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        ARBShadingLanguageInclude.nglGetNamedStringivARB(name.length(), APIUtil.getBuffer(contextCapabilities, name), pname, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }
}

