/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.APIUtil;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLPlatform;
import org.lwjgl.opencl.CLPlatform$CLPlatformUtil;
import org.lwjgl.opencl.InfoUtilAbstract;
import org.lwjgl.opencl.InfoUtilFactory$1;
import org.lwjgl.opencl.api.Filter;

final class InfoUtilFactory$CLPlatformUtil
extends InfoUtilAbstract<CLPlatform>
implements CLPlatform$CLPlatformUtil {
    private InfoUtilFactory$CLPlatformUtil() {
    }

    @Override
    protected int getInfo(CLPlatform platform, int param_name, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        return CL10.clGetPlatformInfo(platform, param_name, param_value, param_value_size_ret);
    }

    @Override
    public List<CLPlatform> getPlatforms(Filter<CLPlatform> filter) {
        IntBuffer intBuffer = APIUtil.getBufferInt();
        CL10.clGetPlatformIDs(null, intBuffer);
        int n = intBuffer.get(0);
        if (n == 0) {
            return null;
        }
        PointerBuffer pointerBuffer = APIUtil.getBufferPointer(n);
        CL10.clGetPlatformIDs(pointerBuffer, null);
        ArrayList<CLPlatform> arrayList = new ArrayList<CLPlatform>(n);
        for (int i = 0; i < n; ++i) {
            CLPlatform cLPlatform = CLPlatform.getCLPlatform(pointerBuffer.get(i));
            if (filter != null && !filter.accept(cLPlatform)) continue;
            arrayList.add(cLPlatform);
        }
        return arrayList.size() == 0 ? null : arrayList;
    }

    @Override
    public List<CLDevice> getDevices(CLPlatform platform, int device_type, Filter<CLDevice> filter) {
        platform.checkValid();
        IntBuffer intBuffer = APIUtil.getBufferInt();
        CL10.clGetDeviceIDs(platform, device_type, null, intBuffer);
        int n = intBuffer.get(0);
        if (n == 0) {
            return null;
        }
        PointerBuffer pointerBuffer = APIUtil.getBufferPointer(n);
        CL10.clGetDeviceIDs(platform, device_type, pointerBuffer, null);
        ArrayList<CLDevice> arrayList = new ArrayList<CLDevice>(n);
        for (int i = 0; i < n; ++i) {
            CLDevice cLDevice = platform.getCLDevice(pointerBuffer.get(i));
            if (filter != null && !filter.accept(cLDevice)) continue;
            arrayList.add(cLDevice);
        }
        return arrayList.size() == 0 ? null : arrayList;
    }

    /* synthetic */ InfoUtilFactory$CLPlatformUtil(InfoUtilFactory$1 x0) {
        this();
    }
}

