/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLObject;
import org.lwjgl.opencl.CLObjectRegistry;
import org.lwjgl.opencl.CLPlatform$CLPlatformUtil;
import org.lwjgl.opencl.FastLongMap;
import org.lwjgl.opencl.InfoUtil;
import org.lwjgl.opencl.api.Filter;

public final class CLPlatform
extends CLObject {
    private static final CLPlatform$CLPlatformUtil util = (CLPlatform$CLPlatformUtil)CLPlatform.getInfoUtilInstance(CLPlatform.class, "CL_PLATFORM_UTIL");
    private static final FastLongMap<CLPlatform> clPlatforms = new FastLongMap();
    private final CLObjectRegistry<CLDevice> clDevices;
    private Object caps;

    CLPlatform(long pointer) {
        super(pointer);
        if (this.isValid()) {
            clPlatforms.put(pointer, this);
            this.clDevices = new CLObjectRegistry();
        } else {
            this.clDevices = null;
        }
    }

    public static CLPlatform getCLPlatform(long id) {
        return clPlatforms.get(id);
    }

    public CLDevice getCLDevice(long id) {
        return this.clDevices.getObject(id);
    }

    static <T extends CLObject> InfoUtil<T> getInfoUtilInstance(Class<T> clazz, String fieldName) {
        InfoUtil infoUtil = null;
        try {
            Class<?> clazz2 = Class.forName("org.lwjgl.opencl.InfoUtilFactory");
            infoUtil = (InfoUtil)clazz2.getDeclaredField(fieldName).get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return infoUtil;
    }

    public static List<CLPlatform> getPlatforms() {
        return CLPlatform.getPlatforms(null);
    }

    public static List<CLPlatform> getPlatforms(Filter<CLPlatform> filter) {
        return util.getPlatforms(filter);
    }

    public String getInfoString(int param_name) {
        return util.getInfoString(this, param_name);
    }

    public List<CLDevice> getDevices(int device_type) {
        return this.getDevices(device_type, null);
    }

    public List<CLDevice> getDevices(int device_type, Filter<CLDevice> filter) {
        return util.getDevices(this, device_type, filter);
    }

    void setCapabilities(Object caps) {
        this.caps = caps;
    }

    Object getCapabilities() {
        return this.caps;
    }

    static void registerCLPlatforms(PointerBuffer platforms, IntBuffer num_platforms) {
        if (platforms == null) {
            return;
        }
        int n = platforms.position();
        int n2 = Math.min(num_platforms.get(0), platforms.remaining());
        for (int i = 0; i < n2; ++i) {
            long l = platforms.get(n + i);
            if (clPlatforms.containsKey(l)) continue;
            new CLPlatform(l);
        }
    }

    CLObjectRegistry<CLDevice> getCLDeviceRegistry() {
        return this.clDevices;
    }

    void registerCLDevices(PointerBuffer devices, IntBuffer num_devices) {
        int n = devices.position();
        int n2 = Math.min(num_devices.get(num_devices.position()), devices.remaining());
        for (int i = 0; i < n2; ++i) {
            long l = devices.get(n + i);
            if (this.clDevices.hasObject(l)) continue;
            new CLDevice(l, this);
        }
    }

    void registerCLDevices(ByteBuffer devices, PointerBuffer num_devices) {
        int n = devices.position();
        int n2 = Math.min((int)num_devices.get(num_devices.position()), devices.remaining()) / PointerBuffer.getPointerSize();
        for (int i = 0; i < n2; ++i) {
            long l;
            int n3 = n + i * PointerBuffer.getPointerSize();
            long l2 = l = PointerBuffer.is64Bit() ? devices.getLong(n3) : (long)devices.getInt(n3);
            if (this.clDevices.hasObject(l)) continue;
            new CLDevice(l, this);
        }
    }
}

