/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.util.StringTokenizer;
import org.lwjgl.opencl.APIUtil;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.opencl.CLDevice;

public class CLDeviceCapabilities {
    public final int majorVersion;
    public final int minorVersion;
    public final boolean OpenCL11;
    public final boolean OpenCL12;
    public final boolean CL_AMD_device_attribute_query;
    public final boolean CL_AMD_device_memory_flags;
    public final boolean CL_AMD_fp64;
    public final boolean CL_AMD_media_ops;
    public final boolean CL_AMD_media_ops2;
    public final boolean CL_AMD_offline_devices;
    public final boolean CL_AMD_popcnt;
    public final boolean CL_AMD_printf;
    public final boolean CL_AMD_vec3;
    final boolean CL_APPLE_ContextLoggingFunctions;
    public final boolean CL_APPLE_SetMemObjectDestructor;
    public final boolean CL_APPLE_gl_sharing;
    public final boolean CL_EXT_atomic_counters_32;
    public final boolean CL_EXT_atomic_counters_64;
    public final boolean CL_EXT_device_fission;
    public final boolean CL_EXT_migrate_memobject;
    public final boolean CL_INTEL_immediate_execution;
    public final boolean CL_INTEL_printf;
    public final boolean CL_INTEL_thread_local_exec;
    public final boolean CL_KHR_3d_image_writes;
    public final boolean CL_KHR_byte_addressable_store;
    public final boolean CL_KHR_depth_images;
    public final boolean CL_KHR_fp16;
    public final boolean CL_KHR_fp64;
    public final boolean CL_KHR_gl_depth_images;
    public final boolean CL_KHR_gl_event;
    public final boolean CL_KHR_gl_msaa_sharing;
    public final boolean CL_KHR_gl_sharing;
    public final boolean CL_KHR_global_int32_base_atomics;
    public final boolean CL_KHR_global_int32_extended_atomics;
    public final boolean CL_KHR_image2d_from_buffer;
    public final boolean CL_KHR_initialize_memory;
    public final boolean CL_KHR_int64_base_atomics;
    public final boolean CL_KHR_int64_extended_atomics;
    public final boolean CL_KHR_local_int32_base_atomics;
    public final boolean CL_KHR_local_int32_extended_atomics;
    public final boolean CL_KHR_mipmap_image;
    public final boolean CL_KHR_mipmap_image_writes;
    public final boolean CL_KHR_select_fprounding_mode;
    public final boolean CL_KHR_spir;
    public final boolean CL_KHR_srgb_image_writes;
    public final boolean CL_KHR_subgroups;
    public final boolean CL_KHR_terminate_context;
    public final boolean CL_NV_compiler_options;
    public final boolean CL_NV_device_attribute_query;
    public final boolean CL_NV_pragma_unroll;

    public CLDeviceCapabilities(CLDevice device) {
        Object object;
        String string = device.getInfoString(4144);
        String string2 = device.getInfoString(4143);
        if (!string2.startsWith("OpenCL ")) {
            throw new RuntimeException("Invalid OpenCL version string: " + string2);
        }
        try {
            object = new StringTokenizer(string2.substring(7), ". ");
            this.majorVersion = Integer.parseInt(((StringTokenizer)object).nextToken());
            this.minorVersion = Integer.parseInt(((StringTokenizer)object).nextToken());
            this.OpenCL11 = 1 < this.majorVersion || 1 == this.majorVersion && 1 <= this.minorVersion;
            this.OpenCL12 = 1 < this.majorVersion || 1 == this.majorVersion && 2 <= this.minorVersion;
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("The major and/or minor OpenCL version \"" + string2 + "\" is malformed: " + runtimeException.getMessage());
        }
        object = APIUtil.getExtensions(string);
        this.CL_AMD_device_attribute_query = object.contains("cl_amd_device_attribute_query");
        this.CL_AMD_device_memory_flags = object.contains("cl_amd_device_memory_flags");
        this.CL_AMD_fp64 = object.contains("cl_amd_fp64");
        this.CL_AMD_media_ops = object.contains("cl_amd_media_ops");
        this.CL_AMD_media_ops2 = object.contains("cl_amd_media_ops2");
        this.CL_AMD_offline_devices = object.contains("cl_amd_offline_devices");
        this.CL_AMD_popcnt = object.contains("cl_amd_popcnt");
        this.CL_AMD_printf = object.contains("cl_amd_printf");
        this.CL_AMD_vec3 = object.contains("cl_amd_vec3");
        this.CL_APPLE_ContextLoggingFunctions = object.contains("cl_apple_contextloggingfunctions") && CLCapabilities.CL_APPLE_ContextLoggingFunctions;
        this.CL_APPLE_SetMemObjectDestructor = object.contains("cl_apple_setmemobjectdestructor") && CLCapabilities.CL_APPLE_SetMemObjectDestructor;
        this.CL_APPLE_gl_sharing = object.contains("cl_apple_gl_sharing") && CLCapabilities.CL_APPLE_gl_sharing;
        this.CL_EXT_atomic_counters_32 = object.contains("cl_ext_atomic_counters_32");
        this.CL_EXT_atomic_counters_64 = object.contains("cl_ext_atomic_counters_64");
        this.CL_EXT_device_fission = object.contains("cl_ext_device_fission") && CLCapabilities.CL_EXT_device_fission;
        this.CL_EXT_migrate_memobject = object.contains("cl_ext_migrate_memobject") && CLCapabilities.CL_EXT_migrate_memobject;
        this.CL_INTEL_immediate_execution = object.contains("cl_intel_immediate_execution");
        this.CL_INTEL_printf = object.contains("cl_intel_printf");
        this.CL_INTEL_thread_local_exec = object.contains("cl_intel_thread_local_exec");
        this.CL_KHR_3d_image_writes = object.contains("cl_khr_3d_image_writes");
        this.CL_KHR_byte_addressable_store = object.contains("cl_khr_byte_addressable_store");
        this.CL_KHR_depth_images = object.contains("cl_khr_depth_images");
        this.CL_KHR_fp16 = object.contains("cl_khr_fp16");
        this.CL_KHR_fp64 = object.contains("cl_khr_fp64");
        this.CL_KHR_gl_depth_images = object.contains("cl_khr_gl_depth_images");
        this.CL_KHR_gl_event = object.contains("cl_khr_gl_event") && CLCapabilities.CL_KHR_gl_event;
        this.CL_KHR_gl_msaa_sharing = object.contains("cl_khr_gl_msaa_sharing");
        this.CL_KHR_gl_sharing = object.contains("cl_khr_gl_sharing") && CLCapabilities.CL_KHR_gl_sharing;
        this.CL_KHR_global_int32_base_atomics = object.contains("cl_khr_global_int32_base_atomics");
        this.CL_KHR_global_int32_extended_atomics = object.contains("cl_khr_global_int32_extended_atomics");
        this.CL_KHR_image2d_from_buffer = object.contains("cl_khr_image2d_from_buffer");
        this.CL_KHR_initialize_memory = object.contains("cl_khr_initialize_memory");
        this.CL_KHR_int64_base_atomics = object.contains("cl_khr_int64_base_atomics");
        this.CL_KHR_int64_extended_atomics = object.contains("cl_khr_int64_extended_atomics");
        this.CL_KHR_local_int32_base_atomics = object.contains("cl_khr_local_int32_base_atomics");
        this.CL_KHR_local_int32_extended_atomics = object.contains("cl_khr_local_int32_extended_atomics");
        this.CL_KHR_mipmap_image = object.contains("cl_khr_mipmap_image");
        this.CL_KHR_mipmap_image_writes = object.contains("cl_khr_mipmap_image_writes");
        this.CL_KHR_select_fprounding_mode = object.contains("cl_khr_select_fprounding_mode");
        this.CL_KHR_spir = object.contains("cl_khr_spir");
        this.CL_KHR_srgb_image_writes = object.contains("cl_khr_srgb_image_writes");
        this.CL_KHR_subgroups = object.contains("cl_khr_subgroups") && CLCapabilities.CL_KHR_subgroups;
        this.CL_KHR_terminate_context = object.contains("cl_khr_terminate_context") && CLCapabilities.CL_KHR_terminate_context;
        this.CL_NV_compiler_options = object.contains("cl_nv_compiler_options");
        this.CL_NV_device_attribute_query = object.contains("cl_nv_device_attribute_query");
        this.CL_NV_pragma_unroll = object.contains("cl_nv_pragma_unroll");
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OpenCL ").append(this.majorVersion).append('.').append(this.minorVersion);
        stringBuilder.append(" - Extensions: ");
        if (this.CL_AMD_device_attribute_query) {
            stringBuilder.append("cl_amd_device_attribute_query ");
        }
        if (this.CL_AMD_device_memory_flags) {
            stringBuilder.append("cl_amd_device_memory_flags ");
        }
        if (this.CL_AMD_fp64) {
            stringBuilder.append("cl_amd_fp64 ");
        }
        if (this.CL_AMD_media_ops) {
            stringBuilder.append("cl_amd_media_ops ");
        }
        if (this.CL_AMD_media_ops2) {
            stringBuilder.append("cl_amd_media_ops2 ");
        }
        if (this.CL_AMD_offline_devices) {
            stringBuilder.append("cl_amd_offline_devices ");
        }
        if (this.CL_AMD_popcnt) {
            stringBuilder.append("cl_amd_popcnt ");
        }
        if (this.CL_AMD_printf) {
            stringBuilder.append("cl_amd_printf ");
        }
        if (this.CL_AMD_vec3) {
            stringBuilder.append("cl_amd_vec3 ");
        }
        if (this.CL_APPLE_ContextLoggingFunctions) {
            stringBuilder.append("cl_apple_contextloggingfunctions ");
        }
        if (this.CL_APPLE_SetMemObjectDestructor) {
            stringBuilder.append("cl_apple_setmemobjectdestructor ");
        }
        if (this.CL_APPLE_gl_sharing) {
            stringBuilder.append("cl_apple_gl_sharing ");
        }
        if (this.CL_EXT_atomic_counters_32) {
            stringBuilder.append("cl_ext_atomic_counters_32 ");
        }
        if (this.CL_EXT_atomic_counters_64) {
            stringBuilder.append("cl_ext_atomic_counters_64 ");
        }
        if (this.CL_EXT_device_fission) {
            stringBuilder.append("cl_ext_device_fission ");
        }
        if (this.CL_EXT_migrate_memobject) {
            stringBuilder.append("cl_ext_migrate_memobject ");
        }
        if (this.CL_INTEL_immediate_execution) {
            stringBuilder.append("cl_intel_immediate_execution ");
        }
        if (this.CL_INTEL_printf) {
            stringBuilder.append("cl_intel_printf ");
        }
        if (this.CL_INTEL_thread_local_exec) {
            stringBuilder.append("cl_intel_thread_local_exec ");
        }
        if (this.CL_KHR_3d_image_writes) {
            stringBuilder.append("cl_khr_3d_image_writes ");
        }
        if (this.CL_KHR_byte_addressable_store) {
            stringBuilder.append("cl_khr_byte_addressable_store ");
        }
        if (this.CL_KHR_depth_images) {
            stringBuilder.append("cl_khr_depth_images ");
        }
        if (this.CL_KHR_fp16) {
            stringBuilder.append("cl_khr_fp16 ");
        }
        if (this.CL_KHR_fp64) {
            stringBuilder.append("cl_khr_fp64 ");
        }
        if (this.CL_KHR_gl_depth_images) {
            stringBuilder.append("cl_khr_gl_depth_images ");
        }
        if (this.CL_KHR_gl_event) {
            stringBuilder.append("cl_khr_gl_event ");
        }
        if (this.CL_KHR_gl_msaa_sharing) {
            stringBuilder.append("cl_khr_gl_msaa_sharing ");
        }
        if (this.CL_KHR_gl_sharing) {
            stringBuilder.append("cl_khr_gl_sharing ");
        }
        if (this.CL_KHR_global_int32_base_atomics) {
            stringBuilder.append("cl_khr_global_int32_base_atomics ");
        }
        if (this.CL_KHR_global_int32_extended_atomics) {
            stringBuilder.append("cl_khr_global_int32_extended_atomics ");
        }
        if (this.CL_KHR_image2d_from_buffer) {
            stringBuilder.append("cl_khr_image2d_from_buffer ");
        }
        if (this.CL_KHR_initialize_memory) {
            stringBuilder.append("cl_khr_initialize_memory ");
        }
        if (this.CL_KHR_int64_base_atomics) {
            stringBuilder.append("cl_khr_int64_base_atomics ");
        }
        if (this.CL_KHR_int64_extended_atomics) {
            stringBuilder.append("cl_khr_int64_extended_atomics ");
        }
        if (this.CL_KHR_local_int32_base_atomics) {
            stringBuilder.append("cl_khr_local_int32_base_atomics ");
        }
        if (this.CL_KHR_local_int32_extended_atomics) {
            stringBuilder.append("cl_khr_local_int32_extended_atomics ");
        }
        if (this.CL_KHR_mipmap_image) {
            stringBuilder.append("cl_khr_mipmap_image ");
        }
        if (this.CL_KHR_mipmap_image_writes) {
            stringBuilder.append("cl_khr_mipmap_image_writes ");
        }
        if (this.CL_KHR_select_fprounding_mode) {
            stringBuilder.append("cl_khr_select_fprounding_mode ");
        }
        if (this.CL_KHR_spir) {
            stringBuilder.append("cl_khr_spir ");
        }
        if (this.CL_KHR_srgb_image_writes) {
            stringBuilder.append("cl_khr_srgb_image_writes ");
        }
        if (this.CL_KHR_subgroups) {
            stringBuilder.append("cl_khr_subgroups ");
        }
        if (this.CL_KHR_terminate_context) {
            stringBuilder.append("cl_khr_terminate_context ");
        }
        if (this.CL_NV_compiler_options) {
            stringBuilder.append("cl_nv_compiler_options ");
        }
        if (this.CL_NV_device_attribute_query) {
            stringBuilder.append("cl_nv_device_attribute_query ");
        }
        if (this.CL_NV_pragma_unroll) {
            stringBuilder.append("cl_nv_pragma_unroll ");
        }
        return stringBuilder.toString();
    }
}

