/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.PointerWrapper;
import org.lwjgl.opencl.APIUtil$1;
import org.lwjgl.opencl.APIUtil$10;
import org.lwjgl.opencl.APIUtil$11;
import org.lwjgl.opencl.APIUtil$12;
import org.lwjgl.opencl.APIUtil$2;
import org.lwjgl.opencl.APIUtil$3;
import org.lwjgl.opencl.APIUtil$4;
import org.lwjgl.opencl.APIUtil$5;
import org.lwjgl.opencl.APIUtil$6;
import org.lwjgl.opencl.APIUtil$7;
import org.lwjgl.opencl.APIUtil$8;
import org.lwjgl.opencl.APIUtil$9;
import org.lwjgl.opencl.APIUtil$Buffers;
import org.lwjgl.opencl.APIUtil$ObjectDestructor;
import org.lwjgl.opencl.CLCommandQueue;
import org.lwjgl.opencl.CLContext;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLEvent;
import org.lwjgl.opencl.CLKernel;
import org.lwjgl.opencl.CLMem;
import org.lwjgl.opencl.CLObjectChild;
import org.lwjgl.opencl.CLObjectRegistry;
import org.lwjgl.opencl.CLPlatform;
import org.lwjgl.opencl.CLProgram;
import org.lwjgl.opencl.CLSampler;
import org.lwjgl.opencl.FastLongMap$Entry;

final class APIUtil {
    private static final int INITIAL_BUFFER_SIZE = 256;
    private static final int INITIAL_LENGTHS_SIZE = 4;
    private static final int BUFFERS_SIZE = 32;
    private static final ThreadLocal<char[]> arrayTL = new APIUtil$1();
    private static final ThreadLocal<ByteBuffer> bufferByteTL = new APIUtil$2();
    private static final ThreadLocal<PointerBuffer> bufferPointerTL = new APIUtil$3();
    private static final ThreadLocal<PointerBuffer> lengthsTL = new APIUtil$4();
    private static final ThreadLocal<APIUtil$Buffers> buffersTL = new APIUtil$5();
    private static final APIUtil$ObjectDestructor<CLDevice> DESTRUCTOR_CLSubDevice = new APIUtil$6();
    private static final APIUtil$ObjectDestructor<CLMem> DESTRUCTOR_CLMem = new APIUtil$7();
    private static final APIUtil$ObjectDestructor<CLCommandQueue> DESTRUCTOR_CLCommandQueue = new APIUtil$8();
    private static final APIUtil$ObjectDestructor<CLSampler> DESTRUCTOR_CLSampler = new APIUtil$9();
    private static final APIUtil$ObjectDestructor<CLProgram> DESTRUCTOR_CLProgram = new APIUtil$10();
    private static final APIUtil$ObjectDestructor<CLKernel> DESTRUCTOR_CLKernel = new APIUtil$11();
    private static final APIUtil$ObjectDestructor<CLEvent> DESTRUCTOR_CLEvent = new APIUtil$12();

    private APIUtil() {
    }

    private static char[] getArray(int size) {
        char[] cArray = arrayTL.get();
        if (cArray.length < size) {
            for (int i = cArray.length << 1; i < size; i <<= 1) {
            }
            cArray = new char[size];
            arrayTL.set(cArray);
        }
        return cArray;
    }

    static ByteBuffer getBufferByte(int size) {
        ByteBuffer byteBuffer = bufferByteTL.get();
        if (byteBuffer.capacity() < size) {
            for (int i = byteBuffer.capacity() << 1; i < size; i <<= 1) {
            }
            byteBuffer = BufferUtils.createByteBuffer(size);
            bufferByteTL.set(byteBuffer);
        } else {
            byteBuffer.clear();
        }
        return byteBuffer;
    }

    private static ByteBuffer getBufferByteOffset(int size) {
        ByteBuffer byteBuffer = bufferByteTL.get();
        if (byteBuffer.capacity() < size) {
            for (int i = byteBuffer.capacity() << 1; i < size; i <<= 1) {
            }
            ByteBuffer byteBuffer2 = BufferUtils.createByteBuffer(size);
            byteBuffer2.put(byteBuffer);
            byteBuffer = byteBuffer2;
            bufferByteTL.set(byteBuffer);
        } else {
            byteBuffer.position(byteBuffer.limit());
            byteBuffer.limit(byteBuffer.capacity());
        }
        return byteBuffer;
    }

    static PointerBuffer getBufferPointer(int size) {
        PointerBuffer pointerBuffer = bufferPointerTL.get();
        if (pointerBuffer.capacity() < size) {
            for (int i = pointerBuffer.capacity() << 1; i < size; i <<= 1) {
            }
            pointerBuffer = BufferUtils.createPointerBuffer(size);
            bufferPointerTL.set(pointerBuffer);
        } else {
            pointerBuffer.clear();
        }
        return pointerBuffer;
    }

    static ShortBuffer getBufferShort() {
        return APIUtil.buffersTL.get().shorts;
    }

    static IntBuffer getBufferInt() {
        return APIUtil.buffersTL.get().ints;
    }

    static IntBuffer getBufferIntDebug() {
        return APIUtil.buffersTL.get().intsDebug;
    }

    static LongBuffer getBufferLong() {
        return APIUtil.buffersTL.get().longs;
    }

    static FloatBuffer getBufferFloat() {
        return APIUtil.buffersTL.get().floats;
    }

    static DoubleBuffer getBufferDouble() {
        return APIUtil.buffersTL.get().doubles;
    }

    static PointerBuffer getBufferPointer() {
        return APIUtil.buffersTL.get().pointers;
    }

    static PointerBuffer getLengths() {
        return APIUtil.getLengths(1);
    }

    static PointerBuffer getLengths(int size) {
        PointerBuffer pointerBuffer = lengthsTL.get();
        if (pointerBuffer.capacity() < size) {
            for (int i = pointerBuffer.capacity(); i < size; i <<= 1) {
            }
            pointerBuffer = BufferUtils.createPointerBuffer(size);
            lengthsTL.set(pointerBuffer);
        } else {
            pointerBuffer.clear();
        }
        return pointerBuffer;
    }

    private static ByteBuffer encode(ByteBuffer buffer, CharSequence string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (LWJGLUtil.DEBUG && '\u0080' <= c) {
                buffer.put((byte)26);
                continue;
            }
            buffer.put((byte)c);
        }
        return buffer;
    }

    static String getString(ByteBuffer buffer) {
        int n = buffer.remaining();
        char[] cArray = APIUtil.getArray(n);
        for (int i = buffer.position(); i < buffer.limit(); ++i) {
            cArray[i - buffer.position()] = (char)buffer.get(i);
        }
        return new String(cArray, 0, n);
    }

    static long getBuffer(CharSequence string) {
        ByteBuffer byteBuffer = APIUtil.encode(APIUtil.getBufferByte(string.length()), string);
        byteBuffer.flip();
        return MemoryUtil.getAddress0(byteBuffer);
    }

    static long getBuffer(CharSequence string, int offset) {
        ByteBuffer byteBuffer = APIUtil.encode(APIUtil.getBufferByteOffset(offset + string.length()), string);
        byteBuffer.flip();
        return MemoryUtil.getAddress(byteBuffer);
    }

    static long getBufferNT(CharSequence string) {
        ByteBuffer byteBuffer = APIUtil.encode(APIUtil.getBufferByte(string.length() + 1), string);
        byteBuffer.put((byte)0);
        byteBuffer.flip();
        return MemoryUtil.getAddress0(byteBuffer);
    }

    static int getTotalLength(CharSequence[] strings) {
        int n = 0;
        for (CharSequence charSequence : strings) {
            n += charSequence.length();
        }
        return n;
    }

    static long getBuffer(CharSequence[] strings) {
        ByteBuffer byteBuffer = APIUtil.getBufferByte(APIUtil.getTotalLength(strings));
        for (CharSequence charSequence : strings) {
            APIUtil.encode(byteBuffer, charSequence);
        }
        byteBuffer.flip();
        return MemoryUtil.getAddress0(byteBuffer);
    }

    static long getBufferNT(CharSequence[] strings) {
        ByteBuffer byteBuffer = APIUtil.getBufferByte(APIUtil.getTotalLength(strings) + strings.length);
        for (CharSequence charSequence : strings) {
            APIUtil.encode(byteBuffer, charSequence);
            byteBuffer.put((byte)0);
        }
        byteBuffer.flip();
        return MemoryUtil.getAddress0(byteBuffer);
    }

    static long getLengths(CharSequence[] strings) {
        PointerBuffer pointerBuffer = APIUtil.getLengths(strings.length);
        for (CharSequence charSequence : strings) {
            pointerBuffer.put(charSequence.length());
        }
        pointerBuffer.flip();
        return MemoryUtil.getAddress0(pointerBuffer);
    }

    static long getLengths(ByteBuffer[] buffers) {
        PointerBuffer pointerBuffer = APIUtil.getLengths(buffers.length);
        for (ByteBuffer byteBuffer : buffers) {
            pointerBuffer.put(byteBuffer.remaining());
        }
        pointerBuffer.flip();
        return MemoryUtil.getAddress0(pointerBuffer);
    }

    static int getSize(PointerBuffer lengths) {
        long l = 0L;
        for (int i = lengths.position(); i < lengths.limit(); ++i) {
            l += lengths.get(i);
        }
        return (int)l;
    }

    static long getPointer(PointerWrapper pointer) {
        return MemoryUtil.getAddress0(APIUtil.getBufferPointer().put(0, pointer));
    }

    static long getPointerSafe(PointerWrapper pointer) {
        return MemoryUtil.getAddress0(APIUtil.getBufferPointer().put(0, pointer == null ? 0L : pointer.getPointer()));
    }

    static Set<String> getExtensions(String extensionList) {
        HashSet<String> hashSet = new HashSet<String>();
        if (extensionList != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(extensionList);
            while (stringTokenizer.hasMoreTokens()) {
                hashSet.add(stringTokenizer.nextToken());
            }
        }
        return hashSet;
    }

    static boolean isDevicesParam(int param_name) {
        switch (param_name) {
            case 4225: 
            case 8198: 
            case 8199: 
            case 0x10000002: 
            case 0x10000003: {
                return true;
            }
        }
        return false;
    }

    static CLPlatform getCLPlatform(PointerBuffer properties) {
        long l;
        long l2 = 0L;
        int n = properties.remaining() / 2;
        for (int i = 0; i < n && (l = properties.get(i << 1)) != 0L; ++i) {
            if (l != 4228L) continue;
            l2 = properties.get((i << 1) + 1);
            break;
        }
        if (l2 == 0L) {
            throw new IllegalArgumentException("Could not find CL_CONTEXT_PLATFORM in cl_context_properties.");
        }
        CLPlatform cLPlatform = CLPlatform.getCLPlatform(l2);
        if (cLPlatform == null) {
            throw new IllegalStateException("Could not find a valid CLPlatform. Make sure clGetPlatformIDs has been used before.");
        }
        return cLPlatform;
    }

    static ByteBuffer getNativeKernelArgs(long user_func_ref, CLMem[] clMems, long[] sizes) {
        ByteBuffer byteBuffer = APIUtil.getBufferByte(12 + (clMems == null ? 0 : clMems.length * (4 + PointerBuffer.getPointerSize())));
        byteBuffer.putLong(0, user_func_ref);
        if (clMems == null) {
            byteBuffer.putInt(8, 0);
        } else {
            byteBuffer.putInt(8, clMems.length);
            int n = 12;
            for (int i = 0; i < clMems.length; ++i) {
                if (LWJGLUtil.DEBUG && !clMems[i].isValid()) {
                    throw new IllegalArgumentException("An invalid CLMem object was specified.");
                }
                byteBuffer.putInt(n, (int)sizes[i]);
                n += 4 + PointerBuffer.getPointerSize();
            }
        }
        return byteBuffer;
    }

    static void releaseObjects(CLDevice device) {
        if (!device.isValid() || device.getReferenceCount() > 1) {
            return;
        }
        APIUtil.releaseObjects(device.getSubCLDeviceRegistry(), DESTRUCTOR_CLSubDevice);
    }

    static void releaseObjects(CLContext context) {
        if (!context.isValid() || context.getReferenceCount() > 1) {
            return;
        }
        APIUtil.releaseObjects(context.getCLEventRegistry(), DESTRUCTOR_CLEvent);
        APIUtil.releaseObjects(context.getCLProgramRegistry(), DESTRUCTOR_CLProgram);
        APIUtil.releaseObjects(context.getCLSamplerRegistry(), DESTRUCTOR_CLSampler);
        APIUtil.releaseObjects(context.getCLMemRegistry(), DESTRUCTOR_CLMem);
        APIUtil.releaseObjects(context.getCLCommandQueueRegistry(), DESTRUCTOR_CLCommandQueue);
    }

    static void releaseObjects(CLProgram program) {
        if (!program.isValid() || program.getReferenceCount() > 1) {
            return;
        }
        APIUtil.releaseObjects(program.getCLKernelRegistry(), DESTRUCTOR_CLKernel);
    }

    static void releaseObjects(CLCommandQueue queue) {
        if (!queue.isValid() || queue.getReferenceCount() > 1) {
            return;
        }
        APIUtil.releaseObjects(queue.getCLEventRegistry(), DESTRUCTOR_CLEvent);
    }

    private static <T extends CLObjectChild> void releaseObjects(CLObjectRegistry<T> registry, APIUtil$ObjectDestructor<T> destructor) {
        if (registry.isEmpty()) {
            return;
        }
        for (FastLongMap$Entry<T> fastLongMap$Entry : registry.getAll()) {
            CLObjectChild cLObjectChild = (CLObjectChild)fastLongMap$Entry.value;
            while (cLObjectChild.isValid()) {
                destructor.release(cLObjectChild);
            }
        }
    }
}

