/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.lwjgl.DefaultSysImplementation;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.Sys;
import org.lwjgl.WindowsSysImplementation$1;
import org.lwjgl.opengl.Display;

final class WindowsSysImplementation
extends DefaultSysImplementation {
    private static final int JNI_VERSION = 24;

    WindowsSysImplementation() {
    }

    @Override
    public int getRequiredJNIVersion() {
        return 24;
    }

    @Override
    public long getTimerResolution() {
        return 1000L;
    }

    @Override
    public long getTime() {
        return WindowsSysImplementation.nGetTime();
    }

    private static native long nGetTime();

    @Override
    public boolean has64Bit() {
        return true;
    }

    private static long getHwnd() {
        if (!Display.isCreated()) {
            return 0L;
        }
        try {
            return AccessController.doPrivileged(new WindowsSysImplementation$1());
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new Error(privilegedActionException);
        }
    }

    @Override
    public void alert(String title, String message) {
        if (!Display.isCreated()) {
            WindowsSysImplementation.initCommonControls();
        }
        LWJGLUtil.log(String.format("*** Alert *** %s\n%s\n", title, message));
        ByteBuffer byteBuffer = MemoryUtil.encodeUTF16(title);
        ByteBuffer byteBuffer2 = MemoryUtil.encodeUTF16(message);
        WindowsSysImplementation.nAlert(WindowsSysImplementation.getHwnd(), MemoryUtil.getAddress(byteBuffer), MemoryUtil.getAddress(byteBuffer2));
    }

    private static native void nAlert(long var0, long var2, long var4);

    private static native void initCommonControls();

    @Override
    public boolean openURL(String url) {
        try {
            LWJGLUtil.execPrivileged(new String[]{"rundll32", "url.dll,FileProtocolHandler", url});
            return true;
        }
        catch (Exception exception) {
            LWJGLUtil.log("Failed to open url (" + url + "): " + exception.getMessage());
            return false;
        }
    }

    @Override
    public String getClipboard() {
        return WindowsSysImplementation.nGetClipboard();
    }

    private static native String nGetClipboard();

    static {
        Sys.initialize();
    }
}

