/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.ASMDataTable$ASMData;
import cpw.mods.fml.common.registry.GameRegistry$ItemStackHolder;
import cpw.mods.fml.common.registry.ItemStackHolderRef;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public enum ItemStackHolderInjector {
    INSTANCE;

    private List<ItemStackHolderRef> itemStackHolders = Lists.newArrayList();

    public void inject() {
        FMLLog.getLogger().log(Level.INFO, "Injecting itemstacks");
        for (ItemStackHolderRef itemStackHolderRef : this.itemStackHolders) {
            itemStackHolderRef.apply();
        }
        FMLLog.getLogger().log(Level.INFO, "Itemstack injection complete");
    }

    public void findHolders(ASMDataTable table) {
        FMLLog.info("Identifying ItemStackHolder annotations", new Object[0]);
        Set<ASMDataTable$ASMData> set = table.getAll(GameRegistry$ItemStackHolder.class.getName());
        HashMap hashMap = Maps.newHashMap();
        for (ASMDataTable$ASMData aSMDataTable$ASMData : set) {
            String string = aSMDataTable$ASMData.getClassName();
            String string2 = aSMDataTable$ASMData.getObjectName();
            String string3 = (String)aSMDataTable$ASMData.getAnnotationInfo().get("value");
            int n = aSMDataTable$ASMData.getAnnotationInfo().containsKey("meta") ? (Integer)aSMDataTable$ASMData.getAnnotationInfo().get("meta") : 0;
            String string4 = aSMDataTable$ASMData.getAnnotationInfo().containsKey("nbt") ? (String)aSMDataTable$ASMData.getAnnotationInfo().get("nbt") : "";
            this.addHolder(hashMap, string, string2, string3, n, string4);
        }
        FMLLog.info("Found %d ItemStackHolder annotations", set.size());
    }

    private void addHolder(Map<String, Class<?>> classCache, String className, String annotationTarget, String value, Integer meta, String nbt) {
        Class<?> clazz;
        if (classCache.containsKey(className)) {
            clazz = classCache.get(className);
        } else {
            try {
                clazz = Class.forName(className, true, ((Object)((Object)this)).getClass().getClassLoader());
                classCache.put(className, clazz);
            }
            catch (Exception exception) {
                throw Throwables.propagate((Throwable)exception);
            }
        }
        try {
            Field field = clazz.getField(annotationTarget);
            this.itemStackHolders.add(new ItemStackHolderRef(field, value, meta, nbt));
        }
        catch (Exception exception) {
            throw Throwables.propagate((Throwable)exception);
        }
    }
}

