/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network.internal;

import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLNetworkException;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.handshake.NetworkDispatcher;
import cpw.mods.fml.relauncher.Side;
import fgm.IIiIiIIiIiIiiiiiIiIiIiIIIIIiIiIiIiiiIIIIiIIiIiiiiiiiiiIIIiIIIiii;
import fgm.IIiIiIiIiIiiiIiIiiIiIIIiIIIIIIiiIIiIiiiiIiiiiiiiIiiiiIIiIiiiiIII;
import fgm.iIIiIIiiIiiiiIiIIIIiIIIIIIIIiIIiIIIiIiiiIIiiIiIiiiIIiiIiIIiiiiIi;
import fgm.iIiIIIIIIiiiiIiiiIiIIIiIIiiIiiIiiiiIIiIIiIiIiiiiiiiiiIIiIIIIIIii;
import fgm.iIiIiIIIIiiiiiIIiiIiiIIiiIIIIiiIiIiIiiiIIiIIIiIiiIiiIiiIiiIIiiii;
import fgm.iiIIIIiIIiIIIiIiIIiIiiiiiIiiIiIiiIIIIIIiIIIIIiIIiIiiiIiiiiIiIiIi;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.util.Integers;

@ObfuscationIgnore
public class FMLProxyPacket
extends iIiIIIIIIiiiiIiiiIiIIIiIIiiIiiIiiiiIIiIIiIiIiiiiiiiiiIIiIIIIIIii {
    final String channel;
    private Side target;
    private final ByteBuf payload;
    private iIiIiIIIIiiiiiIIiiIiiIIiiIIIIiiIiIiIiiiIIiIIIiIiiIiiIiiIiiIIiiii netHandler;
    private NetworkDispatcher dispatcher;
    private static Multiset<String> badPackets = ConcurrentHashMultiset.create();
    private static int packetCountWarning = Integers.parseInt((String)System.getProperty("fml.badPacketCounter", "100"), (int)100);

    private FMLProxyPacket(byte[] payload, String channel) {
        this(Unpooled.wrappedBuffer((byte[])payload), channel);
    }

    public FMLProxyPacket(IIiIiIiIiIiiiIiIiiIiIIIiIIIIIIiiIIiIiiiiIiiiiiiiIiiiiIIiIiiiiIII original) {
        this(original.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI(), original.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii());
        this.target = Side.CLIENT;
    }

    public FMLProxyPacket(IIiIiIIiIiIiiiiiIiIiIiIIIIIiIiIiIiiiIIIIiIIiIiiiiiiiiiIIIiIIIiii original) {
        this(original.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI(), original.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii());
        this.target = Side.SERVER;
    }

    public FMLProxyPacket(ByteBuf payload, String channel) {
        this.channel = channel;
        this.payload = payload;
    }

    @Override
    public void readPacketData(iiIIIIiIIiIIIiIiIIiIiiiiiIiiIiIiiIIIIIIiIIIIIiIIiIiiiIiiiiIiIiIi packetbuffer) {
    }

    @Override
    public void writePacketData(iiIIIIiIIiIIIiIiIIiIiiiiiIiiIiIiiIIIIIIiIIIIIiIIiIiiiIiiiiIiIiIi packetbuffer) {
    }

    @Override
    public void processPacket(iIiIiIIIIiiiiiIIiiIiiIIiiIIIIiiIiIiIiiiIIiIIIiIiiIiiIiiIiiIIiiii inethandler) {
        this.netHandler = inethandler;
        FMLEmbeddedChannel fMLEmbeddedChannel = NetworkRegistry.INSTANCE.getChannel(this.channel, this.target);
        if (fMLEmbeddedChannel != null) {
            fMLEmbeddedChannel.attr(NetworkRegistry.NET_HANDLER).set((Object)this.netHandler);
            try {
                if (fMLEmbeddedChannel.writeInbound(new Object[]{this})) {
                    badPackets.add((Object)this.channel);
                    if (badPackets.size() % packetCountWarning == 0) {
                        FMLLog.severe("Detected ongoing potential memory leak. %d packets have leaked. Top offenders", badPackets.size());
                        int n = 0;
                        for (Multiset.Entry entry : Multisets.copyHighestCountFirst(badPackets).entrySet()) {
                            if (n++ > 10) break;
                            FMLLog.severe("\t %s : %d", entry.getElement(), entry.getCount());
                        }
                    }
                }
                fMLEmbeddedChannel.inboundMessages().clear();
            }
            catch (FMLNetworkException fMLNetworkException) {
                FMLLog.log(Level.ERROR, fMLNetworkException, "There was a network exception handling a packet on channel %s", this.channel);
                this.dispatcher.rejectHandshake(fMLNetworkException.getMessage());
            }
            catch (Throwable throwable) {
                FMLLog.log(Level.ERROR, throwable, "There was a critical exception handling a packet on channel %s", this.channel);
                this.dispatcher.rejectHandshake("A fatal error has occured, this connection is terminated");
            }
        }
    }

    public String channel() {
        return this.channel;
    }

    public ByteBuf payload() {
        return this.payload;
    }

    public iIiIiIIIIiiiiiIIiiIiiIIiiIIIIiiIiIiIiiiIIiIIIiIiiIiiIiiIiiIIiiii handler() {
        return this.netHandler;
    }

    public iIiIIIIIIiiiiIiiiIiIIIiIIiiIiiIiiiiIIiIIiIiIiiiiiiiiiIIiIIIIIIii toC17Packet() {
        return new IIiIiIIiIiIiiiiiIiIiIiIIIIIiIiIiIiiiIIIIiIIiIiiiiiiiiiIIIiIIIiii(this.channel, this.payload.array());
    }

    public iIiIIIIIIiiiiIiiiIiIIIiIIiiIiiIiiiiIIiIIiIiIiiiiiiiiiIIiIIIIIIii toS3FPacket() {
        return new IIiIiIiIiIiiiIiIiiIiIIIiIIIIIIiiIIiIiiiiIiiiiiiiIiiiiIIiIiiiiIII(this.channel, this.payload.array());
    }

    public void setTarget(Side target) {
        this.target = target;
    }

    public void setDispatcher(NetworkDispatcher networkDispatcher) {
        this.dispatcher = networkDispatcher;
    }

    public iIIiIIiiIiiiiIiIIIIiIIIIIIIIiIIiIIIiIiiiIIiiIiIiiiIIiiIiIIiiiiIi getOrigin() {
        return this.dispatcher != null ? this.dispatcher.manager : null;
    }

    public NetworkDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public Side getTarget() {
        return this.target;
    }
}

