/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network.handshake;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.handshake.FMLHandshakeMessage;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;

public class FMLHandshakeMessage$ModList
extends FMLHandshakeMessage {
    private Map<String, String> modTags = Maps.newHashMap();

    public FMLHandshakeMessage$ModList() {
    }

    public FMLHandshakeMessage$ModList(List<ModContainer> modList) {
        for (ModContainer modContainer : modList) {
            this.modTags.put(modContainer.getModId(), modContainer.getVersion());
        }
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        ByteBufUtils.writeVarInt(buffer, this.modTags.size(), 2);
        for (Map.Entry<String, String> entry : this.modTags.entrySet()) {
            ByteBufUtils.writeUTF8String(buffer, entry.getKey());
            ByteBufUtils.writeUTF8String(buffer, entry.getValue());
        }
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        int n = ByteBufUtils.readVarInt(buffer, 2);
        for (int i = 0; i < n; ++i) {
            this.modTags.put(ByteBufUtils.readUTF8String(buffer), ByteBufUtils.readUTF8String(buffer));
        }
    }

    public String modListAsString() {
        return Joiner.on((char)',').withKeyValueSeparator("@").join(this.modTags);
    }

    public int modListSize() {
        return this.modTags.size();
    }

    public Map<String, String> modList() {
        return this.modTags;
    }

    @Override
    public String toString(Class<? extends Enum<?>> side) {
        return super.toString(side) + ":" + this.modTags.size() + " mods";
    }
}

