/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.launcher;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.launcher.Yggdrasil;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

@ObfuscationIgnore
public class FMLTweaker
implements ITweaker {
    private File gameDir;
    private Map<String, String> launchArgs;
    private List<String> standaloneArgs;
    private static URI jarLocation;

    public FMLTweaker() {
        System.setProperty("java.net.preferIPv4Stack", "true");
    }

    public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
        this.gameDir = gameDir == null ? new File(".") : gameDir;
        this.launchArgs = (Map)Launch.blackboard.get("launchArgs");
        this.standaloneArgs = Lists.newArrayList();
        if (this.launchArgs == null) {
            this.launchArgs = Maps.newHashMap();
            Launch.blackboard.put("launchArgs", this.launchArgs);
        }
        String string = null;
        for (String string2 : args) {
            if (string2.startsWith("-")) {
                if (string != null) {
                    string = this.launchArgs.put(string, "");
                    continue;
                }
                if (string2.contains("=")) {
                    string = this.launchArgs.put(string2.substring(0, string2.indexOf(61)), string2.substring(string2.indexOf(61) + 1));
                    continue;
                }
                string = string2;
                continue;
            }
            if (string != null) {
                string = this.launchArgs.put(string, string2);
                continue;
            }
            this.standaloneArgs.add(string2);
        }
        if (!this.launchArgs.containsKey("--version")) {
            this.launchArgs.put("--version", profile != null ? profile : "UnknownFMLProfile");
        }
        if (!this.launchArgs.containsKey("--gameDir") && gameDir != null) {
            this.launchArgs.put("--gameDir", gameDir.getAbsolutePath());
        }
        if (!this.launchArgs.containsKey("--assetsDir") && assetsDir != null) {
            this.launchArgs.put("--assetsDir", assetsDir.getAbsolutePath());
        }
        Yggdrasil.login(this.launchArgs);
        try {
            jarLocation = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            LogManager.getLogger((String)"FMLTWEAK").log(Level.ERROR, "Missing URI information for FML tweak");
            throw Throwables.propagate((Throwable)uRISyntaxException);
        }
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
        classLoader.addClassLoaderExclusion("org.apache.");
        classLoader.addClassLoaderExclusion("com.google.common.");
        classLoader.addTransformerExclusion("cpw.mods.fml.repackage.");
        classLoader.addTransformerExclusion("cpw.mods.fml.relauncher.");
        classLoader.addTransformerExclusion("cpw.mods.fml.common.asm.transformers.");
        classLoader.addClassLoaderExclusion("LZMA.");
        FMLLaunchHandler.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(classLoader, this);
        FMLLaunchHandler.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI();
    }

    public String getLaunchTarget() {
        Map map = (Map)Launch.blackboard.get("launchArgs");
        map.remove("--modListFile");
        map.remove("--mods");
        return "net.minecraft.client.main.Main";
    }

    public String[] getLaunchArguments() {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.addAll(this.standaloneArgs);
        for (Map.Entry<String, String> entry : this.launchArgs.entrySet()) {
            arrayList.add(entry.getKey());
            arrayList.add(entry.getValue());
        }
        this.launchArgs.clear();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public File getGameDir() {
        return this.gameDir;
    }

    public static URI getJarLocation() {
        return jarLocation;
    }

    public void injectCascadingTweak(String tweakClassName) {
        List list = (List)Launch.blackboard.get("TweakClasses");
        list.add(tweakClassName);
    }
}

