/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.discovery;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ASMDataTable$ASMData;
import cpw.mods.fml.common.discovery.ASMDataTable$ModContainerPredicate;
import cpw.mods.fml.common.discovery.ModCandidate;
import java.util.List;
import java.util.Map;
import java.util.Set;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;

@ObfuscationIgnore
public class ASMDataTable {
    @ObfuscationIgnore
    private SetMultimap<String, ASMDataTable$ASMData> globalAnnotationData = HashMultimap.create();
    @ObfuscationIgnore
    private Map<ModContainer, SetMultimap<String, ASMDataTable$ASMData>> containerAnnotationData;
    @ObfuscationIgnore
    private List<ModContainer> containers = Lists.newArrayList();
    @ObfuscationIgnore
    private SetMultimap<String, ModCandidate> packageMap = HashMultimap.create();

    @ObfuscationIgnore
    public SetMultimap<String, ASMDataTable$ASMData> getAnnotationsFor(ModContainer container) {
        if (this.containerAnnotationData == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (ModContainer modContainer : this.containers) {
                SetMultimap setMultimap = Multimaps.filterValues(this.globalAnnotationData, (Predicate)new ASMDataTable$ModContainerPredicate(modContainer));
                builder.put((Object)modContainer, (Object)ImmutableSetMultimap.copyOf((Multimap)setMultimap));
            }
            this.containerAnnotationData = builder.build();
        }
        return this.containerAnnotationData.get(container);
    }

    @ObfuscationIgnore
    public Set<ASMDataTable$ASMData> getAll(String annotation) {
        return this.globalAnnotationData.get((Object)annotation);
    }

    @ObfuscationIgnore
    public void addASMData(ModCandidate candidate, String annotation, String className, String objectName, Map<String, Object> annotationInfo) {
        this.globalAnnotationData.put((Object)annotation, (Object)new ASMDataTable$ASMData(candidate, annotation, className, objectName, annotationInfo));
    }

    @ObfuscationIgnore
    public void addContainer(ModContainer container) {
        this.containers.add(container);
    }

    @ObfuscationIgnore
    public void registerPackage(ModCandidate modCandidate, String pkg) {
        this.packageMap.put((Object)pkg, (Object)modCandidate);
    }

    @ObfuscationIgnore
    public Set<ModCandidate> getCandidatesFor(String pkg) {
        return this.packageMap.get((Object)pkg);
    }
}

