/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.base.Strings;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ILanguageAdapter;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.ASMDataTable$ASMData;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Field;
import java.util.Set;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class ProxyInjector {
    @ObfuscationIgnore
    public static void inject(ModContainer mod, ASMDataTable data, Side side, ILanguageAdapter languageAdapter) {
        FMLLog.fine("Attempting to inject @SidedProxy classes into %s", mod.getModId());
        Set set = data.getAnnotationsFor(mod).get((Object)SidedProxy.class.getName());
        ClassLoader classLoader = Loader.instance().getModClassLoader();
        for (ASMDataTable$ASMData aSMDataTable$ASMData : set) {
            try {
                Class<?> clazz = Class.forName(aSMDataTable$ASMData.getClassName(), true, classLoader);
                Field field = clazz.getDeclaredField(aSMDataTable$ASMData.getObjectName());
                if (field == null) {
                    FMLLog.severe("Attempted to load a proxy type into %s.%s but the field was not found", aSMDataTable$ASMData.getClassName(), aSMDataTable$ASMData.getObjectName());
                    throw new LoaderException(String.format("Attempted to load a proxy type into %s.%s but the field was not found", aSMDataTable$ASMData.getClassName(), aSMDataTable$ASMData.getObjectName()));
                }
                field.setAccessible(true);
                SidedProxy sidedProxy = field.getAnnotation(SidedProxy.class);
                if (!Strings.isNullOrEmpty((String)sidedProxy.modId()) && !sidedProxy.modId().equals(mod.getModId())) {
                    FMLLog.fine("Skipping proxy injection for %s.%s since it is not for mod %s", aSMDataTable$ASMData.getClassName(), aSMDataTable$ASMData.getObjectName(), mod.getModId());
                    continue;
                }
                String string = side.isClient() ? sidedProxy.clientSide() : sidedProxy.serverSide();
                Object obj = Class.forName(string, true, classLoader).newInstance();
                if (languageAdapter.supportsStatics() && (field.getModifiers() & 8) == 0) {
                    FMLLog.severe("Attempted to load a proxy type %s into %s.%s, but the field is not static", string, aSMDataTable$ASMData.getClassName(), aSMDataTable$ASMData.getObjectName());
                    throw new LoaderException(String.format("Attempted to load a proxy type %s into %s.%s, but the field is not static", string, aSMDataTable$ASMData.getClassName(), aSMDataTable$ASMData.getObjectName()));
                }
                if (!field.getType().isAssignableFrom(obj.getClass())) {
                    FMLLog.severe("Attempted to load a proxy type %s into %s.%s, but the types don't match", string, aSMDataTable$ASMData.getClassName(), aSMDataTable$ASMData.getObjectName());
                    throw new LoaderException(String.format("Attempted to load a proxy type %s into %s.%s, but the types don't match", string, aSMDataTable$ASMData.getClassName(), aSMDataTable$ASMData.getObjectName()));
                }
                languageAdapter.setProxy(field, clazz, obj);
            }
            catch (Exception exception) {
                FMLLog.log(Level.ERROR, exception, "An error occured trying to load a proxy into %s.%s", aSMDataTable$ASMData.getAnnotationInfo(), aSMDataTable$ASMData.getClassName(), aSMDataTable$ASMData.getObjectName());
                throw new LoaderException(exception);
            }
        }
        languageAdapter.setInternalProxies(mod, side, classLoader);
    }
}

