/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.asm.transformers.ModAPITransformer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Set;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class ModClassLoader
extends URLClassLoader {
    private static final List<String> STANDARD_LIBRARIES = ImmutableList.of((Object)"jinput.jar", (Object)"lwjgl.jar", (Object)"lwjgl_util.jar", (Object)"rt.jar");
    private LaunchClassLoader mainClassLoader;

    public ModClassLoader(ClassLoader parent) {
        super(new URL[0], (ClassLoader)null);
        this.mainClassLoader = (LaunchClassLoader)parent;
    }

    public void addFile(File modFile) {
        URL uRL = modFile.toURI().toURL();
        this.mainClassLoader.addURL(uRL);
    }

    @Override
    public Class<?> loadClass(String name) {
        return this.mainClassLoader.loadClass(name);
    }

    public File[] getParentSources() {
        List list = this.mainClassLoader.getSources();
        File[] fileArray = new File[list.size()];
        try {
            for (int i = 0; i < list.size(); ++i) {
                fileArray[i] = new File(((URL)list.get(i)).toURI());
            }
            return fileArray;
        }
        catch (URISyntaxException uRISyntaxException) {
            FMLLog.log(Level.ERROR, uRISyntaxException, "Unable to process our input to locate the minecraft code", new Object[0]);
            throw new LoaderException(uRISyntaxException);
        }
    }

    public List<String> getDefaultLibraries() {
        return STANDARD_LIBRARIES;
    }

    public void clearNegativeCacheFor(Set<String> classList) {
        this.mainClassLoader.clearNegativeEntries(classList);
    }

    public ModAPITransformer addModAPITransformer(ASMDataTable dataTable) {
        this.mainClassLoader.registerTransformer("cpw.mods.fml.common.asm.transformers.ModAPITransformer");
        List list = this.mainClassLoader.getTransformers();
        ModAPITransformer modAPITransformer = (ModAPITransformer)list.get(list.size() - 1);
        modAPITransformer.initTable(dataTable);
        return modAPITransformer;
    }
}

