/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.FormatCache$ArrayKey;

abstract class FormatCache<F extends Format> {
    static final int NONE = -1;
    private final ConcurrentMap<FormatCache$ArrayKey, F> cInstanceCache = new ConcurrentHashMap<FormatCache$ArrayKey, F>(7);
    private static final ConcurrentMap<FormatCache$ArrayKey, String> cDateTimeInstanceCache = new ConcurrentHashMap<FormatCache$ArrayKey, String>(7);

    FormatCache() {
    }

    public F getInstance() {
        return this.getDateTimeInstance(3, 3, TimeZone.getDefault(), Locale.getDefault());
    }

    public F getInstance(String string, TimeZone timeZone, Locale locale) {
        Format format;
        FormatCache$ArrayKey formatCache$ArrayKey;
        Format format2;
        Validate.notNull(string, "pattern", new Object[0]);
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        if ((format2 = (Format)this.cInstanceCache.get(formatCache$ArrayKey = new FormatCache$ArrayKey(string, timeZone, locale = LocaleUtils.toLocale(locale)))) == null && (format = this.cInstanceCache.putIfAbsent(formatCache$ArrayKey, format2 = this.createInstance(string, timeZone, locale))) != null) {
            format2 = format;
        }
        return (F)format2;
    }

    protected abstract F createInstance(String var1, TimeZone var2, Locale var3);

    private F getDateTimeInstance(Integer n, Integer n2, TimeZone timeZone, Locale locale) {
        locale = LocaleUtils.toLocale(locale);
        String string = FormatCache.getPatternForStyle(n, n2, locale);
        return this.getInstance(string, timeZone, locale);
    }

    F getDateTimeInstance(int n, int n2, TimeZone timeZone, Locale locale) {
        return this.getDateTimeInstance((Integer)n, (Integer)n2, timeZone, locale);
    }

    F getDateInstance(int n, TimeZone timeZone, Locale locale) {
        return this.getDateTimeInstance((Integer)n, null, timeZone, locale);
    }

    F getTimeInstance(int n, TimeZone timeZone, Locale locale) {
        return this.getDateTimeInstance(null, (Integer)n, timeZone, locale);
    }

    static String getPatternForStyle(Integer n, Integer n2, Locale locale) {
        Locale locale2 = LocaleUtils.toLocale(locale);
        FormatCache$ArrayKey formatCache$ArrayKey = new FormatCache$ArrayKey(n, n2, locale2);
        String string = (String)cDateTimeInstanceCache.get(formatCache$ArrayKey);
        if (string == null) {
            try {
                DateFormat dateFormat = n == null ? DateFormat.getTimeInstance(n2, locale2) : (n2 == null ? DateFormat.getDateInstance(n, locale2) : DateFormat.getDateTimeInstance(n, n2, locale2));
                string = ((SimpleDateFormat)dateFormat).toPattern();
                String string2 = cDateTimeInstanceCache.putIfAbsent(formatCache$ArrayKey, string);
                if (string2 != null) {
                    string = string2;
                }
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("No date time pattern for locale: " + locale2);
            }
        }
        return string;
    }
}

