/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.time.DateParser;
import org.apache.commons.lang3.time.FastDateParser$1;
import org.apache.commons.lang3.time.FastDateParser$2;
import org.apache.commons.lang3.time.FastDateParser$3;
import org.apache.commons.lang3.time.FastDateParser$4;
import org.apache.commons.lang3.time.FastDateParser$5;
import org.apache.commons.lang3.time.FastDateParser$CaseInsensitiveTextStrategy;
import org.apache.commons.lang3.time.FastDateParser$ISO8601TimeZoneStrategy;
import org.apache.commons.lang3.time.FastDateParser$NumberStrategy;
import org.apache.commons.lang3.time.FastDateParser$Strategy;
import org.apache.commons.lang3.time.FastDateParser$StrategyAndWidth;
import org.apache.commons.lang3.time.FastDateParser$StrategyParser;
import org.apache.commons.lang3.time.FastDateParser$TimeZoneStrategy;

public class FastDateParser
implements Serializable,
DateParser {
    private static final long serialVersionUID = 3L;
    static final Locale JAPANESE_IMPERIAL = new Locale("ja", "JP", "JP");
    private final String pattern;
    private final TimeZone timeZone;
    private final Locale locale;
    private final int century;
    private final int startYear;
    private transient List<FastDateParser$StrategyAndWidth> patterns;
    private static final Comparator<String> LONGER_FIRST_LOWERCASE = Comparator.reverseOrder();
    private static final ConcurrentMap<Locale, FastDateParser$Strategy>[] caches = new ConcurrentMap[17];
    private static final FastDateParser$Strategy ABBREVIATED_YEAR_STRATEGY = new FastDateParser$1(1);
    private static final FastDateParser$Strategy NUMBER_MONTH_STRATEGY = new FastDateParser$2(2);
    private static final FastDateParser$Strategy LITERAL_YEAR_STRATEGY = new FastDateParser$NumberStrategy(1);
    private static final FastDateParser$Strategy WEEK_OF_YEAR_STRATEGY = new FastDateParser$NumberStrategy(3);
    private static final FastDateParser$Strategy WEEK_OF_MONTH_STRATEGY = new FastDateParser$NumberStrategy(4);
    private static final FastDateParser$Strategy DAY_OF_YEAR_STRATEGY = new FastDateParser$NumberStrategy(6);
    private static final FastDateParser$Strategy DAY_OF_MONTH_STRATEGY = new FastDateParser$NumberStrategy(5);
    private static final FastDateParser$Strategy DAY_OF_WEEK_STRATEGY = new FastDateParser$3(7);
    private static final FastDateParser$Strategy DAY_OF_WEEK_IN_MONTH_STRATEGY = new FastDateParser$NumberStrategy(8);
    private static final FastDateParser$Strategy HOUR_OF_DAY_STRATEGY = new FastDateParser$NumberStrategy(11);
    private static final FastDateParser$Strategy HOUR24_OF_DAY_STRATEGY = new FastDateParser$4(11);
    private static final FastDateParser$Strategy HOUR12_STRATEGY = new FastDateParser$5(10);
    private static final FastDateParser$Strategy HOUR_STRATEGY = new FastDateParser$NumberStrategy(10);
    private static final FastDateParser$Strategy MINUTE_STRATEGY = new FastDateParser$NumberStrategy(12);
    private static final FastDateParser$Strategy SECOND_STRATEGY = new FastDateParser$NumberStrategy(13);
    private static final FastDateParser$Strategy MILLISECOND_STRATEGY = new FastDateParser$NumberStrategy(14);

    protected FastDateParser(String string, TimeZone timeZone, Locale locale) {
        this(string, timeZone, locale, null);
    }

    protected FastDateParser(String string, TimeZone timeZone, Locale locale, Date date) {
        int n;
        this.pattern = string;
        this.timeZone = timeZone;
        this.locale = LocaleUtils.toLocale(locale);
        Calendar calendar = Calendar.getInstance(timeZone, this.locale);
        if (date != null) {
            calendar.setTime(date);
            n = calendar.get(1);
        } else if (this.locale.equals(JAPANESE_IMPERIAL)) {
            n = 0;
        } else {
            calendar.setTime(new Date());
            n = calendar.get(1) - 80;
        }
        this.century = n / 100 * 100;
        this.startYear = n - this.century;
        this.init(calendar);
    }

    private void init(Calendar calendar) {
        FastDateParser$StrategyAndWidth fastDateParser$StrategyAndWidth;
        this.patterns = new ArrayList<FastDateParser$StrategyAndWidth>();
        FastDateParser$StrategyParser fastDateParser$StrategyParser = new FastDateParser$StrategyParser(this, calendar);
        while ((fastDateParser$StrategyAndWidth = fastDateParser$StrategyParser.getNextStrategy()) != null) {
            this.patterns.add(fastDateParser$StrategyAndWidth);
        }
    }

    private static boolean isFormatLetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FastDateParser)) {
            return false;
        }
        FastDateParser fastDateParser = (FastDateParser)object;
        return this.pattern.equals(fastDateParser.pattern) && this.timeZone.equals(fastDateParser.timeZone) && this.locale.equals(fastDateParser.locale);
    }

    public int hashCode() {
        return this.pattern.hashCode() + 13 * (this.timeZone.hashCode() + 13 * this.locale.hashCode());
    }

    public String toString() {
        return "FastDateParser[" + this.pattern + ", " + this.locale + ", " + this.timeZone.getID() + "]";
    }

    public String toStringAll() {
        return "FastDateParser [pattern=" + this.pattern + ", timeZone=" + this.timeZone + ", locale=" + this.locale + ", century=" + this.century + ", startYear=" + this.startYear + ", patterns=" + this.patterns + "]";
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        Calendar calendar = Calendar.getInstance(this.timeZone, this.locale);
        this.init(calendar);
    }

    @Override
    public Object parseObject(String string) {
        return this.parse(string);
    }

    @Override
    public Date parse(String string) {
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = this.parse(string, parsePosition);
        if (date == null) {
            if (this.locale.equals(JAPANESE_IMPERIAL)) {
                throw new ParseException("(The " + this.locale + " locale does not support dates before 1868 AD)\nUnparseable date: \"" + string, parsePosition.getErrorIndex());
            }
            throw new ParseException("Unparseable date: " + string, parsePosition.getErrorIndex());
        }
        return date;
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    @Override
    public Date parse(String string, ParsePosition parsePosition) {
        Calendar calendar = Calendar.getInstance(this.timeZone, this.locale);
        calendar.clear();
        return this.parse(string, parsePosition, calendar) ? calendar.getTime() : null;
    }

    @Override
    public boolean parse(String string, ParsePosition parsePosition, Calendar calendar) {
        ListIterator<FastDateParser$StrategyAndWidth> listIterator2 = this.patterns.listIterator();
        while (listIterator2.hasNext()) {
            FastDateParser$StrategyAndWidth fastDateParser$StrategyAndWidth = listIterator2.next();
            int n = fastDateParser$StrategyAndWidth.getMaxWidth(listIterator2);
            if (fastDateParser$StrategyAndWidth.strategy.parse(this, calendar, string, parsePosition, n)) continue;
            return false;
        }
        return true;
    }

    private static StringBuilder simpleQuote(StringBuilder stringBuilder, String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case '^': 
                case '{': 
                case '|': {
                    stringBuilder.append('\\');
                }
            }
            stringBuilder.append(c);
        }
        if (stringBuilder.charAt(stringBuilder.length() - 1) == '.') {
            stringBuilder.append('?');
        }
        return stringBuilder;
    }

    private static Map<String, Integer> appendDisplayNames(Calendar calendar, Locale locale, int n, StringBuilder stringBuilder) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        locale = LocaleUtils.toLocale(locale);
        Map<String, Integer> map = calendar.getDisplayNames(n, 0, locale);
        TreeSet<String> treeSet = new TreeSet<String>(LONGER_FIRST_LOWERCASE);
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            String string = entry.getKey().toLowerCase(locale);
            if (!treeSet.add(string)) continue;
            hashMap.put(string, entry.getValue());
        }
        for (String string : treeSet) {
            FastDateParser.simpleQuote(stringBuilder, string).append('|');
        }
        return hashMap;
    }

    private int adjustYear(int n) {
        int n2 = this.century + n;
        return n >= this.startYear ? n2 : n2 + 100;
    }

    private FastDateParser$Strategy getStrategy(char c, int n, Calendar calendar) {
        switch (c) {
            default: {
                throw new IllegalArgumentException("Format '" + c + "' not supported");
            }
            case 'D': {
                return DAY_OF_YEAR_STRATEGY;
            }
            case 'E': {
                return this.getLocaleSpecificStrategy(7, calendar);
            }
            case 'F': {
                return DAY_OF_WEEK_IN_MONTH_STRATEGY;
            }
            case 'G': {
                return this.getLocaleSpecificStrategy(0, calendar);
            }
            case 'H': {
                return HOUR_OF_DAY_STRATEGY;
            }
            case 'K': {
                return HOUR_STRATEGY;
            }
            case 'M': {
                return n >= 3 ? this.getLocaleSpecificStrategy(2, calendar) : NUMBER_MONTH_STRATEGY;
            }
            case 'S': {
                return MILLISECOND_STRATEGY;
            }
            case 'W': {
                return WEEK_OF_MONTH_STRATEGY;
            }
            case 'a': {
                return this.getLocaleSpecificStrategy(9, calendar);
            }
            case 'd': {
                return DAY_OF_MONTH_STRATEGY;
            }
            case 'h': {
                return HOUR12_STRATEGY;
            }
            case 'k': {
                return HOUR24_OF_DAY_STRATEGY;
            }
            case 'm': {
                return MINUTE_STRATEGY;
            }
            case 's': {
                return SECOND_STRATEGY;
            }
            case 'u': {
                return DAY_OF_WEEK_STRATEGY;
            }
            case 'w': {
                return WEEK_OF_YEAR_STRATEGY;
            }
            case 'Y': 
            case 'y': {
                return n > 2 ? LITERAL_YEAR_STRATEGY : ABBREVIATED_YEAR_STRATEGY;
            }
            case 'X': {
                return FastDateParser$ISO8601TimeZoneStrategy.getStrategy(n);
            }
            case 'Z': {
                if (n != 2) break;
                return FastDateParser$ISO8601TimeZoneStrategy.access$400();
            }
            case 'z': 
        }
        return this.getLocaleSpecificStrategy(15, calendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConcurrentMap<Locale, FastDateParser$Strategy> getCache(int n) {
        ConcurrentMap<Locale, FastDateParser$Strategy>[] concurrentMapArray = caches;
        synchronized (caches) {
            if (caches[n] == null) {
                FastDateParser.caches[n] = new ConcurrentHashMap<Locale, FastDateParser$Strategy>(3);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return caches[n];
        }
    }

    private FastDateParser$Strategy getLocaleSpecificStrategy(int n, Calendar calendar) {
        FastDateParser$Strategy fastDateParser$Strategy;
        ConcurrentMap<Locale, FastDateParser$Strategy> concurrentMap = FastDateParser.getCache(n);
        FastDateParser$Strategy fastDateParser$Strategy2 = (FastDateParser$Strategy)concurrentMap.get(this.locale);
        if (fastDateParser$Strategy2 == null && (fastDateParser$Strategy = concurrentMap.putIfAbsent(this.locale, fastDateParser$Strategy2 = n == 15 ? new FastDateParser$TimeZoneStrategy(this.locale) : new FastDateParser$CaseInsensitiveTextStrategy(n, calendar, this.locale))) != null) {
            return fastDateParser$Strategy;
        }
        return fastDateParser$Strategy2;
    }

    static /* synthetic */ String access$000(FastDateParser fastDateParser) {
        return fastDateParser.pattern;
    }

    static /* synthetic */ boolean access$100(char c) {
        return FastDateParser.isFormatLetter(c);
    }

    static /* synthetic */ FastDateParser$Strategy access$200(FastDateParser fastDateParser, char c, int n, Calendar calendar) {
        return fastDateParser.getStrategy(c, n, calendar);
    }

    static /* synthetic */ Map access$600(Calendar calendar, Locale locale, int n, StringBuilder stringBuilder) {
        return FastDateParser.appendDisplayNames(calendar, locale, n, stringBuilder);
    }

    static /* synthetic */ int access$700(FastDateParser fastDateParser, int n) {
        return fastDateParser.adjustYear(n);
    }

    static /* synthetic */ Comparator access$800() {
        return LONGER_FIRST_LOWERCASE;
    }

    static /* synthetic */ StringBuilder access$900(StringBuilder stringBuilder, String string) {
        return FastDateParser.simpleQuote(stringBuilder, string);
    }
}

