/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.builder.ToStringStyle;

final class ToStringStyle$JsonToStringStyle
extends ToStringStyle {
    private static final long serialVersionUID = 1L;
    private static final String FIELD_NAME_QUOTE = "\"";

    ToStringStyle$JsonToStringStyle() {
        this.setUseClassName(false);
        this.setUseIdentityHashCode(false);
        this.setContentStart("{");
        this.setContentEnd("}");
        this.setArrayStart("[");
        this.setArrayEnd("]");
        this.setFieldSeparator(",");
        this.setFieldNameValueSeparator(":");
        this.setNullText("null");
        this.setSummaryObjectStartText("\"<");
        this.setSummaryObjectEndText(">\"");
        this.setSizeStartText("\"<size=");
        this.setSizeEndText(">\"");
    }

    @Override
    public void append(StringBuffer stringBuffer, String string, Object[] objectArray, Boolean bl) {
        if (string == null) {
            throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
        }
        if (!this.isFullDetail(bl)) {
            throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
        }
        super.append(stringBuffer, string, objectArray, bl);
    }

    @Override
    public void append(StringBuffer stringBuffer, String string, long[] lArray, Boolean bl) {
        if (string == null) {
            throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
        }
        if (!this.isFullDetail(bl)) {
            throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
        }
        super.append(stringBuffer, string, lArray, bl);
    }

    @Override
    public void append(StringBuffer stringBuffer, String string, int[] nArray, Boolean bl) {
        if (string == null) {
            throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
        }
        if (!this.isFullDetail(bl)) {
            throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
        }
        super.append(stringBuffer, string, nArray, bl);
    }

    @Override
    public void append(StringBuffer stringBuffer, String string, short[] sArray, Boolean bl) {
        if (string == null) {
            throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
        }
        if (!this.isFullDetail(bl)) {
            throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
        }
        super.append(stringBuffer, string, sArray, bl);
    }

    @Override
    public void append(StringBuffer stringBuffer, String string, byte[] byArray, Boolean bl) {
        if (string == null) {
            throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
        }
        if (!this.isFullDetail(bl)) {
            throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
        }
        super.append(stringBuffer, string, byArray, bl);
    }

    @Override
    public void append(StringBuffer stringBuffer, String string, char[] cArray, Boolean bl) {
        if (string == null) {
            throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
        }
        if (!this.isFullDetail(bl)) {
            throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
        }
        super.append(stringBuffer, string, cArray, bl);
    }

    @Override
    public void append(StringBuffer stringBuffer, String string, double[] dArray, Boolean bl) {
        if (string == null) {
            throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
        }
        if (!this.isFullDetail(bl)) {
            throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
        }
        super.append(stringBuffer, string, dArray, bl);
    }

    @Override
    public void append(StringBuffer stringBuffer, String string, float[] fArray, Boolean bl) {
        if (string == null) {
            throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
        }
        if (!this.isFullDetail(bl)) {
            throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
        }
        super.append(stringBuffer, string, fArray, bl);
    }

    @Override
    public void append(StringBuffer stringBuffer, String string, boolean[] blArray, Boolean bl) {
        if (string == null) {
            throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
        }
        if (!this.isFullDetail(bl)) {
            throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
        }
        super.append(stringBuffer, string, blArray, bl);
    }

    @Override
    public void append(StringBuffer stringBuffer, String string, Object object, Boolean bl) {
        if (string == null) {
            throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
        }
        if (!this.isFullDetail(bl)) {
            throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
        }
        super.append(stringBuffer, string, object, bl);
    }

    @Override
    protected void appendDetail(StringBuffer stringBuffer, String string, char c) {
        this.appendValueAsString(stringBuffer, String.valueOf(c));
    }

    @Override
    protected void appendDetail(StringBuffer stringBuffer, String string, Object object) {
        if (object == null) {
            this.appendNullText(stringBuffer, string);
            return;
        }
        if (object instanceof String || object instanceof Character) {
            this.appendValueAsString(stringBuffer, object.toString());
            return;
        }
        if (object instanceof Number || object instanceof Boolean) {
            stringBuffer.append(object);
            return;
        }
        String string2 = object.toString();
        if (this.isJsonObject(string2) || this.isJsonArray(string2)) {
            stringBuffer.append(object);
            return;
        }
        this.appendDetail(stringBuffer, string, string2);
    }

    @Override
    protected void appendDetail(StringBuffer stringBuffer, String string, Collection<?> collection) {
        if (collection != null && !collection.isEmpty()) {
            stringBuffer.append(this.getArrayStart());
            int n = 0;
            for (Object obj : collection) {
                this.appendDetail(stringBuffer, string, n++, obj);
            }
            stringBuffer.append(this.getArrayEnd());
            return;
        }
        stringBuffer.append(collection);
    }

    @Override
    protected void appendDetail(StringBuffer stringBuffer, String string, Map<?, ?> map) {
        if (map != null && !map.isEmpty()) {
            stringBuffer.append(this.getContentStart());
            boolean bl = true;
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                String string2 = Objects.toString(entry.getKey(), null);
                if (string2 == null) continue;
                if (bl) {
                    bl = false;
                } else {
                    this.appendFieldEnd(stringBuffer, string2);
                }
                this.appendFieldStart(stringBuffer, string2);
                Object obj = entry.getValue();
                if (obj == null) {
                    this.appendNullText(stringBuffer, string2);
                    continue;
                }
                this.appendInternal(stringBuffer, string2, obj, true);
            }
            stringBuffer.append(this.getContentEnd());
            return;
        }
        stringBuffer.append(map);
    }

    private boolean isJsonArray(String string) {
        return string.startsWith(this.getArrayStart()) && string.endsWith(this.getArrayEnd());
    }

    private boolean isJsonObject(String string) {
        return string.startsWith(this.getContentStart()) && string.endsWith(this.getContentEnd());
    }

    private void appendValueAsString(StringBuffer stringBuffer, String string) {
        stringBuffer.append('\"').append(StringEscapeUtils.escapeJson(string)).append('\"');
    }

    @Override
    protected void appendFieldStart(StringBuffer stringBuffer, String string) {
        if (string == null) {
            throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
        }
        super.appendFieldStart(stringBuffer, FIELD_NAME_QUOTE + StringEscapeUtils.escapeJson(string) + FIELD_NAME_QUOTE);
    }

    private Object readResolve() {
        return JSON_STYLE;
    }
}

