/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils$ClassLoaderAwareObjectInputStream;
import org.apache.commons.lang3.Validate;

public class SerializationUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T clone(T t) {
        if (t == null) {
            return null;
        }
        byte[] byArray = SerializationUtils.serialize(t);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try (SerializationUtils$ClassLoaderAwareObjectInputStream serializationUtils$ClassLoaderAwareObjectInputStream = new SerializationUtils$ClassLoaderAwareObjectInputStream(byteArrayInputStream, t.getClass().getClassLoader());){
            Serializable serializable;
            Serializable serializable2 = serializable = (Serializable)serializationUtils$ClassLoaderAwareObjectInputStream.readObject();
            return (T)serializable2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SerializationException("ClassNotFoundException while reading cloned object data", classNotFoundException);
        }
        catch (IOException iOException) {
            throw new SerializationException("IOException while reading or closing cloned object data", iOException);
        }
    }

    public static <T> T deserialize(byte[] byArray) {
        Validate.notNull(byArray, "objectData", new Object[0]);
        return SerializationUtils.deserialize(new ByteArrayInputStream(byArray));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserialize(InputStream inputStream2) {
        Validate.notNull(inputStream2, "inputStream", new Object[0]);
        try (ObjectInputStream objectInputStream = new ObjectInputStream(inputStream2);){
            Object object;
            Object object2 = object = objectInputStream.readObject();
            return (T)object2;
        }
        catch (IOException | ClassNotFoundException exception) {
            throw new SerializationException(exception);
        }
    }

    public static <T extends Serializable> T roundtrip(T t) {
        return (T)((Serializable)SerializationUtils.deserialize(SerializationUtils.serialize(t)));
    }

    public static byte[] serialize(Serializable serializable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        SerializationUtils.serialize(serializable, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static void serialize(Serializable serializable, OutputStream outputStream2) {
        Validate.notNull(outputStream2, "outputStream", new Object[0]);
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream2);){
            objectOutputStream.writeObject(serializable);
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }
}

