/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ObservableInputStream$Observer;
import org.apache.commons.io.input.ProxyInputStream;

public class ObservableInputStream
extends ProxyInputStream {
    private final List<ObservableInputStream$Observer> observers;

    public ObservableInputStream(InputStream inputStream2) {
        this(inputStream2, new ArrayList<ObservableInputStream$Observer>());
    }

    private ObservableInputStream(InputStream inputStream2, List<ObservableInputStream$Observer> list) {
        super(inputStream2);
        this.observers = list;
    }

    public ObservableInputStream(InputStream inputStream2, ObservableInputStream$Observer ... observableInputStream$ObserverArray) {
        this(inputStream2, Arrays.asList(observableInputStream$ObserverArray));
    }

    public void add(ObservableInputStream$Observer observableInputStream$Observer) {
        this.observers.add(observableInputStream$Observer);
    }

    @Override
    public void close() {
        IOException iOException = null;
        try {
            super.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (iOException == null) {
            this.noteClosed();
        } else {
            this.noteError(iOException);
        }
    }

    public void consume() {
        byte[] byArray = IOUtils.byteArray();
        while (this.read(byArray) != -1) {
        }
    }

    public List<ObservableInputStream$Observer> getObservers() {
        return this.observers;
    }

    protected void noteClosed() {
        for (ObservableInputStream$Observer observableInputStream$Observer : this.getObservers()) {
            observableInputStream$Observer.closed();
        }
    }

    protected void noteDataByte(int n) {
        for (ObservableInputStream$Observer observableInputStream$Observer : this.getObservers()) {
            observableInputStream$Observer.data(n);
        }
    }

    protected void noteDataBytes(byte[] byArray, int n, int n2) {
        for (ObservableInputStream$Observer observableInputStream$Observer : this.getObservers()) {
            observableInputStream$Observer.data(byArray, n, n2);
        }
    }

    protected void noteError(IOException iOException) {
        for (ObservableInputStream$Observer observableInputStream$Observer : this.getObservers()) {
            observableInputStream$Observer.error(iOException);
        }
    }

    protected void noteFinished() {
        for (ObservableInputStream$Observer observableInputStream$Observer : this.getObservers()) {
            observableInputStream$Observer.finished();
        }
    }

    private void notify(byte[] byArray, int n, int n2, IOException iOException) {
        if (iOException != null) {
            this.noteError(iOException);
            throw iOException;
        }
        if (n2 == -1) {
            this.noteFinished();
        } else if (n2 > 0) {
            this.noteDataBytes(byArray, n, n2);
        }
    }

    @Override
    public int read() {
        int n = 0;
        IOException iOException = null;
        try {
            n = super.read();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (iOException != null) {
            this.noteError(iOException);
            throw iOException;
        }
        if (n == -1) {
            this.noteFinished();
        } else {
            this.noteDataByte(n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) {
        int n = 0;
        IOException iOException = null;
        try {
            n = super.read(byArray);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        this.notify(byArray, 0, n, iOException);
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        int n3 = 0;
        IOException iOException = null;
        try {
            n3 = super.read(byArray, n, n2);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        this.notify(byArray, n, n3, iOException);
        return n3;
    }

    public void remove(ObservableInputStream$Observer observableInputStream$Observer) {
        this.observers.remove(observableInputStream$Observer);
    }

    public void removeAllObservers() {
        this.observers.clear();
    }
}

