/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.io.DirectoryWalker$CancelException;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

@Deprecated
public abstract class DirectoryWalker<T> {
    private final FileFilter filter;
    private final int depthLimit;

    protected DirectoryWalker() {
        this(null, -1);
    }

    protected DirectoryWalker(FileFilter fileFilter, int n) {
        this.filter = fileFilter;
        this.depthLimit = n;
    }

    protected DirectoryWalker(IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2, int n) {
        if (iOFileFilter == null && iOFileFilter2 == null) {
            this.filter = null;
        } else {
            iOFileFilter = iOFileFilter != null ? iOFileFilter : TrueFileFilter.TRUE;
            iOFileFilter2 = iOFileFilter2 != null ? iOFileFilter2 : TrueFileFilter.TRUE;
            iOFileFilter = FileFilterUtils.makeDirectoryOnly(iOFileFilter);
            iOFileFilter2 = FileFilterUtils.makeFileOnly(iOFileFilter2);
            this.filter = iOFileFilter.or(iOFileFilter2);
        }
        this.depthLimit = n;
    }

    protected final void walk(File file, Collection<T> collection) {
        Objects.requireNonNull(file, "startDirectory");
        try {
            this.handleStart(file, collection);
            this.walk(file, 0, collection);
            this.handleEnd(collection);
        }
        catch (DirectoryWalker$CancelException directoryWalker$CancelException) {
            this.handleCancelled(file, collection, directoryWalker$CancelException);
        }
    }

    private void walk(File file, int n, Collection<T> collection) {
        this.checkIfCancelled(file, n, collection);
        if (this.handleDirectory(file, n, collection)) {
            this.handleDirectoryStart(file, n, collection);
            int n2 = n + 1;
            if (this.depthLimit < 0 || n2 <= this.depthLimit) {
                this.checkIfCancelled(file, n, collection);
                File[] fileArray = this.filter == null ? file.listFiles() : file.listFiles(this.filter);
                fileArray = this.filterDirectoryContents(file, n, fileArray);
                if (fileArray == null) {
                    this.handleRestricted(file, n2, collection);
                } else {
                    for (File file2 : fileArray) {
                        if (file2.isDirectory()) {
                            this.walk(file2, n2, collection);
                            continue;
                        }
                        this.checkIfCancelled(file2, n2, collection);
                        this.handleFile(file2, n2, collection);
                        this.checkIfCancelled(file2, n2, collection);
                    }
                }
            }
            this.handleDirectoryEnd(file, n, collection);
        }
        this.checkIfCancelled(file, n, collection);
    }

    protected final void checkIfCancelled(File file, int n, Collection<T> collection) {
        if (this.handleIsCancelled(file, n, collection)) {
            throw new DirectoryWalker$CancelException(file, n);
        }
    }

    protected boolean handleIsCancelled(File file, int n, Collection<T> collection) {
        return false;
    }

    protected void handleCancelled(File file, Collection<T> collection, DirectoryWalker$CancelException directoryWalker$CancelException) {
        throw directoryWalker$CancelException;
    }

    protected void handleStart(File file, Collection<T> collection) {
    }

    protected boolean handleDirectory(File file, int n, Collection<T> collection) {
        return true;
    }

    protected void handleDirectoryStart(File file, int n, Collection<T> collection) {
    }

    protected File[] filterDirectoryContents(File file, int n, File ... fileArray) {
        return fileArray;
    }

    protected void handleFile(File file, int n, Collection<T> collection) {
    }

    protected void handleRestricted(File file, int n, Collection<T> collection) {
    }

    protected void handleDirectoryEnd(File file, int n, Collection<T> collection) {
    }

    protected void handleEnd(Collection<T> collection) {
    }
}

