/*
 * Decompiled with CFR 0.152.
 */
package okio.internal;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref$BooleanRef;
import kotlin.jvm.internal.Ref$LongRef;
import kotlin.jvm.internal.Ref$ObjectRef;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.FileHandle;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Path$Companion;
import okio.ZipFileSystem;
import okio.internal.EocdRecord;
import okio.internal.ZipEntry;
import okio.internal.ZipFilesKt$buildIndex$$inlined$sortedBy$1;
import okio.internal.ZipFilesKt$openZip$1;
import okio.internal.ZipFilesKt$readEntry$1;
import okio.internal.ZipFilesKt$readOrSkipLocalHeader$1;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\"\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017H\u0002\u001a\u001f\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u001b\u001a.\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 2\u0014\b\u0002\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020#0\"H\u0000\u001a\f\u0010$\u001a\u00020\u0015*\u00020%H\u0000\u001a\f\u0010&\u001a\u00020'*\u00020%H\u0002\u001a.\u0010(\u001a\u00020)*\u00020%2\u0006\u0010*\u001a\u00020\u00012\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020)0,H\u0002\u001a\u0014\u0010-\u001a\u00020.*\u00020%2\u0006\u0010/\u001a\u00020.H\u0000\u001a\u0018\u00100\u001a\u0004\u0018\u00010.*\u00020%2\b\u0010/\u001a\u0004\u0018\u00010.H\u0002\u001a\u0014\u00101\u001a\u00020'*\u00020%2\u0006\u00102\u001a\u00020'H\u0002\u001a\f\u00103\u001a\u00020)*\u00020%H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00064"}, d2={"BIT_FLAG_ENCRYPTED", "", "BIT_FLAG_UNSUPPORTED_MASK", "CENTRAL_FILE_HEADER_SIGNATURE", "COMPRESSION_METHOD_DEFLATED", "COMPRESSION_METHOD_STORED", "END_OF_CENTRAL_DIRECTORY_SIGNATURE", "HEADER_ID_EXTENDED_TIMESTAMP", "HEADER_ID_ZIP64_EXTENDED_INFO", "LOCAL_FILE_HEADER_SIGNATURE", "MAX_ZIP_ENTRY_AND_ARCHIVE_SIZE", "", "ZIP64_EOCD_RECORD_SIGNATURE", "ZIP64_LOCATOR_SIGNATURE", "hex", "", "getHex", "(I)Ljava/lang/String;", "buildIndex", "", "Lokio/Path;", "Lokio/internal/ZipEntry;", "entries", "", "dosDateTimeToEpochMillis", "date", "time", "(II)Ljava/lang/Long;", "openZip", "Lokio/ZipFileSystem;", "zipPath", "fileSystem", "Lokio/FileSystem;", "predicate", "Lkotlin/Function1;", "", "readEntry", "Lokio/BufferedSource;", "readEocdRecord", "Lokio/internal/EocdRecord;", "readExtra", "", "extraSize", "block", "Lkotlin/Function2;", "readLocalHeader", "Lokio/FileMetadata;", "basicMetadata", "readOrSkipLocalHeader", "readZip64EocdRecord", "regularRecord", "skipLocalHeader", "okio"})
@SourceDebugExtension(value={"SMAP\nZipFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipFiles.kt\nokio/internal/ZipFilesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,459:1\n1045#2:460\n*S KotlinDebug\n*F\n+ 1 ZipFiles.kt\nokio/internal/ZipFilesKt\n*L\n156#1:460\n*E\n"})
public final class ZipFilesKt {
    private static final int LOCAL_FILE_HEADER_SIGNATURE = 67324752;
    private static final int CENTRAL_FILE_HEADER_SIGNATURE = 33639248;
    private static final int END_OF_CENTRAL_DIRECTORY_SIGNATURE = 101010256;
    private static final int ZIP64_LOCATOR_SIGNATURE = 117853008;
    private static final int ZIP64_EOCD_RECORD_SIGNATURE = 101075792;
    public static final int COMPRESSION_METHOD_DEFLATED = 8;
    public static final int COMPRESSION_METHOD_STORED = 0;
    private static final int BIT_FLAG_ENCRYPTED = 1;
    private static final int BIT_FLAG_UNSUPPORTED_MASK = 1;
    private static final long MAX_ZIP_ENTRY_AND_ARCHIVE_SIZE = 0xFFFFFFFFL;
    private static final int HEADER_ID_ZIP64_EXTENDED_INFO = 1;
    private static final int HEADER_ID_EXTENDED_TIMESTAMP = 21589;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ZipFileSystem openZip(@NotNull Path path, @NotNull FileSystem fileSystem, @NotNull Function1<? super ZipEntry, Boolean> function1) {
        Intrinsics.checkNotNullParameter(path, "zipPath");
        Intrinsics.checkNotNullParameter(fileSystem, "fileSystem");
        Intrinsics.checkNotNullParameter(function1, "predicate");
        Closeable closeable = fileSystem.openReadOnly(path);
        Throwable throwable = null;
        try {
            Object object;
            long l;
            int n;
            Object object2;
            Map<Path, ZipEntry> map;
            Object object3;
            String string;
            EocdRecord eocdRecord;
            long l2;
            FileHandle fileHandle;
            block31: {
                fileHandle = (FileHandle)closeable;
                boolean bl = false;
                long l3 = fileHandle.size() - (long)22;
                if (l3 < 0L) {
                    throw new IOException("not a zip: size=" + fileHandle.size());
                }
                long l4 = Math.max(l3 - 65536L, 0L);
                l2 = 0L;
                eocdRecord = null;
                string = null;
                do {
                    try (BufferedSource bufferedSource = Okio.buffer(fileHandle.source(l3));){
                        if (bufferedSource.readIntLe() != 101010256) continue;
                        l2 = l3;
                        eocdRecord = ZipFilesKt.readEocdRecord(bufferedSource);
                        string = bufferedSource.readUtf8(eocdRecord.getCommentByteCount());
                        break block31;
                    }
                } while ((l3 += -1L) >= l4);
                throw new IOException("not a zip: end of central directory signature not found");
            }
            long l5 = l2 - (long)20;
            if (l5 > 0L) {
                object3 = Okio.buffer(fileHandle.source(l5));
                map = null;
                try {
                    object2 = (BufferedSource)object3;
                    boolean bl = false;
                    if (object2.readIntLe() == 117853008) {
                        n = object2.readIntLe();
                        l = object2.readLongLe();
                        int n2 = object2.readIntLe();
                        if (n2 != 1 || n != 0) {
                            throw new IOException("unsupported zip: spanned");
                        }
                        Closeable closeable2 = Okio.buffer(fileHandle.source(l));
                        object = null;
                        try {
                            Object object4 = (BufferedSource)closeable2;
                            boolean bl2 = false;
                            int n3 = object4.readIntLe();
                            if (n3 != 101075792) {
                                throw new IOException("bad zip: expected " + ZipFilesKt.getHex(101075792) + " but was " + ZipFilesKt.getHex(n3));
                            }
                            eocdRecord = ZipFilesKt.readZip64EocdRecord((BufferedSource)object4, eocdRecord);
                            object4 = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            object = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally(closeable2, (Throwable)object);
                        }
                    }
                    object2 = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    map = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object3, (Throwable)((Object)map));
                }
            }
            object3 = new ArrayList();
            map = Okio.buffer(fileHandle.source(eocdRecord.getCentralDirectoryOffset()));
            object2 = null;
            try {
                Object object5 = (BufferedSource)((Object)map);
                n = 0;
                long l6 = eocdRecord.getEntryCount();
                for (l = 0L; l < l6; ++l) {
                    object = ZipFilesKt.readEntry((BufferedSource)object5);
                    if (((ZipEntry)object).getOffset() >= eocdRecord.getCentralDirectoryOffset()) {
                        throw new IOException("bad zip: local file header offset >= central directory offset");
                    }
                    if (!function1.invoke((ZipEntry)object).booleanValue()) continue;
                    ((Collection)object3).add(object);
                }
                object5 = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                object2 = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)((Object)map), (Throwable)object2);
            }
            map = ZipFilesKt.buildIndex((List<ZipEntry>)object3);
            ZipFileSystem zipFileSystem = new ZipFileSystem(path, fileSystem, map, string);
            return zipFileSystem;
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    public static /* synthetic */ ZipFileSystem openZip$default(Path path, FileSystem fileSystem, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = ZipFilesKt$openZip$1.INSTANCE;
        }
        return ZipFilesKt.openZip(path, fileSystem, function1);
    }

    private static final Map<Path, ZipEntry> buildIndex(List<ZipEntry> list) {
        Path path = Path$Companion.get$default(Path.Companion, "/", false, 1, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to(path, new ZipEntry(path, true, null, 0L, 0L, 0L, 0, null, 0L, 508, null))};
        Map<Path, ZipEntry> map = MapsKt.mutableMapOf(pairArray);
        Object object22 = list;
        boolean bl = false;
        block0: for (Object object22 : CollectionsKt.sortedWith(object22, new ZipFilesKt$buildIndex$$inlined$sortedBy$1())) {
            ZipEntry zipEntry = map.put(((ZipEntry)object22).getCanonicalPath(), (ZipEntry)object22);
            if (zipEntry != null) continue;
            Object object3 = object22;
            while (((ZipEntry)object3).getCanonicalPath().parent() != null) {
                Path path2;
                ZipEntry zipEntry2 = map.get(path2);
                if (zipEntry2 != null) {
                    ((Collection)zipEntry2.getChildren()).add(((ZipEntry)object3).getCanonicalPath());
                    continue block0;
                }
                zipEntry2 = new ZipEntry(path2, true, null, 0L, 0L, 0L, 0, null, 0L, 508, null);
                map.put(path2, zipEntry2);
                ((Collection)zipEntry2.getChildren()).add(((ZipEntry)object3).getCanonicalPath());
                object3 = zipEntry2;
            }
        }
        return map;
    }

    @NotNull
    public static final ZipEntry readEntry(@NotNull BufferedSource bufferedSource) {
        Intrinsics.checkNotNullParameter(bufferedSource, "<this>");
        int n = bufferedSource.readIntLe();
        if (n != 33639248) {
            throw new IOException("bad zip: expected " + ZipFilesKt.getHex(33639248) + " but was " + ZipFilesKt.getHex(n));
        }
        bufferedSource.skip(4L);
        int n2 = bufferedSource.readShortLe() & 0xFFFF;
        if ((n2 & 1) != 0) {
            throw new IOException("unsupported zip: general purpose bit flag=" + ZipFilesKt.getHex(n2));
        }
        int n3 = bufferedSource.readShortLe() & 0xFFFF;
        int n4 = bufferedSource.readShortLe() & 0xFFFF;
        int n5 = bufferedSource.readShortLe() & 0xFFFF;
        Long l = ZipFilesKt.dosDateTimeToEpochMillis(n5, n4);
        long l2 = (long)bufferedSource.readIntLe() & 0xFFFFFFFFL;
        Ref$LongRef ref$LongRef = new Ref$LongRef();
        ref$LongRef.element = (long)bufferedSource.readIntLe() & 0xFFFFFFFFL;
        Ref$LongRef ref$LongRef2 = new Ref$LongRef();
        ref$LongRef2.element = (long)bufferedSource.readIntLe() & 0xFFFFFFFFL;
        int n6 = bufferedSource.readShortLe() & 0xFFFF;
        int n7 = bufferedSource.readShortLe() & 0xFFFF;
        int n8 = bufferedSource.readShortLe() & 0xFFFF;
        bufferedSource.skip(8L);
        Ref$LongRef ref$LongRef3 = new Ref$LongRef();
        ref$LongRef3.element = (long)bufferedSource.readIntLe() & 0xFFFFFFFFL;
        String string = bufferedSource.readUtf8(n6);
        if (StringsKt.contains$default((CharSequence)string, '\u0000', false, 2, null)) {
            throw new IOException("bad zip: filename contains 0x00");
        }
        Object object = bufferedSource;
        boolean bl = false;
        long l3 = 0L;
        if (ref$LongRef2.element == 0xFFFFFFFFL) {
            l3 += (long)8;
        }
        if (ref$LongRef.element == 0xFFFFFFFFL) {
            l3 += (long)8;
        }
        if (ref$LongRef3.element == 0xFFFFFFFFL) {
            l3 += (long)8;
        }
        long l4 = l3;
        Ref$BooleanRef ref$BooleanRef = new Ref$BooleanRef();
        ZipFilesKt.readExtra(bufferedSource, n7, new ZipFilesKt$readEntry$1(ref$BooleanRef, l4, ref$LongRef2, bufferedSource, ref$LongRef, ref$LongRef3));
        if (l4 > 0L && !ref$BooleanRef.element) {
            throw new IOException("bad zip: zip64 extra required but absent");
        }
        object = bufferedSource.readUtf8(n8);
        Path path = Path$Companion.get$default(Path.Companion, "/", false, 1, null).resolve(string);
        boolean bl2 = StringsKt.endsWith$default(string, "/", false, 2, null);
        return new ZipEntry(path, bl2, (String)object, l2, ref$LongRef.element, ref$LongRef2.element, n3, l, ref$LongRef3.element);
    }

    private static final EocdRecord readEocdRecord(BufferedSource bufferedSource) {
        long l;
        int n = bufferedSource.readShortLe() & 0xFFFF;
        int n2 = bufferedSource.readShortLe() & 0xFFFF;
        long l2 = bufferedSource.readShortLe() & 0xFFFF;
        if (l2 != (l = (long)(bufferedSource.readShortLe() & 0xFFFF)) || n != 0 || n2 != 0) {
            throw new IOException("unsupported zip: spanned");
        }
        bufferedSource.skip(4L);
        long l3 = (long)bufferedSource.readIntLe() & 0xFFFFFFFFL;
        int n3 = bufferedSource.readShortLe() & 0xFFFF;
        return new EocdRecord(l2, l3, n3);
    }

    private static final EocdRecord readZip64EocdRecord(BufferedSource bufferedSource, EocdRecord eocdRecord) {
        bufferedSource.skip(12L);
        int n = bufferedSource.readIntLe();
        int n2 = bufferedSource.readIntLe();
        long l = bufferedSource.readLongLe();
        long l2 = bufferedSource.readLongLe();
        if (l != l2 || n != 0 || n2 != 0) {
            throw new IOException("unsupported zip: spanned");
        }
        bufferedSource.skip(8L);
        long l3 = bufferedSource.readLongLe();
        return new EocdRecord(l, l3, eocdRecord.getCommentByteCount());
    }

    private static final void readExtra(BufferedSource bufferedSource, int n, Function2<? super Integer, ? super Long, Unit> function2) {
        long l;
        for (long i = (long)n; i != 0L; i -= l) {
            if (i < 4L) {
                throw new IOException("bad zip: truncated header in extra field");
            }
            int n2 = bufferedSource.readShortLe() & 0xFFFF;
            l = (long)bufferedSource.readShortLe() & 0xFFFFL;
            if ((i -= (long)4) < l) {
                throw new IOException("bad zip: truncated value in extra field");
            }
            bufferedSource.require(l);
            long l2 = bufferedSource.getBuffer().size();
            function2.invoke((Integer)n2, (Long)l);
            long l3 = l + bufferedSource.getBuffer().size() - l2;
            if (l3 < 0L) {
                throw new IOException("unsupported zip: too many bytes processed for " + n2);
            }
            if (l3 <= 0L) continue;
            bufferedSource.getBuffer().skip(l3);
        }
    }

    public static final void skipLocalHeader(@NotNull BufferedSource bufferedSource) {
        Intrinsics.checkNotNullParameter(bufferedSource, "<this>");
        ZipFilesKt.readOrSkipLocalHeader(bufferedSource, null);
    }

    @NotNull
    public static final FileMetadata readLocalHeader(@NotNull BufferedSource bufferedSource, @NotNull FileMetadata fileMetadata) {
        Intrinsics.checkNotNullParameter(bufferedSource, "<this>");
        Intrinsics.checkNotNullParameter(fileMetadata, "basicMetadata");
        FileMetadata fileMetadata2 = ZipFilesKt.readOrSkipLocalHeader(bufferedSource, fileMetadata);
        Intrinsics.checkNotNull(fileMetadata2);
        return fileMetadata2;
    }

    private static final FileMetadata readOrSkipLocalHeader(BufferedSource bufferedSource, FileMetadata fileMetadata) {
        Ref$ObjectRef<Long> ref$ObjectRef = new Ref$ObjectRef<Long>();
        FileMetadata fileMetadata2 = fileMetadata;
        ref$ObjectRef.element = fileMetadata2 != null ? fileMetadata2.getLastModifiedAtMillis() : null;
        Ref$ObjectRef<Long> ref$ObjectRef2 = new Ref$ObjectRef<Long>();
        Ref$ObjectRef<Long> ref$ObjectRef3 = new Ref$ObjectRef<Long>();
        int n = bufferedSource.readIntLe();
        if (n != 67324752) {
            throw new IOException("bad zip: expected " + ZipFilesKt.getHex(67324752) + " but was " + ZipFilesKt.getHex(n));
        }
        bufferedSource.skip(2L);
        int n2 = bufferedSource.readShortLe() & 0xFFFF;
        if ((n2 & 1) != 0) {
            throw new IOException("unsupported zip: general purpose bit flag=" + ZipFilesKt.getHex(n2));
        }
        bufferedSource.skip(18L);
        long l = (long)bufferedSource.readShortLe() & 0xFFFFL;
        int n3 = bufferedSource.readShortLe() & 0xFFFF;
        bufferedSource.skip(l);
        if (fileMetadata == null) {
            bufferedSource.skip(n3);
            return null;
        }
        ZipFilesKt.readExtra(bufferedSource, n3, new ZipFilesKt$readOrSkipLocalHeader$1(bufferedSource, ref$ObjectRef, ref$ObjectRef2, ref$ObjectRef3));
        return new FileMetadata(fileMetadata.isRegularFile(), fileMetadata.isDirectory(), null, fileMetadata.getSize(), (Long)ref$ObjectRef3.element, (Long)ref$ObjectRef.element, (Long)ref$ObjectRef2.element, null, 128, null);
    }

    private static final Long dosDateTimeToEpochMillis(int n, int n2) {
        if (n2 == -1) {
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(14, 0);
        int n3 = 1980 + (n >> 9 & 0x7F);
        int n4 = n >> 5 & 0xF;
        int n5 = n & 0x1F;
        int n6 = n2 >> 11 & 0x1F;
        int n7 = n2 >> 5 & 0x3F;
        int n8 = (n2 & 0x1F) << 1;
        gregorianCalendar.set(n3, n4 - 1, n5, n6, n7, n8);
        return gregorianCalendar.getTime().getTime();
    }

    private static final String getHex(int n) {
        StringBuilder stringBuilder = new StringBuilder().append("0x");
        String string = Integer.toString(n, CharsKt.checkRadix(16));
        Intrinsics.checkNotNullExpressionValue(string, "toString(this, checkRadix(radix))");
        return stringBuilder.append(string).toString();
    }
}

