/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Protocol;
import okhttp3.internal.platform.Android10Platform;
import okhttp3.internal.platform.AndroidPlatform;
import okhttp3.internal.platform.BouncyCastlePlatform;
import okhttp3.internal.platform.ConscryptPlatform;
import okhttp3.internal.platform.Jdk8WithJettyBootPlatform;
import okhttp3.internal.platform.Jdk9Platform;
import okhttp3.internal.platform.OpenJSSEPlatform;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.platform.android.AndroidLog;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012J\u0014\u0010\u0016\u001a\u00020\u00172\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012J\b\u0010\u0018\u001a\u00020\u0010H\u0002J\b\u0010\u0019\u001a\u00020\u0010H\u0002J\b\u0010\u001a\u001a\u00020\u0010H\u0002J\b\u0010\u001b\u001a\u00020\u0010H\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u0014\u0010\t\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lokhttp3/internal/platform/Platform$Companion;", "", "()V", "INFO", "", "WARN", "isAndroid", "", "()Z", "isBouncyCastlePreferred", "isConscryptPreferred", "isOpenJSSEPreferred", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "platform", "Lokhttp3/internal/platform/Platform;", "alpnProtocolNames", "", "", "protocols", "Lokhttp3/Protocol;", "concatLengthPrefixed", "", "findAndroidPlatform", "findJvmPlatform", "findPlatform", "get", "resetForTests", "", "okhttp"})
@SourceDebugExtension(value={"SMAP\nPlatform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Platform.kt\nokhttp3/internal/platform/Platform$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,286:1\n766#2:287\n857#2,2:288\n1549#2:290\n1620#2,3:291\n*S KotlinDebug\n*F\n+ 1 Platform.kt\nokhttp3/internal/platform/Platform$Companion\n*L\n193#1:287\n193#1:288,2\n193#1:290\n193#1:291,3\n*E\n"})
public final class Platform$Companion {
    private Platform$Companion() {
    }

    @JvmStatic
    @NotNull
    public final Platform get() {
        return Platform.access$getPlatform$cp();
    }

    public final void resetForTests(@NotNull Platform platform) {
        Intrinsics.checkNotNullParameter(platform, "platform");
        Platform.access$setPlatform$cp(platform);
    }

    public static /* synthetic */ void resetForTests$default(Platform$Companion platform$Companion, Platform platform, int n, Object object) {
        if ((n & 1) != 0) {
            platform = platform$Companion.findPlatform();
        }
        platform$Companion.resetForTests(platform);
    }

    @NotNull
    public final List<String> alpnProtocolNames(@NotNull List<? extends Protocol> list) {
        boolean bl;
        Protocol protocol;
        Intrinsics.checkNotNullParameter(list, "protocols");
        Iterable iterable = list;
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl3 = false;
        for (Object t : iterable2) {
            protocol = (Protocol)((Object)t);
            bl = false;
            if (!(protocol != Protocol.HTTP_1_0)) continue;
            collection.add(t);
        }
        iterable = (List)collection;
        bl2 = false;
        iterable2 = iterable;
        collection = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, 10));
        bl3 = false;
        for (Object t : iterable2) {
            protocol = (Protocol)((Object)t);
            Collection collection2 = collection;
            bl = false;
            collection2.add(protocol.toString());
        }
        return (List)collection;
    }

    public final boolean isAndroid() {
        return Intrinsics.areEqual("Dalvik", System.getProperty("java.vm.name"));
    }

    private final boolean isConscryptPreferred() {
        String string = Security.getProviders()[0].getName();
        return Intrinsics.areEqual("Conscrypt", string);
    }

    private final boolean isOpenJSSEPreferred() {
        String string = Security.getProviders()[0].getName();
        return Intrinsics.areEqual("OpenJSSE", string);
    }

    private final boolean isBouncyCastlePreferred() {
        String string = Security.getProviders()[0].getName();
        return Intrinsics.areEqual("BC", string);
    }

    private final Platform findPlatform() {
        return this.isAndroid() ? this.findAndroidPlatform() : this.findJvmPlatform();
    }

    private final Platform findAndroidPlatform() {
        AndroidLog.INSTANCE.enable();
        Platform platform = Android10Platform.Companion.buildIfSupported();
        if (platform == null) {
            Platform platform2 = AndroidPlatform.Companion.buildIfSupported();
            platform = platform2;
            Intrinsics.checkNotNull(platform2);
        }
        return platform;
    }

    private final Platform findJvmPlatform() {
        Platform platform;
        if (this.isConscryptPreferred() && (platform = ConscryptPlatform.Companion.buildIfSupported()) != null) {
            return platform;
        }
        if (this.isBouncyCastlePreferred() && (platform = BouncyCastlePlatform.Companion.buildIfSupported()) != null) {
            return platform;
        }
        if (this.isOpenJSSEPreferred() && (platform = OpenJSSEPlatform.Companion.buildIfSupported()) != null) {
            return platform;
        }
        platform = Jdk9Platform.Companion.buildIfSupported();
        if (platform != null) {
            return platform;
        }
        Platform platform2 = Jdk8WithJettyBootPlatform.Companion.buildIfSupported();
        if (platform2 != null) {
            return platform2;
        }
        return new Platform();
    }

    @NotNull
    public final byte[] concatLengthPrefixed(@NotNull List<? extends Protocol> list) {
        Intrinsics.checkNotNullParameter(list, "protocols");
        Buffer buffer = new Buffer();
        for (String string : this.alpnProtocolNames(list)) {
            buffer.writeByte(string.length());
            buffer.writeUtf8(string);
        }
        return buffer.readByteArray();
    }

    public /* synthetic */ Platform$Companion(DefaultConstructorMarker defaultConstructorMarker) {
        this();
    }

    public static final /* synthetic */ Platform access$findPlatform(Platform$Companion platform$Companion) {
        return platform$Companion.findPlatform();
    }
}

