/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.io.FileSystem;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lokhttp3/internal/io/FileSystem$Companion$SystemFileSystem;", "Lokhttp3/internal/io/FileSystem;", "()V", "appendingSink", "Lokio/Sink;", "file", "Ljava/io/File;", "delete", "", "deleteContents", "directory", "exists", "", "rename", "from", "to", "sink", "size", "", "source", "Lokio/Source;", "toString", "", "okhttp"})
final class FileSystem$Companion$SystemFileSystem
implements FileSystem {
    @Override
    @NotNull
    public Source source(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return Okio.source(file);
    }

    @Override
    @NotNull
    public Sink sink(@NotNull File file) {
        Sink sink2;
        Intrinsics.checkNotNullParameter(file, "file");
        try {
            sink2 = Okio.sink$default(file, false, 1, null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            file.getParentFile().mkdirs();
            sink2 = Okio.sink$default(file, false, 1, null);
        }
        return sink2;
    }

    @Override
    @NotNull
    public Sink appendingSink(@NotNull File file) {
        Sink sink2;
        Intrinsics.checkNotNullParameter(file, "file");
        try {
            sink2 = Okio.appendingSink(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            file.getParentFile().mkdirs();
            sink2 = Okio.appendingSink(file);
        }
        return sink2;
    }

    @Override
    public void delete(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        if (!file.delete() && file.exists()) {
            throw new IOException("failed to delete " + file);
        }
    }

    @Override
    public boolean exists(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return file.exists();
    }

    @Override
    public long size(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return file.length();
    }

    @Override
    public void rename(@NotNull File file, @NotNull File file2) {
        Intrinsics.checkNotNullParameter(file, "from");
        Intrinsics.checkNotNullParameter(file2, "to");
        this.delete(file2);
        if (!file.renameTo(file2)) {
            throw new IOException("failed to rename " + file + " to " + file2);
        }
    }

    @Override
    public void deleteContents(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "directory");
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException("not a readable directory: " + file);
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                Intrinsics.checkNotNullExpressionValue(file2, "file");
                this.deleteContents(file2);
            }
            if (file2.delete()) continue;
            throw new IOException("failed to delete " + file2);
        }
    }

    @NotNull
    public String toString() {
        return "FileSystem.SYSTEM";
    }
}

