/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Headers;
import okhttp3.internal.Util;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.Http2Stream;
import okio.Buffer;
import okio.Sink;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lokhttp3/internal/http2/Http2Stream$FramingSink;", "Lokio/Sink;", "finished", "", "(Lokhttp3/internal/http2/Http2Stream;Z)V", "closed", "getClosed", "()Z", "setClosed", "(Z)V", "getFinished", "setFinished", "sendBuffer", "Lokio/Buffer;", "trailers", "Lokhttp3/Headers;", "getTrailers", "()Lokhttp3/Headers;", "setTrailers", "(Lokhttp3/Headers;)V", "close", "", "emitFrame", "outFinishedOnLastFrame", "flush", "timeout", "Lokio/Timeout;", "write", "source", "byteCount", "", "okhttp"})
@SourceDebugExtension(value={"SMAP\nHttp2Stream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Stream.kt\nokhttp3/internal/http2/Http2Stream$FramingSink\n+ 2 Util.kt\nokhttp3/internal/Util\n*L\n1#1,688:1\n615#2,4:689\n615#2,4:693\n615#2,4:697\n*S KotlinDebug\n*F\n+ 1 Http2Stream.kt\nokhttp3/internal/http2/Http2Stream$FramingSink\n*L\n528#1:689,4\n573#1:693,4\n589#1:697,4\n*E\n"})
public final class Http2Stream$FramingSink
implements Sink {
    private boolean finished;
    @NotNull
    private final Buffer sendBuffer;
    @Nullable
    private Headers trailers;
    private boolean closed;
    final /* synthetic */ Http2Stream this$0;

    public Http2Stream$FramingSink(Http2Stream http2Stream, boolean bl) {
        this.this$0 = http2Stream;
        this.finished = bl;
        this.sendBuffer = new Buffer();
    }

    public /* synthetic */ Http2Stream$FramingSink(Http2Stream http2Stream, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(http2Stream, bl);
    }

    public final boolean getFinished() {
        return this.finished;
    }

    public final void setFinished(boolean bl) {
        this.finished = bl;
    }

    @Nullable
    public final Headers getTrailers() {
        return this.trailers;
    }

    public final void setTrailers(@Nullable Headers headers) {
        this.trailers = headers;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final void setClosed(boolean bl) {
        this.closed = bl;
    }

    @Override
    public void write(@NotNull Buffer buffer, long l) {
        Intrinsics.checkNotNullParameter(buffer, "source");
        Http2Stream http2Stream = this.this$0;
        boolean bl = false;
        if (Util.assertionsEnabled && Thread.holdsLock(http2Stream)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + http2Stream));
        }
        this.sendBuffer.write(buffer, l);
        while (this.sendBuffer.size() >= 16384L) {
            this.emitFrame(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void emitFrame(boolean bl) {
        long l = 0L;
        boolean bl2 = false;
        Http2Stream http2Stream = this.this$0;
        Http2Stream http2Stream2 = this.this$0;
        Http2Stream http2Stream3 = http2Stream;
        synchronized (http2Stream3) {
            boolean bl3 = false;
            http2Stream2.getWriteTimeout$okhttp().enter();
            try {
                while (http2Stream2.getWriteBytesTotal() >= http2Stream2.getWriteBytesMaximum() && !this.finished && !this.closed && http2Stream2.getErrorCode$okhttp() == null) {
                    http2Stream2.waitForIo$okhttp();
                }
            }
            finally {
                http2Stream2.getWriteTimeout$okhttp().exitAndThrowIfTimedOut();
            }
            http2Stream2.checkOutNotClosed$okhttp();
            l = Math.min(http2Stream2.getWriteBytesMaximum() - http2Stream2.getWriteBytesTotal(), this.sendBuffer.size());
            http2Stream2.setWriteBytesTotal$okhttp(http2Stream2.getWriteBytesTotal() + l);
            bl2 = bl && l == this.sendBuffer.size();
            Unit unit = Unit.INSTANCE;
        }
        this.this$0.getWriteTimeout$okhttp().enter();
        try {
            this.this$0.getConnection().writeData(this.this$0.getId(), bl2, this.sendBuffer, l);
        }
        finally {
            this.this$0.getWriteTimeout$okhttp().exitAndThrowIfTimedOut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Http2Stream http2Stream = this.this$0;
        boolean bl = false;
        if (Util.assertionsEnabled && Thread.holdsLock(http2Stream)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + http2Stream));
        }
        http2Stream = this.this$0;
        Http2Stream http2Stream2 = this.this$0;
        Http2Stream http2Stream3 = http2Stream;
        synchronized (http2Stream3) {
            boolean bl2 = false;
            http2Stream2.checkOutNotClosed$okhttp();
            Unit unit = Unit.INSTANCE;
        }
        while (this.sendBuffer.size() > 0L) {
            this.emitFrame(false);
            this.this$0.getConnection().flush();
        }
    }

    @Override
    @NotNull
    public Timeout timeout() {
        return this.this$0.getWriteTimeout$okhttp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Http2Stream http2Stream = this.this$0;
        boolean bl = false;
        if (Util.assertionsEnabled && Thread.holdsLock(http2Stream)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + http2Stream));
        }
        boolean bl2 = false;
        Http2Stream http2Stream2 = this.this$0;
        Http2Stream http2Stream3 = this.this$0;
        Http2Stream http2Stream4 = http2Stream2;
        synchronized (http2Stream4) {
            boolean bl3 = false;
            if (this.closed) {
                return;
            }
            bl2 = http2Stream3.getErrorCode$okhttp() == null;
            Unit unit = Unit.INSTANCE;
        }
        if (!this.this$0.getSink$okhttp().finished) {
            boolean bl4 = this.sendBuffer.size() > 0L;
            boolean bl5 = this.trailers != null;
            if (bl5) {
                while (this.sendBuffer.size() > 0L) {
                    this.emitFrame(false);
                }
                Http2Connection http2Connection = this.this$0.getConnection();
                int n = this.this$0.getId();
                Headers headers = this.trailers;
                Intrinsics.checkNotNull(headers);
                http2Connection.writeHeaders$okhttp(n, bl2, Util.toHeaderList(headers));
            } else if (bl4) {
                while (this.sendBuffer.size() > 0L) {
                    this.emitFrame(true);
                }
            } else if (bl2) {
                this.this$0.getConnection().writeData(this.this$0.getId(), true, null, 0L);
            }
        }
        Http2Stream http2Stream5 = this.this$0;
        synchronized (http2Stream5) {
            boolean bl6 = false;
            this.closed = true;
            Unit unit = Unit.INSTANCE;
        }
        this.this$0.getConnection().flush();
        this.this$0.cancelStreamIfNecessary$okhttp();
    }
}

