/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http1;

import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http1.Http1ExchangeCodec;
import okhttp3.internal.http1.Http1ExchangeCodec$AbstractSource;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$ChunkedSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec$AbstractSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec;", "url", "Lokhttp3/HttpUrl;", "(Lokhttp3/internal/http1/Http1ExchangeCodec;Lokhttp3/HttpUrl;)V", "bytesRemainingInChunk", "", "hasMoreChunks", "", "close", "", "read", "sink", "Lokio/Buffer;", "byteCount", "readChunkSize", "okhttp"})
@SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$ChunkedSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,505:1\n1#2:506\n*E\n"})
final class Http1ExchangeCodec$ChunkedSource
extends Http1ExchangeCodec$AbstractSource {
    @NotNull
    private final HttpUrl url;
    private long bytesRemainingInChunk;
    private boolean hasMoreChunks;
    final /* synthetic */ Http1ExchangeCodec this$0;

    public Http1ExchangeCodec$ChunkedSource(@NotNull Http1ExchangeCodec http1ExchangeCodec, HttpUrl httpUrl) {
        Intrinsics.checkNotNullParameter(httpUrl, "url");
        this.this$0 = http1ExchangeCodec;
        super(http1ExchangeCodec);
        this.url = httpUrl;
        this.bytesRemainingInChunk = -1L;
        this.hasMoreChunks = true;
    }

    @Override
    public long read(@NotNull Buffer buffer, long l) {
        long l2;
        Intrinsics.checkNotNullParameter(buffer, "sink");
        if (!(l >= 0L)) {
            boolean bl = false;
            String string = "byteCount < 0: " + l;
            throw new IllegalArgumentException(string.toString());
        }
        if (!(!this.getClosed())) {
            boolean bl = false;
            String string = "closed";
            throw new IllegalStateException(string.toString());
        }
        if (!this.hasMoreChunks) {
            return -1L;
        }
        if (this.bytesRemainingInChunk == 0L || this.bytesRemainingInChunk == -1L) {
            this.readChunkSize();
            if (!this.hasMoreChunks) {
                return -1L;
            }
        }
        if ((l2 = super.read(buffer, Math.min(l, this.bytesRemainingInChunk))) == -1L) {
            this.this$0.getConnection().noNewExchanges$okhttp();
            ProtocolException protocolException = new ProtocolException("unexpected end of stream");
            this.responseBodyComplete();
            throw protocolException;
        }
        this.bytesRemainingInChunk -= l2;
        return l2;
    }

    private final void readChunkSize() {
        if (this.bytesRemainingInChunk != -1L) {
            Http1ExchangeCodec.access$getSource$p(this.this$0).readUtf8LineStrict();
        }
        try {
            this.bytesRemainingInChunk = Http1ExchangeCodec.access$getSource$p(this.this$0).readHexadecimalUnsignedLong();
            String string = ((Object)StringsKt.trim((CharSequence)Http1ExchangeCodec.access$getSource$p(this.this$0).readUtf8LineStrict())).toString();
            if (this.bytesRemainingInChunk < 0L || ((CharSequence)string).length() > 0 && !StringsKt.startsWith$default(string, ";", false, 2, null)) {
                throw new ProtocolException("expected chunk size and optional extensions but was \"" + this.bytesRemainingInChunk + string + '\"');
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProtocolException(numberFormatException.getMessage());
        }
        if (this.bytesRemainingInChunk == 0L) {
            this.hasMoreChunks = false;
            Http1ExchangeCodec.access$setTrailers$p(this.this$0, Http1ExchangeCodec.access$getHeadersReader$p(this.this$0).readHeaders());
            OkHttpClient okHttpClient = Http1ExchangeCodec.access$getClient$p(this.this$0);
            Intrinsics.checkNotNull(okHttpClient);
            CookieJar cookieJar = okHttpClient.cookieJar();
            Headers headers = Http1ExchangeCodec.access$getTrailers$p(this.this$0);
            Intrinsics.checkNotNull(headers);
            HttpHeaders.receiveHeaders(cookieJar, this.url, headers);
            this.responseBodyComplete();
        }
    }

    @Override
    public void close() {
        if (this.getClosed()) {
            return;
        }
        if (this.hasMoreChunks && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
            this.this$0.getConnection().noNewExchanges$okhttp();
            this.responseBodyComplete();
        }
        this.setClosed(true);
    }
}

