/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.net.ProtocolException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Protocol;
import okhttp3.Response;
import okhttp3.internal.http.StatusLine;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lokhttp3/internal/http/StatusLine$Companion;", "", "()V", "HTTP_CONTINUE", "", "HTTP_MISDIRECTED_REQUEST", "HTTP_PERM_REDIRECT", "HTTP_TEMP_REDIRECT", "get", "Lokhttp3/internal/http/StatusLine;", "response", "Lokhttp3/Response;", "parse", "statusLine", "", "okhttp"})
public final class StatusLine$Companion {
    private StatusLine$Companion() {
    }

    @NotNull
    public final StatusLine get(@NotNull Response response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return new StatusLine(response.protocol(), response.code(), response.message());
    }

    @NotNull
    public final StatusLine parse(@NotNull String string) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter(string, "statusLine");
        int n3 = 0;
        Protocol protocol = null;
        if (StringsKt.startsWith$default(string, "HTTP/1.", false, 2, null)) {
            Protocol protocol2;
            if (string.length() < 9 || string.charAt(8) != ' ') {
                throw new ProtocolException("Unexpected status line: " + string);
            }
            n2 = string.charAt(7) - 48;
            n3 = 9;
            switch (n2) {
                case 0: {
                    protocol2 = Protocol.HTTP_1_0;
                    break;
                }
                case 1: {
                    protocol2 = Protocol.HTTP_1_1;
                    break;
                }
                default: {
                    throw new ProtocolException("Unexpected status line: " + string);
                }
            }
            protocol = protocol2;
        } else if (StringsKt.startsWith$default(string, "ICY ", false, 2, null)) {
            protocol = Protocol.HTTP_1_0;
            n3 = 4;
        } else {
            throw new ProtocolException("Unexpected status line: " + string);
        }
        if (string.length() < n3 + 3) {
            throw new ProtocolException("Unexpected status line: " + string);
        }
        try {
            String string2 = string.substring(n3, n3 + 3);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProtocolException("Unexpected status line: " + string);
        }
        n2 = n;
        String string3 = "";
        if (string.length() > n3 + 3) {
            if (string.charAt(n3 + 3) != ' ') {
                throw new ProtocolException("Unexpected status line: " + string);
            }
            String string4 = string.substring(n3 + 4);
            Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String).substring(startIndex)");
            string3 = string4;
        }
        return new StatusLine(protocol, n2, string3);
    }

    public /* synthetic */ StatusLine$Companion(DefaultConstructorMarker defaultConstructorMarker) {
        this();
    }
}

