/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.Reference;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.CertificatePinner;
import okhttp3.Connection;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.cache.CacheInterceptor;
import okhttp3.internal.connection.ConnectInterceptor;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.ExchangeFinder;
import okhttp3.internal.connection.RealCall$AsyncCall;
import okhttp3.internal.connection.RealCall$CallReference;
import okhttp3.internal.connection.RealCall$timeout$1;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.http.BridgeInterceptor;
import okhttp3.internal.http.CallServerInterceptor;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http.RetryAndFollowUpInterceptor;
import okhttp3.internal.platform.Platform;
import okio.AsyncTimeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a7\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001.\u0018\u00002\u00020\u0001:\u0002deB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u00101\u001a\u0002022\u0006\u0010\u0010\u001a\u00020\u000fJ!\u00103\u001a\u0002H4\"\n\b\u0000\u00104*\u0004\u0018\u0001052\u0006\u00106\u001a\u0002H4H\u0002\u00a2\u0006\u0002\u00107J\b\u00108\u001a\u000202H\u0002J\b\u00109\u001a\u000202H\u0016J\b\u0010:\u001a\u00020\u0000H\u0016J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u0002022\u0006\u0010@\u001a\u00020AH\u0016J\u0016\u0010B\u001a\u0002022\u0006\u0010C\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\u0007J\b\u0010E\u001a\u00020FH\u0016J\u0015\u0010G\u001a\u0002022\u0006\u0010H\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\bIJ\r\u0010J\u001a\u00020FH\u0000\u00a2\u0006\u0002\bKJ\u0015\u0010L\u001a\u00020\u001e2\u0006\u0010M\u001a\u00020NH\u0000\u00a2\u0006\u0002\bOJ\b\u0010P\u001a\u00020\u0007H\u0016J\b\u0010Q\u001a\u00020\u0007H\u0016J;\u0010R\u001a\u0002H4\"\n\b\u0000\u00104*\u0004\u0018\u0001052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010S\u001a\u00020\u00072\u0006\u0010T\u001a\u00020\u00072\u0006\u00106\u001a\u0002H4H\u0000\u00a2\u0006\u0004\bU\u0010VJ\u0019\u0010W\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u000105H\u0000\u00a2\u0006\u0002\bXJ\r\u0010Y\u001a\u00020ZH\u0000\u00a2\u0006\u0002\b[J\u000f\u0010\\\u001a\u0004\u0018\u00010]H\u0000\u00a2\u0006\u0002\b^J\b\u0010C\u001a\u00020\u0005H\u0016J\u0006\u0010_\u001a\u00020\u0007J\b\u0010-\u001a\u00020`H\u0016J\u0006\u00100\u001a\u000202J!\u0010a\u001a\u0002H4\"\n\b\u0000\u00104*\u0004\u0018\u0001052\u0006\u0010b\u001a\u0002H4H\u0002\u00a2\u0006\u0002\u00107J\b\u0010c\u001a\u00020ZH\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\"\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\"\u0010&\u001a\u0004\u0018\u00010\u001e2\b\u0010\u000e\u001a\u0004\u0018\u00010\u001e@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010/R\u000e\u00100\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"Lokhttp3/internal/connection/RealCall;", "Lokhttp3/Call;", "client", "Lokhttp3/OkHttpClient;", "originalRequest", "Lokhttp3/Request;", "forWebSocket", "", "(Lokhttp3/OkHttpClient;Lokhttp3/Request;Z)V", "callStackTrace", "", "canceled", "getClient", "()Lokhttp3/OkHttpClient;", "<set-?>", "Lokhttp3/internal/connection/RealConnection;", "connection", "getConnection", "()Lokhttp3/internal/connection/RealConnection;", "connectionPool", "Lokhttp3/internal/connection/RealConnectionPool;", "connectionToCancel", "getConnectionToCancel", "setConnectionToCancel", "(Lokhttp3/internal/connection/RealConnection;)V", "eventListener", "Lokhttp3/EventListener;", "getEventListener$okhttp", "()Lokhttp3/EventListener;", "exchange", "Lokhttp3/internal/connection/Exchange;", "exchangeFinder", "Lokhttp3/internal/connection/ExchangeFinder;", "executed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "expectMoreExchanges", "getForWebSocket", "()Z", "interceptorScopedExchange", "getInterceptorScopedExchange$okhttp", "()Lokhttp3/internal/connection/Exchange;", "getOriginalRequest", "()Lokhttp3/Request;", "requestBodyOpen", "responseBodyOpen", "timeout", "okhttp3/internal/connection/RealCall$timeout$1", "Lokhttp3/internal/connection/RealCall$timeout$1;", "timeoutEarlyExit", "acquireConnectionNoEvents", "", "callDone", "E", "Ljava/io/IOException;", "e", "(Ljava/io/IOException;)Ljava/io/IOException;", "callStart", "cancel", "clone", "createAddress", "Lokhttp3/Address;", "url", "Lokhttp3/HttpUrl;", "enqueue", "responseCallback", "Lokhttp3/Callback;", "enterNetworkInterceptorExchange", "request", "newExchangeFinder", "execute", "Lokhttp3/Response;", "exitNetworkInterceptorExchange", "closeExchange", "exitNetworkInterceptorExchange$okhttp", "getResponseWithInterceptorChain", "getResponseWithInterceptorChain$okhttp", "initExchange", "chain", "Lokhttp3/internal/http/RealInterceptorChain;", "initExchange$okhttp", "isCanceled", "isExecuted", "messageDone", "requestDone", "responseDone", "messageDone$okhttp", "(Lokhttp3/internal/connection/Exchange;ZZLjava/io/IOException;)Ljava/io/IOException;", "noMoreExchanges", "noMoreExchanges$okhttp", "redactedUrl", "", "redactedUrl$okhttp", "releaseConnectionNoEvents", "Ljava/net/Socket;", "releaseConnectionNoEvents$okhttp", "retryAfterFailure", "Lokio/AsyncTimeout;", "timeoutExit", "cause", "toLoggableString", "AsyncCall", "CallReference", "okhttp"})
@SourceDebugExtension(value={"SMAP\nRealCall.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealCall.kt\nokhttp3/internal/connection/RealCall\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Util.kt\nokhttp3/internal/Util\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,551:1\n1#2:552\n608#3,4:553\n615#3,4:557\n615#3,4:561\n608#3,4:565\n350#4,7:569\n*S KotlinDebug\n*F\n+ 1 RealCall.kt\nokhttp3/internal/connection/RealCall\n*L\n269#1:553,4\n344#1:557,4\n348#1:561,4\n375#1:565,4\n378#1:569,7\n*E\n"})
public final class RealCall
implements Call {
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final Request originalRequest;
    private final boolean forWebSocket;
    @NotNull
    private final RealConnectionPool connectionPool;
    @NotNull
    private final EventListener eventListener;
    @NotNull
    private final RealCall$timeout$1 timeout;
    @NotNull
    private final AtomicBoolean executed;
    @Nullable
    private Object callStackTrace;
    @Nullable
    private ExchangeFinder exchangeFinder;
    @Nullable
    private RealConnection connection;
    private boolean timeoutEarlyExit;
    @Nullable
    private Exchange interceptorScopedExchange;
    private boolean requestBodyOpen;
    private boolean responseBodyOpen;
    private boolean expectMoreExchanges;
    private volatile boolean canceled;
    @Nullable
    private volatile Exchange exchange;
    @Nullable
    private volatile RealConnection connectionToCancel;

    public RealCall(@NotNull OkHttpClient okHttpClient, @NotNull Request request, boolean bl) {
        RealCall$timeout$1 realCall$timeout$1;
        Intrinsics.checkNotNullParameter(okHttpClient, "client");
        Intrinsics.checkNotNullParameter(request, "originalRequest");
        this.client = okHttpClient;
        this.originalRequest = request;
        this.forWebSocket = bl;
        this.connectionPool = this.client.connectionPool().getDelegate$okhttp();
        this.eventListener = this.client.eventListenerFactory().create(this);
        RealCall$timeout$1 realCall$timeout$12 = realCall$timeout$1 = new RealCall$timeout$1(this);
        RealCall realCall = this;
        boolean bl2 = false;
        realCall$timeout$12.timeout(this.client.callTimeoutMillis(), TimeUnit.MILLISECONDS);
        realCall.timeout = realCall$timeout$1;
        this.executed = new AtomicBoolean();
        this.expectMoreExchanges = true;
    }

    @NotNull
    public final OkHttpClient getClient() {
        return this.client;
    }

    @NotNull
    public final Request getOriginalRequest() {
        return this.originalRequest;
    }

    public final boolean getForWebSocket() {
        return this.forWebSocket;
    }

    @NotNull
    public final EventListener getEventListener$okhttp() {
        return this.eventListener;
    }

    @Nullable
    public final RealConnection getConnection() {
        return this.connection;
    }

    @Nullable
    public final Exchange getInterceptorScopedExchange$okhttp() {
        return this.interceptorScopedExchange;
    }

    @Nullable
    public final RealConnection getConnectionToCancel() {
        return this.connectionToCancel;
    }

    public final void setConnectionToCancel(@Nullable RealConnection realConnection) {
        this.connectionToCancel = realConnection;
    }

    @Override
    @NotNull
    public AsyncTimeout timeout() {
        return this.timeout;
    }

    @Override
    @NotNull
    public RealCall clone() {
        return new RealCall(this.client, this.originalRequest, this.forWebSocket);
    }

    @Override
    @NotNull
    public Request request() {
        return this.originalRequest;
    }

    @Override
    public void cancel() {
        if (this.canceled) {
            return;
        }
        this.canceled = true;
        Exchange exchange = this.exchange;
        if (exchange != null) {
            exchange.cancel();
        }
        RealConnection realConnection = this.connectionToCancel;
        if (realConnection != null) {
            realConnection.cancel();
        }
        this.eventListener.canceled(this);
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Response execute() {
        if (!this.executed.compareAndSet(false, true)) {
            boolean bl = false;
            String string = "Already Executed";
            throw new IllegalStateException(string.toString());
        }
        this.timeout.enter();
        this.callStart();
        try {
            this.client.dispatcher().executed$okhttp(this);
            Response response = this.getResponseWithInterceptorChain$okhttp();
            return response;
        }
        finally {
            this.client.dispatcher().finished$okhttp(this);
        }
    }

    @Override
    public void enqueue(@NotNull Callback callback) {
        Intrinsics.checkNotNullParameter(callback, "responseCallback");
        if (!this.executed.compareAndSet(false, true)) {
            boolean bl = false;
            String string = "Already Executed";
            throw new IllegalStateException(string.toString());
        }
        this.callStart();
        this.client.dispatcher().enqueue$okhttp(new RealCall$AsyncCall(this, callback));
    }

    @Override
    public boolean isExecuted() {
        return this.executed.get();
    }

    private final void callStart() {
        this.callStackTrace = Platform.Companion.get().getStackTraceForCloseable("response.body().close()");
        this.eventListener.callStart(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Response getResponseWithInterceptorChain$okhttp() {
        Response response;
        List list = new ArrayList();
        CollectionsKt.addAll((Collection)list, (Iterable)this.client.interceptors());
        ((Collection)list).add(new RetryAndFollowUpInterceptor(this.client));
        ((Collection)list).add(new BridgeInterceptor(this.client.cookieJar()));
        ((Collection)list).add(new CacheInterceptor(this.client.cache()));
        ((Collection)list).add(ConnectInterceptor.INSTANCE);
        if (!this.forWebSocket) {
            CollectionsKt.addAll((Collection)list, (Iterable)this.client.networkInterceptors());
        }
        ((Collection)list).add(new CallServerInterceptor(this.forWebSocket));
        RealInterceptorChain realInterceptorChain = new RealInterceptorChain(this, list, 0, null, this.originalRequest, this.client.connectTimeoutMillis(), this.client.readTimeoutMillis(), this.client.writeTimeoutMillis());
        boolean bl = false;
        try {
            Response response2 = realInterceptorChain.proceed(this.originalRequest);
            if (this.isCanceled()) {
                Util.closeQuietly(response2);
                throw new IOException("Canceled");
            }
            response = response2;
        }
        catch (IOException iOException) {
            try {
                bl = true;
                IOException iOException2 = this.noMoreExchanges$okhttp(iOException);
                Intrinsics.checkNotNull(iOException2, "null cannot be cast to non-null type kotlin.Throwable");
                throw (Throwable)iOException2;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    this.noMoreExchanges$okhttp(null);
                }
                throw throwable;
            }
        }
        this.noMoreExchanges$okhttp(null);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enterNetworkInterceptorExchange(@NotNull Request request, boolean bl) {
        Intrinsics.checkNotNullParameter(request, "request");
        if (!(this.interceptorScopedExchange == null)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        RealCall realCall = this;
        synchronized (realCall) {
            boolean bl2 = false;
            if (!(!this.responseBodyOpen)) {
                boolean bl3 = false;
                String string = "cannot make a new request because the previous response is still open: please call response.close()";
                throw new IllegalStateException(string.toString());
            }
            if (!(!this.requestBodyOpen)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        if (bl) {
            this.exchangeFinder = new ExchangeFinder(this.connectionPool, this.createAddress(request.url()), this, this.eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Exchange initExchange$okhttp(@NotNull RealInterceptorChain realInterceptorChain) {
        Exchange exchange;
        Object object;
        Intrinsics.checkNotNullParameter(realInterceptorChain, "chain");
        Object object2 = this;
        synchronized (object2) {
            boolean bl = false;
            if (!this.expectMoreExchanges) {
                boolean bl2 = false;
                String string = "released";
                throw new IllegalStateException(string.toString());
            }
            if (!(!this.responseBodyOpen)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            if (!(!this.requestBodyOpen)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            object = Unit.INSTANCE;
        }
        ExchangeFinder exchangeFinder = this.exchangeFinder;
        Intrinsics.checkNotNull(exchangeFinder);
        object2 = exchangeFinder;
        object = ((ExchangeFinder)object2).find(this.client, realInterceptorChain);
        this.interceptorScopedExchange = exchange = new Exchange(this, this.eventListener, (ExchangeFinder)object2, (ExchangeCodec)object);
        this.exchange = exchange;
        RealCall realCall = this;
        synchronized (realCall) {
            boolean bl = false;
            this.requestBodyOpen = true;
            this.responseBodyOpen = true;
            Unit unit = Unit.INSTANCE;
        }
        if (this.canceled) {
            throw new IOException("Canceled");
        }
        return exchange;
    }

    public final void acquireConnectionNoEvents(@NotNull RealConnection realConnection) {
        Intrinsics.checkNotNullParameter(realConnection, "connection");
        RealConnection realConnection2 = realConnection;
        boolean bl = false;
        if (Util.assertionsEnabled && !Thread.holdsLock(realConnection2)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + realConnection2));
        }
        if (!(this.connection == null)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.connection = realConnection;
        realConnection.getCalls().add(new RealCall$CallReference(this, this.callStackTrace));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <E extends IOException> E messageDone$okhttp(@NotNull Exchange exchange, boolean bl, boolean bl2, E e) {
        Intrinsics.checkNotNullParameter(exchange, "exchange");
        if (!Intrinsics.areEqual(exchange, this.exchange)) {
            return e;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        RealCall realCall = this;
        synchronized (realCall) {
            boolean bl5 = false;
            if (bl && this.requestBodyOpen || bl2 && this.responseBodyOpen) {
                if (bl) {
                    this.requestBodyOpen = false;
                }
                if (bl2) {
                    this.responseBodyOpen = false;
                }
                bl3 = !this.requestBodyOpen && !this.responseBodyOpen;
                bl4 = !this.requestBodyOpen && !this.responseBodyOpen && !this.expectMoreExchanges;
            }
            Unit unit = Unit.INSTANCE;
        }
        if (bl3) {
            this.exchange = null;
            RealConnection realConnection = this.connection;
            if (realConnection != null) {
                realConnection.incrementSuccessCount$okhttp();
            }
        }
        if (bl4) {
            return this.callDone(e);
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final IOException noMoreExchanges$okhttp(@Nullable IOException iOException) {
        boolean bl = false;
        RealCall realCall = this;
        synchronized (realCall) {
            boolean bl2 = false;
            if (this.expectMoreExchanges) {
                this.expectMoreExchanges = false;
                bl = !this.requestBodyOpen && !this.responseBodyOpen;
            }
            Unit unit = Unit.INSTANCE;
        }
        if (bl) {
            return this.callDone(iOException);
        }
        return iOException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <E extends IOException> E callDone(E e) {
        Object object = this;
        boolean bl = false;
        if (Util.assertionsEnabled && Thread.holdsLock(object)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + object));
        }
        object = this.connection;
        if (object != null) {
            Object object2;
            Object object3 = object;
            boolean bl2 = false;
            if (Util.assertionsEnabled && Thread.holdsLock(object3)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + object3));
            }
            Object object4 = object;
            synchronized (object4) {
                boolean bl3 = false;
                object2 = this.releaseConnectionNoEvents$okhttp();
            }
            object3 = object2;
            if (this.connection == null) {
                Object object5 = object3;
                if (object5 != null) {
                    Util.closeQuietly((Socket)object5);
                }
                this.eventListener.connectionReleased(this, (Connection)object);
            } else if (!(object3 == null)) {
                object2 = "Check failed.";
                throw new IllegalStateException(object2.toString());
            }
        }
        E e2 = this.timeoutExit(e);
        if (e != null) {
            Call call = this;
            E e3 = e2;
            Intrinsics.checkNotNull(e3);
            this.eventListener.callFailed(call, e3);
        } else {
            this.eventListener.callEnd(this);
        }
        return e2;
    }

    @Nullable
    public final Socket releaseConnectionNoEvents$okhttp() {
        int n;
        Object object;
        RealConnection realConnection;
        block6: {
            int n2;
            RealConnection realConnection2 = this.connection;
            Intrinsics.checkNotNull(realConnection2);
            realConnection = realConnection2;
            object = realConnection;
            n = 0;
            if (Util.assertionsEnabled && !Thread.holdsLock(object)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + object));
            }
            Object object2 = object = realConnection.getCalls();
            boolean bl = false;
            int n3 = 0;
            Iterator iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Reference reference = (Reference)e;
                boolean bl2 = false;
                if (Intrinsics.areEqual(reference.get(), this)) {
                    n2 = n3;
                    break block6;
                }
                ++n3;
            }
            n2 = n = -1;
        }
        if (!(n != -1)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        object.remove(n);
        this.connection = null;
        if (object.isEmpty()) {
            realConnection.setIdleAtNs$okhttp(System.nanoTime());
            if (this.connectionPool.connectionBecameIdle(realConnection)) {
                return realConnection.socket();
            }
        }
        return null;
    }

    private final <E extends IOException> E timeoutExit(E e) {
        if (this.timeoutEarlyExit) {
            return e;
        }
        if (!this.timeout.exit()) {
            return e;
        }
        InterruptedIOException interruptedIOException = new InterruptedIOException("timeout");
        if (e != null) {
            interruptedIOException.initCause(e);
        }
        return (E)interruptedIOException;
    }

    public final void timeoutEarlyExit() {
        if (!(!this.timeoutEarlyExit)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.timeoutEarlyExit = true;
        this.timeout.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void exitNetworkInterceptorExchange$okhttp(boolean bl) {
        RealCall realCall = this;
        synchronized (realCall) {
            boolean bl2 = false;
            if (!this.expectMoreExchanges) {
                boolean bl3 = false;
                String string = "released";
                throw new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        if (bl) {
            Exchange exchange = this.exchange;
            if (exchange != null) {
                exchange.detachWithViolence();
            }
        }
        this.interceptorScopedExchange = null;
    }

    private final Address createAddress(HttpUrl httpUrl) {
        SSLSocketFactory sSLSocketFactory = null;
        HostnameVerifier hostnameVerifier = null;
        CertificatePinner certificatePinner = null;
        if (httpUrl.isHttps()) {
            sSLSocketFactory = this.client.sslSocketFactory();
            hostnameVerifier = this.client.hostnameVerifier();
            certificatePinner = this.client.certificatePinner();
        }
        return new Address(httpUrl.host(), httpUrl.port(), this.client.dns(), this.client.socketFactory(), sSLSocketFactory, hostnameVerifier, certificatePinner, this.client.proxyAuthenticator(), this.client.proxy(), this.client.protocols(), this.client.connectionSpecs(), this.client.proxySelector());
    }

    public final boolean retryAfterFailure() {
        ExchangeFinder exchangeFinder = this.exchangeFinder;
        Intrinsics.checkNotNull(exchangeFinder);
        return exchangeFinder.retryAfterFailure();
    }

    private final String toLoggableString() {
        return (this.isCanceled() ? "canceled " : "") + (this.forWebSocket ? "web socket" : "call") + " to " + this.redactedUrl$okhttp();
    }

    @NotNull
    public final String redactedUrl$okhttp() {
        return this.originalRequest.url().redact();
    }

    public static final /* synthetic */ RealCall$timeout$1 access$getTimeout$p(RealCall realCall) {
        return realCall.timeout;
    }

    public static final /* synthetic */ String access$toLoggableString(RealCall realCall) {
        return realCall.toLoggableString();
    }
}

