/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache2;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.cache2.FileOperator;
import okhttp3.internal.cache2.Relay;
import okio.Buffer;
import okio.ByteString;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lokhttp3/internal/cache2/Relay$Companion;", "", "()V", "FILE_HEADER_SIZE", "", "PREFIX_CLEAN", "Lokio/ByteString;", "PREFIX_DIRTY", "SOURCE_FILE", "", "SOURCE_UPSTREAM", "edit", "Lokhttp3/internal/cache2/Relay;", "file", "Ljava/io/File;", "upstream", "Lokio/Source;", "metadata", "bufferMaxSize", "read", "okhttp"})
public final class Relay$Companion {
    private Relay$Companion() {
    }

    @NotNull
    public final Relay edit(@NotNull File file, @NotNull Source source2, @NotNull ByteString byteString, long l) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(source2, "upstream");
        Intrinsics.checkNotNullParameter(byteString, "metadata");
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        Relay relay = new Relay(randomAccessFile, source2, 0L, byteString, l, null);
        randomAccessFile.setLength(0L);
        Relay.access$writeHeader(relay, Relay.PREFIX_DIRTY, -1L, -1L);
        return relay;
    }

    @NotNull
    public final Relay read(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        FileChannel fileChannel = randomAccessFile.getChannel();
        Intrinsics.checkNotNullExpressionValue(fileChannel, "randomAccessFile.channel");
        FileOperator fileOperator = new FileOperator(fileChannel);
        Buffer buffer = new Buffer();
        fileOperator.read(0L, buffer, 32L);
        ByteString byteString = buffer.readByteString(Relay.PREFIX_CLEAN.size());
        if (!Intrinsics.areEqual(byteString, Relay.PREFIX_CLEAN)) {
            throw new IOException("unreadable cache file");
        }
        long l = buffer.readLong();
        long l2 = buffer.readLong();
        Buffer buffer2 = new Buffer();
        fileOperator.read(32L + l, buffer2, l2);
        ByteString byteString2 = buffer2.readByteString();
        return new Relay(randomAccessFile, null, l, byteString2, 0L, null);
    }

    public /* synthetic */ Relay$Companion(DefaultConstructorMarker defaultConstructorMarker) {
        this();
    }
}

