/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody$Companion;
import okhttp3.MultipartBody$Part;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0003\"#$B%\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\r\u0010\n\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\b\u0015J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0012J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\b\u0018J\r\u0010\u0011\u001a\u00020\u0012H\u0007\u00a2\u0006\u0002\b\u0019J\r\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b\u001aJ\u001a\u0010\u001b\u001a\u00020\u000e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\n\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128G\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0014\u00a8\u0006%"}, d2={"Lokhttp3/MultipartBody;", "Lokhttp3/RequestBody;", "boundaryByteString", "Lokio/ByteString;", "type", "Lokhttp3/MediaType;", "parts", "", "Lokhttp3/MultipartBody$Part;", "(Lokio/ByteString;Lokhttp3/MediaType;Ljava/util/List;)V", "boundary", "", "()Ljava/lang/String;", "contentLength", "", "contentType", "()Ljava/util/List;", "size", "", "()I", "()Lokhttp3/MediaType;", "-deprecated_boundary", "part", "index", "-deprecated_parts", "-deprecated_size", "-deprecated_type", "writeOrCountBytes", "sink", "Lokio/BufferedSink;", "countBytes", "", "writeTo", "", "Builder", "Companion", "Part", "okhttp"})
public final class MultipartBody
extends RequestBody {
    @NotNull
    public static final MultipartBody$Companion Companion = new MultipartBody$Companion(null);
    @NotNull
    private final ByteString boundaryByteString;
    @NotNull
    private final MediaType type;
    @NotNull
    private final List<MultipartBody$Part> parts;
    @NotNull
    private final MediaType contentType;
    private long contentLength;
    @JvmField
    @NotNull
    public static final MediaType MIXED = MediaType.Companion.get("multipart/mixed");
    @JvmField
    @NotNull
    public static final MediaType ALTERNATIVE = MediaType.Companion.get("multipart/alternative");
    @JvmField
    @NotNull
    public static final MediaType DIGEST = MediaType.Companion.get("multipart/digest");
    @JvmField
    @NotNull
    public static final MediaType PARALLEL = MediaType.Companion.get("multipart/parallel");
    @JvmField
    @NotNull
    public static final MediaType FORM = MediaType.Companion.get("multipart/form-data");
    @NotNull
    private static final byte[] COLONSPACE;
    @NotNull
    private static final byte[] CRLF;
    @NotNull
    private static final byte[] DASHDASH;

    public MultipartBody(@NotNull ByteString byteString, @NotNull MediaType mediaType, @NotNull List<MultipartBody$Part> list) {
        Intrinsics.checkNotNullParameter(byteString, "boundaryByteString");
        Intrinsics.checkNotNullParameter(mediaType, "type");
        Intrinsics.checkNotNullParameter(list, "parts");
        this.boundaryByteString = byteString;
        this.type = mediaType;
        this.parts = list;
        this.contentType = MediaType.Companion.get(this.type + "; boundary=" + this.boundary());
        this.contentLength = -1L;
    }

    @JvmName(name="type")
    @NotNull
    public final MediaType type() {
        return this.type;
    }

    @JvmName(name="parts")
    @NotNull
    public final List<MultipartBody$Part> parts() {
        return this.parts;
    }

    @JvmName(name="boundary")
    @NotNull
    public final String boundary() {
        return this.boundaryByteString.utf8();
    }

    @JvmName(name="size")
    public final int size() {
        return this.parts.size();
    }

    @NotNull
    public final MultipartBody$Part part(int n) {
        return this.parts.get(n);
    }

    @Override
    @NotNull
    public MediaType contentType() {
        return this.contentType;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="type", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_type")
    @NotNull
    public final MediaType -deprecated_type() {
        return this.type;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="boundary", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_boundary")
    @NotNull
    public final String -deprecated_boundary() {
        return this.boundary();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="size", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_size")
    public final int -deprecated_size() {
        return this.size();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="parts", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_parts")
    @NotNull
    public final List<MultipartBody$Part> -deprecated_parts() {
        return this.parts;
    }

    @Override
    public long contentLength() {
        long l = this.contentLength;
        if (l == -1L) {
            this.contentLength = l = this.writeOrCountBytes(null, true);
        }
        return l;
    }

    @Override
    public void writeTo(@NotNull BufferedSink bufferedSink) {
        Intrinsics.checkNotNullParameter(bufferedSink, "sink");
        this.writeOrCountBytes(bufferedSink, false);
    }

    private final long writeOrCountBytes(BufferedSink bufferedSink, boolean bl) {
        BufferedSink bufferedSink2 = bufferedSink;
        long l = 0L;
        Buffer buffer = null;
        if (bl) {
            buffer = new Buffer();
            bufferedSink2 = buffer;
        }
        int n = this.parts.size();
        for (int i = 0; i < n; ++i) {
            long l2;
            MediaType mediaType;
            MultipartBody$Part multipartBody$Part = this.parts.get(i);
            Headers headers = multipartBody$Part.headers();
            RequestBody requestBody = multipartBody$Part.body();
            BufferedSink bufferedSink3 = bufferedSink2;
            Intrinsics.checkNotNull(bufferedSink3);
            bufferedSink3.write(DASHDASH);
            bufferedSink2.write(this.boundaryByteString);
            bufferedSink2.write(CRLF);
            if (headers != null) {
                int n2 = headers.size();
                for (int j = 0; j < n2; ++j) {
                    bufferedSink2.writeUtf8(headers.name(j)).write(COLONSPACE).writeUtf8(headers.value(j)).write(CRLF);
                }
            }
            if ((mediaType = requestBody.contentType()) != null) {
                bufferedSink2.writeUtf8("Content-Type: ").writeUtf8(mediaType.toString()).write(CRLF);
            }
            if ((l2 = requestBody.contentLength()) != -1L) {
                bufferedSink2.writeUtf8("Content-Length: ").writeDecimalLong(l2).write(CRLF);
            } else if (bl) {
                Buffer buffer2 = buffer;
                Intrinsics.checkNotNull(buffer2);
                buffer2.clear();
                return -1L;
            }
            bufferedSink2.write(CRLF);
            if (bl) {
                l += l2;
            } else {
                requestBody.writeTo(bufferedSink2);
            }
            bufferedSink2.write(CRLF);
        }
        BufferedSink bufferedSink4 = bufferedSink2;
        Intrinsics.checkNotNull(bufferedSink4);
        bufferedSink4.write(DASHDASH);
        bufferedSink2.write(this.boundaryByteString);
        bufferedSink2.write(DASHDASH);
        bufferedSink2.write(CRLF);
        if (bl) {
            Buffer buffer3 = buffer;
            Intrinsics.checkNotNull(buffer3);
            l += buffer3.size();
            buffer.clear();
        }
        return l;
    }

    static {
        byte[] byArray = new byte[]{58, 32};
        COLONSPACE = byArray;
        byArray = new byte[]{13, 10};
        CRLF = byArray;
        byArray = new byte[]{45, 45};
        DASHDASH = byArray;
    }
}

